/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;

public abstract class OWLTableTransferHandler
extends TransferHandler {
    private boolean inTransaction = false;
    private OWLModel owlModel;
    protected int[] rows = null;

    public OWLTableTransferHandler(OWLModel owlModel) {
        this.owlModel = owlModel;
    }

    protected boolean addRow(OWLTableModel tableModel, RDFSClass clone, int index) {
        return tableModel.addRow(clone, index);
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        OWLTable table = (OWLTable)((Object)c);
        if (table.getOWLTableModel().isEditable()) {
            int i = 0;
            while (i < flavors.length) {
                DataFlavor dataFlavor = flavors[i];
                if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void cleanup(JComponent c, boolean remove) {
        this.rows = null;
        if (this.inTransaction) {
            this.inTransaction = false;
            this.owlModel.endTransaction();
        }
    }

    protected Transferable createTransferable(JComponent c) {
        JTable table = (JTable)c;
        int[] rows = table.getSelectedRows();
        if (rows.length > 0) {
            return this.exportOWLClses(table);
        }
        return null;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
        this.cleanup(c, action == 2);
    }

    protected Transferable exportOWLClses(JComponent c) {
        JTable table = (JTable)c;
        OWLTableModel model = (OWLTableModel)table.getModel();
        this.rows = table.getSelectedRows();
        String str = "";
        int i = 0;
        while (i < this.rows.length) {
            RDFSClass cls = model.getClass(this.rows[i]);
            if (cls != null) {
                str = String.valueOf(str) + cls.getBrowserText();
                if (i < this.rows.length - 1) {
                    str = String.valueOf(str) + "\n";
                }
            } else {
                this.rows = null;
                return null;
            }
            ++i;
        }
        return new StringSelection(str);
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    protected OWLNamedClass getRootCls() {
        return this.owlModel.getOWLThingClass();
    }

    protected int importOWLClses(JComponent c, String clsesText) {
        OWLTable target = (OWLTable)((Object)c);
        OWLTableModel model = (OWLTableModel)target.getModel();
        int index = target.getSelectedRow();
        if (this.rows != null && index >= this.rows[0] && index <= this.rows[this.rows.length - 1]) {
            this.rows = null;
            return -1;
        }
        if (index < 0) {
            index = model.getRowCount();
        }
        int result = index;
        try {
            try {
                this.owlModel.beginTransaction("Drag and drop in classes/conditions");
                String[] values = clsesText.split("\n");
                int i = 0;
                while (i < values.length) {
                    String text = values[i];
                    RDFSClass clone = this.owlModel.getOWLClassDisplay().getParser().parseClass(this.owlModel, text);
                    boolean added = this.addRow(model, clone, index);
                    if (added) {
                        target.setSelectedRow(clone);
                    } else {
                        this.rows = null;
                        result = -1;
                    }
                    ++index;
                    if (!added && clone instanceof OWLAnonymousClass) {
                        clone.delete();
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        finally {
            this.inTransaction = true;
        }
        return result;
    }

    public boolean importData(JComponent c, Transferable t) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                return this.importOWLClses(c, str) >= 0;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

