/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

import java.io.IOException;
import java.util.List;

/**
 * This interface describes class that can be used to look up service profiles
 * 
 * @author tilmann
 */
public interface ServiceProfileLocator {

	/**
	 * Sets the search parameter for subsequent calls to findServiceProfiles
	 * 
	 * @param searchParameter
	 *            the parameters the services shoud have
	 */
	public void setServiceProfileParameter(
			ServiceProfileParameter searchParameter);

	/**
	 * This method can be used to search for services profiles suitable to the
	 * previously set searchParameters. The resulting list may also contain
	 * services that do not perfectly match the parameters. This is indicated
	 * with a relevance below 1. How exact sercice profiles are matched can be
	 * specified wiht the searchLevel parameter. Subsequent calls for a single
	 * search parameter must start with search level 0 and may increase
	 * searchlevel only by one each time up to the maximum that can be obtained
	 * by getAvailableSearchLevels.
	 * 
	 * @param searchLevel
	 *            the search level to be applied
	 * @return a list of search results
	 */
	public List<ServiceProfileInfo> findServiceProfiles(int searchLevel) throws IOException;

	/**
	 * Get the maximum search level that can be used plus one.
	 * 
	 * @return the number of search levels available
	 */
	public int getAvailableSearchLevels();

	/**
	 * Sets a ServiceLocatorEventListener to be notified of events during search
	 * 
	 * @param listener
	 *            the ServiceLocatorEventListener to be set
	 */
	public void addServiceLocatorEventListener(
			ServiceLocatorEventListener listener);

	/**
	 * Removes a previously set ServiceLocatorEventListener
	 * 
	 * @param listener
	 *            the ServiceLocatorEventListener to be removed
	 */
	public void removeServiceLocatorEventListener(
			ServiceLocatorEventListener listener);

}
