/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model;

import edu.stanford.smi.protege.model.AbstractFacetConstraint;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;

public class ValueTypeConstraint
extends AbstractFacetConstraint {
    private static final Collection values = new ArrayList();

    private static Collection getAllButFirst(Collection collection) {
        ArrayList arrayList;
        if (collection == null || collection.size() < 1) {
            arrayList = Collections.EMPTY_LIST;
        } else {
            ArrayList arrayList2 = new ArrayList(collection);
            arrayList2.remove(0);
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public static Collection getAllowedClses(Collection collection) {
        KnowledgeBase knowledgeBase;
        ValueType valueType = ValueTypeConstraint.getType(collection);
        Collection collection2 = valueType.equals(ValueType.INSTANCE) ? ValueTypeConstraint.getAllButFirst(collection) : (valueType.equals(ValueType.CLS) ? ((knowledgeBase = ValueTypeConstraint.getKb(collection)) == null ? Collections.EMPTY_LIST : CollectionUtilities.createCollection(knowledgeBase.getRootClsMetaCls())) : Collections.EMPTY_LIST);
        ValueTypeConstraint.ensureClses(collection2);
        return collection2;
    }

    private static void ensureClses(Collection collection) {
        for (Object e : collection) {
            if (e instanceof Cls) continue;
            Log.getLogger().severe("Invalid Class: " + e + " with type = " + (e == null ? " null " : e.getClass().toString()));
            collection.remove(e);
        }
    }

    private static KnowledgeBase getKb(Collection collection) {
        KnowledgeBase knowledgeBase = null;
        for (Object e : collection) {
            if (!(e instanceof Frame)) continue;
            knowledgeBase = ((Frame)e).getKnowledgeBase();
        }
        return knowledgeBase;
    }

    public static Collection getAllowedParents(Collection collection) {
        KnowledgeBase knowledgeBase;
        ValueType valueType = ValueTypeConstraint.getType(collection);
        Collection collection2 = valueType.equals(ValueType.CLS) ? ValueTypeConstraint.getAllButFirst(collection) : (valueType.equals(ValueType.INSTANCE) ? ((knowledgeBase = ValueTypeConstraint.getKb(collection)) == null ? Collections.EMPTY_LIST : knowledgeBase.getRootClses()) : Collections.EMPTY_LIST);
        ValueTypeConstraint.ensureClses(collection2);
        return collection2;
    }

    public static Collection getAllowedValues(Collection collection) {
        ValueType valueType = ValueTypeConstraint.getType(collection);
        return valueType.equals(ValueType.SYMBOL) ? ValueTypeConstraint.getAllButFirst(collection) : Collections.EMPTY_LIST;
    }

    private static String getInvalidAnyValueText(Object object) {
        boolean bl = object instanceof Boolean || object instanceof Frame || object instanceof String || object instanceof Number;
        return bl ? (String)null : "Value must by one of the allowed types";
    }

    private static String getInvalidBooleanValueText(Object object) {
        if (object instanceof String) {
            Log.getLogger().warning("String value in boolean slot: " + object);
        }
        return object instanceof Boolean ? (String)null : "Value must be a boolean";
    }

    private static String getInvalidClsValueText(Object object, Collection collection) {
        String string = null;
        if (object instanceof Cls) {
            Cls cls = (Cls)object;
            if (!collection.contains(cls)) {
                boolean bl = false;
                Iterator iterator = collection.iterator();
                while (!bl && iterator.hasNext()) {
                    Cls cls2 = (Cls)iterator.next();
                    if (!cls.hasSuperclass(cls2)) continue;
                    bl = true;
                }
                if (!bl) {
                    string = "Value must be a subclass of one of the allowed parents";
                }
            }
        } else {
            string = "Value must be a class";
        }
        return string;
    }

    private static String getInvalidFloatValueText(Object object) {
        return object instanceof Float ? (String)null : "Value must be a floating point number";
    }

    private static String getInvalidInstanceValueText(Object object, Collection collection) {
        String string = null;
        if (object instanceof Instance) {
            if (!collection.isEmpty()) {
                Instance instance = (Instance)object;
                boolean bl = false;
                Iterator iterator = collection.iterator();
                while (!bl && iterator.hasNext()) {
                    Cls cls = (Cls)iterator.next();
                    if (!instance.hasType(cls)) continue;
                    bl = true;
                }
                if (!bl) {
                    string = "Value must be an instance of one of the allowed classes";
                }
            }
        } else {
            string = "Value must be an instance";
        }
        return string;
    }

    private static String getInvalidIntegerValueText(Object object) {
        return object instanceof Integer ? (String)null : "Value must be an integer";
    }

    private static String getInvalidStringValueText(Object object) {
        return object instanceof String ? (String)null : "Value must be a string";
    }

    private static String getInvalidSymbolValueText(Object object, Collection collection) {
        return collection.contains(object) ? (String)null : "'" + object + "' is not one of the allowed values";
    }

    public String getInvalidValuesText(Frame frame, Slot slot, Collection collection, Collection collection2) {
        String string = null;
        ValueType valueType = ValueTypeConstraint.getType(collection2);
        Iterator iterator = collection.iterator();
        while (string == null && iterator.hasNext()) {
            Object e = iterator.next();
            string = ValueTypeConstraint.getInvalidValueText(collection2, valueType, e);
        }
        return string;
    }

    public String getInvalidValueText(Frame frame, Slot slot, Object object, Collection collection) {
        ValueType valueType = ValueTypeConstraint.getType(collection);
        return ValueTypeConstraint.getInvalidValueText(collection, valueType, object);
    }

    private static String getInvalidValueText(Collection collection, ValueType valueType, Object object) {
        String string = null;
        if (ValueTypeConstraint.equals(valueType, ValueType.BOOLEAN)) {
            string = ValueTypeConstraint.getInvalidBooleanValueText(object);
        } else if (ValueTypeConstraint.equals(valueType, ValueType.CLS)) {
            string = ValueTypeConstraint.getInvalidClsValueText(object, ValueTypeConstraint.getAllowedParents(collection));
        } else if (ValueTypeConstraint.equals(valueType, ValueType.FLOAT)) {
            string = ValueTypeConstraint.getInvalidFloatValueText(object);
        } else if (ValueTypeConstraint.equals(valueType, ValueType.INSTANCE)) {
            string = ValueTypeConstraint.getInvalidInstanceValueText(object, ValueTypeConstraint.getAllowedClses(collection));
        } else if (ValueTypeConstraint.equals(valueType, ValueType.INTEGER)) {
            string = ValueTypeConstraint.getInvalidIntegerValueText(object);
        } else if (ValueTypeConstraint.equals(valueType, ValueType.STRING)) {
            string = ValueTypeConstraint.getInvalidStringValueText(object);
        } else if (ValueTypeConstraint.equals(valueType, ValueType.SYMBOL)) {
            string = ValueTypeConstraint.getInvalidSymbolValueText(object, ValueTypeConstraint.getAllowedValues(collection));
        } else if (ValueTypeConstraint.equals(valueType, ValueType.ANY)) {
            string = ValueTypeConstraint.getInvalidAnyValueText(object);
        } else {
            Assert.fail("Invalid type: " + valueType);
            string = "failed";
        }
        return string;
    }

    public static ValueType getType(Collection collection) {
        ValueType valueType;
        Object object = CollectionUtilities.getFirstItem(collection);
        if (object == null) {
            valueType = ValueType.ANY;
        } else if (object instanceof String) {
            valueType = ValueType.valueOf((String)object);
        } else {
            Log.getLogger().severe("invalid value type: " + collection);
            valueType = ValueType.ANY;
        }
        return valueType;
    }

    public static Collection getValues() {
        return Collections.unmodifiableCollection(values);
    }

    public static Collection getValues(ValueType valueType) {
        return ValueTypeConstraint.getValues(valueType, Collections.EMPTY_LIST);
    }

    public static List getValues(ValueType valueType, Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!valueType.equals(ValueType.ANY)) {
            arrayList.add(valueType.toString());
            if (collection != null) {
                arrayList.addAll(new LinkedHashSet(collection));
            }
        }
        return arrayList;
    }

    public Collection resolve(Collection collection, Collection collection2) {
        ValueType valueType = ValueTypeConstraint.getType(collection);
        ValueType valueType2 = ValueTypeConstraint.getType(collection2);
        Collection collection3 = valueType.equals(ValueType.ANY) ? collection2 : (valueType2.equals(ValueType.ANY) ? collection : (valueType.equals(valueType2) ? (valueType.equals(ValueType.CLS) ? ValueTypeConstraint.resolveClsValues(collection, collection2) : (valueType.equals(ValueType.INSTANCE) ? ValueTypeConstraint.resolveInstanceValues(collection, collection2) : (valueType.equals(ValueType.SYMBOL) ? ValueTypeConstraint.resolveSymbolValues(collection, collection2) : collection))) : collection));
        return collection3;
    }

    private static Collection resolveClsValues(Collection collection, Collection collection2) {
        return collection.isEmpty() ? collection2 : collection;
    }

    private static Collection resolveInstanceValues(Collection collection, Collection collection2) {
        return collection.isEmpty() ? collection2 : collection;
    }

    private static Collection resolveSymbolValues(Collection collection, Collection collection2) {
        return collection.isEmpty() ? collection2 : collection;
    }

    static {
        values.add(ValueType.ANY.toString());
        values.add(ValueType.BOOLEAN.toString());
        values.add(ValueType.CLS.toString());
        values.add(ValueType.FLOAT.toString());
        values.add(ValueType.INSTANCE.toString());
        values.add(ValueType.INTEGER.toString());
        values.add(ValueType.STRING.toString());
        values.add(ValueType.SYMBOL.toString());
    }
}

