/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class CreatePropertyAction
extends AbstractAction {
    private String baseName;
    private CallBack callBack;
    private RDFSNamedClass type;

    public CreatePropertyAction(RDFSNamedClass type, String baseName, String baseIconName, CallBack callBack) {
        super("Create " + type.getName() + "...", OWLIcons.getCreateIcon(baseIconName));
        this.baseName = baseName;
        this.callBack = callBack;
        this.type = type;
    }

    public void actionPerformed(ActionEvent e) {
        OWLModel owlModel = this.type.getOWLModel();
        owlModel.beginTransaction("Create new " + this.type.getBrowserText());
        String name = this.type.getOWLModel().createNewResourceName(this.baseName);
        RDFProperty property = (RDFProperty)this.type.createInstance(name);
        this.callBack.propertyCreated(property);
        property.getProject().show((Instance)property);
        owlModel.endTransaction();
    }

    public static void addActions(LabeledComponent lc, OWLModel owlModel, CallBack callBack) {
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Create_ObjectProperty)) {
            lc.addHeaderButton((Action)new CreatePropertyAction(owlModel.getOWLObjectPropertyClass(), "objectProperty", "OWLObjectProperty", callBack));
        }
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.Create_DatatypeProperty)) {
            lc.addHeaderButton((Action)new CreatePropertyAction(owlModel.getOWLDatatypePropertyClass(), "datatypeProperty", "OWLDatatypeProperty", callBack));
        }
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.RDF) || ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.RDF_but_not_OWL)) {
            lc.addHeaderButton((Action)new CreatePropertyAction(owlModel.getRDFPropertyClass(), "property", "RDFProperty", callBack));
        }
    }

    public static interface CallBack {
        public void propertyCreated(RDFProperty var1);
    }
}

