/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.AddAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.RemoveAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.OWLSubpropertyPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class OWLSuperpropertiesPanel
extends SelectableContainer {
    private AbstractAction addAction;
    private SelectableList list;
    private OWLModel owlModel;
    private RDFProperty property;
    private PropertyListener propertyListener = new PropertyAdapter(){

        public void superpropertyAdded(RDFProperty property, RDFProperty superproperty) {
            ComponentUtilities.addListValue((JList)OWLSuperpropertiesPanel.this.list, (Object)superproperty);
        }

        public void superpropertyRemoved(RDFProperty property, RDFProperty superproperty) {
            boolean wasEnabled = OWLSuperpropertiesPanel.this.setNotificationsEnabled(false);
            ComponentUtilities.removeListValue((JList)OWLSuperpropertiesPanel.this.list, (Object)superproperty);
            OWLSuperpropertiesPanel.this.setNotificationsEnabled(wasEnabled);
        }
    };
    private AbstractAction removeAction;
    private OWLSubpropertyPane subpropertyPane;

    public OWLSuperpropertiesPanel(OWLSubpropertyPane subpropertyPane, Project project) {
        this(subpropertyPane, (OWLModel)project.getKnowledgeBase());
    }

    public OWLSuperpropertiesPanel(OWLSubpropertyPane subpropertyPane, OWLModel owlModel) {
        this.owlModel = owlModel;
        this.createComponents();
        this.layoutComponents();
        this.setSelectable((Selectable)this.list);
        this.setPreferredSize(new Dimension(0, 100));
        this.subpropertyPane = subpropertyPane;
    }

    private void addProperties() {
        ArrayList allowedProperties = new ArrayList(this.owlModel.getRDFProperties());
        allowedProperties.remove(this.property);
        allowedProperties.removeAll(this.property.getSubproperties(true));
        allowedProperties.removeAll(this.property.getSuperproperties(true));
        for (RDFProperty superproperty : this.selectProperties(allowedProperties)) {
            this.property.addSuperproperty(superproperty);
        }
        this.updateModel();
    }

    private void createComponents() {
        this.list = ComponentFactory.createSelectableList(null);
        this.list.setCellRenderer((ListCellRenderer)((Object)new ResourceRenderer()));
        this.addAction = this.createAddAction();
        this.removeAction = this.createRemoveAction();
    }

    private AbstractAction createAddAction() {
        return new AddAction("Add super properties...", OWLIcons.getAddIcon("RDFProperty")){

            public void onAdd() {
                if (OWLSuperpropertiesPanel.this.property != null) {
                    OWLSuperpropertiesPanel.this.addProperties();
                }
            }
        };
    }

    private AbstractAction createRemoveAction() {
        return new RemoveAction("Remove super property", (Selectable)this.list, OWLIcons.getRemoveIcon("RDFProperty")){

            public void onRemove(Collection superproperties) {
                OWLSuperpropertiesPanel.this.removeProperties(superproperties);
            }
        };
    }

    public void setAddActionIconBase(String baseName) {
        this.addAction.putValue("SmallIcon", OWLIcons.getAddIcon(baseName));
    }

    public void setRemoveActionIconBase(String baseName) {
        this.removeAction.putValue("SmallIcon", OWLIcons.getRemoveIcon(baseName));
    }

    private void layoutComponents() {
        JScrollPane pane = ComponentFactory.createScrollPane((JComponent)this.list);
        OWLLabeledComponent c = new OWLLabeledComponent("Super Properties", pane);
        c.addHeaderButton(this.addAction);
        c.addHeaderButton(this.removeAction);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)c), "Center");
    }

    private Collection selectProperties(Collection allowedProperties) {
        Iterator it = allowedProperties.iterator();
        while (it.hasNext()) {
            RDFProperty property = (RDFProperty)it.next();
            if (this.subpropertyPane.contains(property)) {
                if (!property.isAnnotationProperty()) continue;
                it.remove();
                continue;
            }
            it.remove();
        }
        return ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection((Component)((Object)this), this.owlModel, allowedProperties, "Select Properties");
    }

    private void removeProperties(Collection superproperties) {
        this.owlModel.beginTransaction("Remove superproperties from " + this.property);
        for (RDFProperty superslot : superproperties) {
            this.property.removeSuperproperty(superslot);
        }
        this.updateModel();
    }

    public void setProperty(RDFProperty property, RDFProperty parent) {
        if (this.property != null) {
            this.property.removePropertyListener(this.propertyListener);
        }
        this.property = property;
        if (this.property != null) {
            this.property.addPropertyListener(this.propertyListener);
        }
        this.updateModel();
        this.addAction.setEnabled(property != null && property.isEditable());
        this.list.setSelectedValue((Object)parent, true);
    }

    public void setDisplayParent(RDFProperty parent) {
        this.list.setSelectedValue((Object)parent, true);
    }

    private void updateModel() {
        List properties = this.property == null ? Collections.EMPTY_LIST : this.property.getSuperproperties(false);
        SimpleListModel model = new SimpleListModel((Collection)properties);
        this.list.setModel((ListModel)model);
        this.repaint();
    }
}

