/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.repository;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.repository.RepositoryPanel;
import edu.stanford.smi.protegex.owl.ui.repository.wizard.RepositoryWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public abstract class AbstractRepositoriesPanel
extends JPanel {
    private RepositoryManager manager;
    private Action addRepAction;
    private OWLModel model;
    private Box repositoriesHolder;

    public AbstractRepositoriesPanel(final OWLModel model, RepositoryManager man) {
        this.manager = man;
        this.model = model;
        this.addRepAction = new AbstractAction("Add repository", OWLIcons.getAddIcon()){

            public void actionPerformed(ActionEvent e) {
                RepositoryWizard w = new RepositoryWizard(null, model);
                int ret = w.execute();
                if (ret == 1 && w.getRepository() != null) {
                    AbstractRepositoriesPanel.this.addRepository(w.getRepository());
                }
                AbstractRepositoriesPanel.this.reloadUI();
            }
        };
        this.createUI();
    }

    protected void setAddRepositoryEnabled(boolean b) {
        this.addRepAction.setEnabled(b);
    }

    public abstract void addRepository(Repository var1);

    public RepositoryManager getRepositoryManager() {
        return this.manager;
    }

    public abstract List getRepositories();

    public void reloadUI() {
        List list = this.getRepositories();
        this.repositoriesHolder.removeAll();
        for (Repository curRep : list) {
            this.repositoriesHolder.add(new RepositoryPanel(this.model, this.manager, curRep, this));
        }
        this.revalidate();
    }

    public abstract String getRepositoriesTitle();

    private void createUI() {
        this.repositoriesHolder = new Box(1);
        this.reloadUI();
        JPanel packingPanel = new JPanel(new BorderLayout());
        packingPanel.setOpaque(false);
        packingPanel.add((Component)this.repositoriesHolder, "North");
        JScrollPane sp = new JScrollPane(packingPanel);
        sp.getViewport().setBackground(Color.WHITE);
        LabeledComponent lc = new LabeledComponent(this.getRepositoriesTitle(), sp);
        lc.addHeaderButton(this.addRepAction);
        this.setLayout(new BorderLayout());
        this.add((Component)lc, "Center");
        this.setOpaque(false);
    }
}

