/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property.tests;

import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTableModel;

public class PropertyFormTableModelTestCase
extends AbstractJenaTestCase {
    public void testEmptyOnNoRestriction() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        PropertyFormTableModel tableModel = new PropertyFormTableModel(namedClass, property);
        PropertyFormTableModelTestCase.assertEquals((int)0, (int)tableModel.getRowCount());
    }

    public void testOneHasValueSuperclasses() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLIndividual filler = this.owlThing.createOWLIndividual("Individual");
        namedClass.addSuperclass(this.owlModel.createOWLHasValue(property, filler));
        PropertyFormTableModel tableModel = new PropertyFormTableModel(namedClass, property);
        PropertyFormTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertyFormTableModelTestCase.assertEquals((Object)filler, (Object)tableModel.getRDFResource(0));
    }

    public void testOneSomeValuesFromSuperclasses() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass filler = this.owlThing;
        namedClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, filler));
        PropertyFormTableModel tableModel = new PropertyFormTableModel(namedClass, property);
        PropertyFormTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertyFormTableModelTestCase.assertEquals((Object)filler, (Object)tableModel.getRDFResource(0));
    }

    public void testTwoSomeValuesFromSuperclasses() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass fillerA = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass fillerB = this.owlModel.createOWLNamedClass("B");
        namedClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, fillerB));
        namedClass.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, fillerA));
        PropertyFormTableModel tableModel = new PropertyFormTableModel(namedClass, property);
        PropertyFormTableModelTestCase.assertEquals((int)2, (int)tableModel.getRowCount());
        PropertyFormTableModelTestCase.assertEquals((Object)fillerA, (Object)tableModel.getRDFResource(0));
        PropertyFormTableModelTestCase.assertEquals((Object)fillerB, (Object)tableModel.getRDFResource(1));
    }

    public void testOneSomeValuesFromAsEquivalentClass() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass filler = this.owlThing;
        namedClass.setDefinition(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, filler));
        PropertyFormTableModel tableModel = new PropertyFormTableModel(namedClass, property);
        PropertyFormTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertyFormTableModelTestCase.assertEquals((Object)filler, (Object)tableModel.getRDFResource(0));
    }

    public void testOneSomeValuesFromAsPartOfEquivalentClass() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLIntersectionClass definition = this.owlModel.createOWLIntersectionClass();
        definition.addOperand(this.owlThing);
        OWLNamedClass filler = this.owlThing;
        definition.addOperand(this.owlModel.createOWLSomeValuesFrom((RDFProperty)property, filler));
        namedClass.setDefinition(definition);
        PropertyFormTableModel tableModel = new PropertyFormTableModel(namedClass, property);
        PropertyFormTableModelTestCase.assertEquals((int)1, (int)tableModel.getRowCount());
        PropertyFormTableModelTestCase.assertEquals((Object)filler, (Object)tableModel.getRDFResource(0));
    }
}

