/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultClassFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResult;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchAdapter;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchListener;
import edu.stanford.smi.protegex.owl.ui.search.finder.ThreadedFind;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class FindTestCase
extends AbstractJenaTestCase {
    boolean complete = false;
    Find findAlg;
    SearchListener searchResultListener = new SearchAdapter(){

        public void resultsUpdatedEvent(int numResults, Find source) {
        }

        public void searchCompleteEvent(int numResults, Find source) {
            FindTestCase.this.complete = true;
        }

        public void searchCancelledEvent(Find source) {
            FindTestCase.fail();
            FindTestCase.this.complete = true;
        }

        public void searchStartedEvent(Find source) {
        }
    };

    public void testThreadedSpeed() {
        this.loadPizza();
        Cls metaCls = this.owlModel.getOWLNamedClassMetaClassCls();
        metaCls.setDirectBrowserSlot((Slot)this.owlModel.getRDFProperty("rdfs:label"));
        this.findAlg = new ThreadedFind(this.owlModel, 1);
        this.findAlg.addResultListener(this.searchResultListener);
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < 100) {
            this.complete = false;
            this.findAlg.startSearch("p");
            while (!this.complete) {
                Thread.yield();
            }
            ++i;
        }
        long timeTaken = System.currentTimeMillis() - startTime;
        System.out.println("100 searches took " + timeTaken + "ms");
    }

    public void testFindDoesNotPickUpLanguageTags() {
        this.loadPizza();
        Cls metaCls = this.owlModel.getOWLNamedClassMetaClassCls();
        metaCls.setDirectBrowserSlot((Slot)this.owlModel.getRDFProperty("rdfs:label"));
        this.findAlg = new DefaultClassFind(this.owlModel, 1);
        this.findAlg.addResultListener(this.searchResultListener);
        this.complete = false;
        this.findAlg.startSearch("p");
        while (!this.complete) {
            Thread.yield();
        }
        Map results = this.findAlg.getResults();
        System.out.println("results = " + results);
        FindTestCase.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        for (FindResult result : results.values()) {
            FindTestCase.assertNotNull((Object)result.getMatchValue());
            FindTestCase.assertTrue((boolean)Pattern.matches(".*[pP].*", result.getMatchValue()));
            FindTestCase.assertTrue((boolean)(result.getMatchingResource() instanceof OWLNamedClass));
        }
    }

    private void loadPizza() {
        try {
            URI pizza = new URI("http://www.co-ode.org/ontologies/pizza/2005/10/18/pizza.owl");
            try {
                this.owlModel.load(pizza, null);
            }
            catch (Exception e) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            }
        }
        catch (URISyntaxException e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }
}

