/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsdesc;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.clsdesc.AddRowAction;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionTable;
import edu.stanford.smi.protegex.owl.ui.clsdesc.ClassDescriptionWidget;
import edu.stanford.smi.protegex.owl.ui.clsdesc.CreateRowAction;
import edu.stanford.smi.protegex.owl.ui.clsdesc.DisjointClassesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DisjointClassesWidget
extends ClassDescriptionWidget {
    private boolean mutuallyIsDefault = true;

    private void addAllSiblings(boolean noDialog) {
        SiblingsPanel siblingsPanel = new SiblingsPanel(this.mutuallyIsDefault);
        if (noDialog || ProtegeUI.getModalDialogFactory().showDialog((Component)((Object)this), siblingsPanel, "Add siblings to disjoints", 11) == 1) {
            try {
                try {
                    this.beginTransaction("Add siblings to disjoints of " + this.getEditedCls().getBrowserText());
                    this.mutuallyIsDefault = siblingsPanel.isMutuallySelected();
                    OWLNamedClass editedCls = this.getEditedCls();
                    if (this.mutuallyIsDefault) {
                        for (Cls superCls : editedCls.getSuperclasses(false)) {
                            if (!(superCls instanceof OWLNamedClass)) continue;
                            OWLUtil.ensureSubclassesDisjoint((OWLNamedClass)superCls);
                        }
                    } else {
                        Set ds = this.getPotentialDisjoints(editedCls);
                        Collection disjointClasses = editedCls.getDisjointClasses();
                        for (OWLNamedClass namedCls : ds) {
                            if (namedCls.equals(editedCls) || disjointClasses.contains(namedCls)) continue;
                            editedCls.addDisjointClass(namedCls);
                            namedCls.addDisjointClass(editedCls);
                        }
                    }
                }
                catch (Exception ex) {
                    OWLUI.handleError(this.getOWLModel(), ex);
                }
            }
            finally {
                this.endTransaction();
            }
        }
    }

    protected ResourceSelectionAction createAddAction(ClassDescriptionTable table) {
        return new AddRowAction(this.getTable(), "Add disjoint class...", false){

            public Collection pickResources() {
                OWLNamedClass self = DisjointClassesWidget.this.getEditedCls();
                self.setVisible(false);
                Collection results = super.pickResources();
                self.setVisible(true);
                return results;
            }
        };
    }

    protected Action createCreateAction(ClassDescriptionTable table) {
        return new CreateRowAction(this.getTable(), "Create disjoint class from OWL expression");
    }

    protected Icon createHeaderIcon() {
        return OWLIcons.getImageIcon("OWLDisjointClasses");
    }

    protected List createCustomActions(ClassDescriptionTable table) {
        AbstractAction addAction = new AbstractAction("Add all siblings...", OWLIcons.getAddIcon("SiblingClasses")){

            public void actionPerformed(ActionEvent e) {
                DisjointClassesWidget.this.addAllSiblings((e.getModifiers() & 2) != 0);
            }
        };
        AbstractAction removeAction = new AbstractAction("Remove all siblings...", OWLIcons.getRemoveIcon("SiblingClasses")){

            public void actionPerformed(ActionEvent e) {
                DisjointClassesWidget.this.removeAllSiblings((e.getModifiers() & 2) != 0);
            }
        };
        ArrayList<AbstractAction> list = new ArrayList<AbstractAction>();
        list.add(addAction);
        list.add(removeAction);
        return list;
    }

    protected OWLTableModel createTableModel() {
        return new DisjointClassesTableModel();
    }

    protected String getLabelText() {
        return "Disjoints";
    }

    private Set getPotentialDisjoints(OWLNamedClass editedCls) {
        HashSet ds = new HashSet();
        for (Cls superCls : editedCls.getSuperclasses(false)) {
            if (!(superCls instanceof OWLNamedClass)) continue;
            ds.addAll(OWLUtil.getPotentiallyDisjointSubclasses((OWLNamedClass)superCls));
        }
        return ds;
    }

    public void initialize() {
        super.initialize();
        this.getTable().getSelectionModel().setSelectionMode(2);
        TableColumn owlColumn = this.getTable().getColumnModel().getColumn(0);
        owlColumn.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer(){

            protected Icon getClsIcon(Cls cls) {
                DisjointClassesTableModel tableModel = (DisjointClassesTableModel)DisjointClassesWidget.this.getTable().getModel();
                if (cls instanceof RDFResource) {
                    return tableModel.getIcon((RDFResource)cls);
                }
                return super.getClsIcon(cls);
            }
        }));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getName().equals("owl:disjointWith");
    }

    private void removeAllSiblings(boolean noDialog) {
        SiblingsPanel siblingsPanel = new SiblingsPanel(this.mutuallyIsDefault);
        if (noDialog || ProtegeUI.getModalDialogFactory().showDialog((Component)((Object)this), siblingsPanel, "Remove siblings from disjoints", 11) == 1) {
            try {
                try {
                    this.beginTransaction("Remove siblings from disjoints of " + this.getEditedCls().getBrowserText());
                    this.mutuallyIsDefault = siblingsPanel.isMutuallySelected();
                    OWLNamedClass editedCls = this.getEditedCls();
                    if (this.mutuallyIsDefault) {
                        for (Cls superCls : editedCls.getSuperclasses(false)) {
                            if (!(superCls instanceof OWLNamedClass)) continue;
                            OWLUtil.removeSubclassesDisjoint((OWLNamedClass)superCls);
                        }
                    } else {
                        TripleStoreModel tsm = editedCls.getOWLModel().getTripleStoreModel();
                        RDFProperty owlDisjointWithProperty = editedCls.getOWLModel().getOWLDisjointWithProperty();
                        Set ds = this.getPotentialDisjoints(editedCls);
                        for (OWLNamedClass otherCls : ds) {
                            if (tsm.isEditableTriple(editedCls, owlDisjointWithProperty, otherCls)) {
                                editedCls.removeDisjointClass(otherCls);
                            }
                            if (!tsm.isEditableTriple(otherCls, owlDisjointWithProperty, editedCls)) continue;
                            otherCls.removeDisjointClass(editedCls);
                        }
                    }
                }
                catch (Exception ex) {
                    OWLUI.handleError(this.getOWLModel(), ex);
                }
            }
            finally {
                this.endTransaction();
            }
        }
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
    }

    private class SiblingsPanel
    extends JPanel {
        private JRadioButton mutuallyRadioButton;
        private JRadioButton locallyRadioButton;

        SiblingsPanel(boolean mutuallyIsDefault) {
            this.mutuallyRadioButton = new JRadioButton("Mutually between all siblings", mutuallyIsDefault);
            this.locallyRadioButton = new JRadioButton("Only between this class and its siblings", !mutuallyIsDefault);
            ButtonGroup group = new ButtonGroup();
            group.add(this.mutuallyRadioButton);
            group.add(this.locallyRadioButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(this.mutuallyRadioButton);
            this.add(this.locallyRadioButton);
        }

        boolean isMutuallySelected() {
            return this.mutuallyRadioButton.isSelected();
        }
    }
}

