/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.individuals;

import edu.stanford.smi.protege.action.DeleteInstancesAction;
import edu.stanford.smi.protege.action.MakeCopiesAction;
import edu.stanford.smi.protege.action.ReferencersAction;
import edu.stanford.smi.protege.event.ClsAdapter;
import edu.stanford.smi.protege.event.ClsEvent;
import edu.stanford.smi.protege.event.ClsListener;
import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.BrowserSlotPattern;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.resource.Colors;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.ConfigureAction;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.CreateAction;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.ModalDialog;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.InstancesList;
import edu.stanford.smi.protegex.owl.ui.individuals.MultiSlotPanel;
import edu.stanford.smi.protegex.owl.ui.search.finder.DefaultIndividualFind;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindInDialogAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResourceFinder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListModel;

public class AssertedInstancesListPanel
extends SelectableContainer
implements Disposable {
    private Collection classes = Collections.EMPTY_LIST;
    private AllowableAction createAction;
    private AllowableAction copyAction;
    private AllowableAction deleteAction;
    private HeaderComponent header;
    private OWLLabeledComponent lc;
    private InstancesList list;
    private Collection listenedToInstances = new ArrayList();
    private OWLModel owlModel;
    private static final int SORT_LIMIT = ApplicationProperties.getIntegerProperty((String)"ui.DirectInstancesList.sort_limit", (int)1000);
    private boolean showSubclassInstances;
    private ClsListener _clsListener = new ClsAdapter(){

        public void directInstanceAdded(ClsEvent event) {
            Instance instance = event.getInstance();
            if (!AssertedInstancesListPanel.this.getModel().contains((Object)instance)) {
                ComponentUtilities.addListValue((JList)((Object)AssertedInstancesListPanel.this.list), (Object)instance);
                instance.addFrameListener(AssertedInstancesListPanel.this._instanceFrameListener);
            }
        }

        public void directInstanceRemoved(ClsEvent event) {
            AssertedInstancesListPanel.this.removeInstance(event.getInstance());
        }
    };
    private FrameListener _clsFrameListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            super.ownSlotValueChanged(event);
            AssertedInstancesListPanel.this.updateButtons();
        }
    };
    private FrameListener _instanceFrameListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent event) {
            super.browserTextChanged(event);
            AssertedInstancesListPanel.this.sort();
            AssertedInstancesListPanel.this.repaint();
        }
    };

    public AssertedInstancesListPanel(OWLModel owlModel) {
        this.owlModel = owlModel;
        Action viewAction = this.createViewAction();
        this.list = new InstancesList(viewAction);
        this.lc = new OWLLabeledComponent(null, ComponentFactory.createScrollPane((JComponent)((Object)this.list)));
        this.addButtons(viewAction, this.lc);
        DefaultIndividualFind findAlg = new DefaultIndividualFind(owlModel, 1){

            protected boolean isValidFrameToSearch(Frame f) {
                return ((SimpleListModel)AssertedInstancesListPanel.this.list.getModel()).getValues().contains(f) && super.isValidFrameToSearch(f);
            }

            public String getDescription() {
                return "Find Individual Of Selected Class";
            }
        };
        FindInDialogAction fAction = new FindInDialogAction(findAlg, Icons.getFindInstanceIcon(), this.list, true);
        ResourceFinder finder = new ResourceFinder(fAction);
        this.lc.setFooterComponent(finder);
        this.lc.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)((Object)this.lc), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createHeader(), "North");
        this.add(panel, "North");
        this.setSelectable(this.list);
        this.lc.setHeaderLabel("Asserted Instances");
    }

    private void updateLabel() {
        String text;
        BrowserSlotPattern pattern;
        Cls cls = this.getSoleAllowedCls();
        BrowserSlotPattern browserSlotPattern = pattern = cls == null ? null : cls.getBrowserSlotPattern();
        if (pattern == null) {
            text = null;
        } else if (pattern.isSimple()) {
            text = pattern.getFirstSlot().getBrowserText();
            if (":NAME".equals(text)) {
                text = "Asserted Instances";
            }
        } else {
            text = "multiple properties";
        }
        this.lc.setHeaderLabel(text);
    }

    private HeaderComponent createHeader() {
        JLabel label = ComponentFactory.createLabel();
        String instanceBrowserLabel = LocalizedText.getText((ResourceKey)ResourceKey.INSTANCE_BROWSER_TITLE);
        String forClassLabel = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_EDITOR_FOR_CLASS_LABEL);
        this.header = new HeaderComponent(instanceBrowserLabel, forClassLabel, (JComponent)label);
        this.header.setColor(Colors.getInstanceColor());
        return this.header;
    }

    private void fixRenderer() {
        FrameRenderer frameRenderer = (FrameRenderer)this.list.getCellRenderer();
        frameRenderer.setDisplayType(this.showSubclassInstances);
    }

    protected void addButtons(Action viewAction, LabeledComponent c) {
        c.addHeaderButton(this.createConfigureAction());
        c.addHeaderButton(this.createCreateAction());
        c.addHeaderButton(this.createCopyAction());
        c.addHeaderButton(this.createDeleteAction());
    }

    private void addClsListeners() {
        for (Cls cls : this.classes) {
            cls.addClsListener(this._clsListener);
            cls.addFrameListener(this._clsFrameListener);
        }
    }

    private void addInstanceListeners() {
        ListModel model = this.list.getModel();
        int start = this.list.getFirstVisibleIndex();
        int stop = this.list.getLastVisibleIndex();
        int i = start;
        while (i < stop) {
            Instance instance = (Instance)model.getElementAt(i);
            this.addInstanceListener(instance);
            ++i;
        }
    }

    private void removeInstanceListeners() {
        for (Instance instance : this.listenedToInstances) {
            instance.removeFrameListener(this._instanceFrameListener);
        }
        this.listenedToInstances.clear();
    }

    private void addInstanceListener(Instance instance) {
        instance.addFrameListener(this._instanceFrameListener);
        this.listenedToInstances.add(instance);
    }

    protected Action createCreateAction() {
        this.createAction = new CreateAction("Create instance", OWLIcons.getCreateIndividualIcon("RDFIndividual")){

            public void onCreate() {
                if (!AssertedInstancesListPanel.this.classes.isEmpty()) {
                    Cls newCls;
                    Instance instance = AssertedInstancesListPanel.this.owlModel.createInstance(null, AssertedInstancesListPanel.this.classes);
                    if (instance instanceof Cls && (newCls = (Cls)instance).getDirectSuperclassCount() == 0) {
                        newCls.addDirectSuperclass((Cls)AssertedInstancesListPanel.this.owlModel.getOWLThingClass());
                    }
                    AssertedInstancesListPanel.this.list.setSelectedValue(instance, true);
                }
            }
        };
        return this.createAction;
    }

    protected Action createConfigureAction() {
        return new ConfigureAction(){

            public void loadPopupMenu(JPopupMenu menu) {
                menu.add(AssertedInstancesListPanel.this.createSetDisplaySlotAction());
                menu.add(AssertedInstancesListPanel.this.createShowAllInstancesAction());
            }
        };
    }

    protected JMenuItem createShowAllInstancesAction() {
        AbstractAction action = new AbstractAction("Show Subclass Instances"){

            public void actionPerformed(ActionEvent event) {
                AssertedInstancesListPanel.this.setShowAllInstances(!AssertedInstancesListPanel.this.showSubclassInstances);
            }
        };
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.setSelected(this.showSubclassInstances);
        return item;
    }

    private void setShowAllInstances(boolean b) {
        this.showSubclassInstances = b;
        this.reload();
        this.fixRenderer();
    }

    protected Cls getSoleAllowedCls() {
        Cls cls = this.classes.size() == 1 ? (Cls)CollectionUtilities.getFirstItem((Collection)this.classes) : null;
        return cls;
    }

    protected JMenu createSetDisplaySlotAction() {
        JMenu menu = ComponentFactory.createMenu((String)"Set Display Slot");
        boolean enabled = false;
        Cls cls = this.getSoleAllowedCls();
        if (cls != null) {
            BrowserSlotPattern pattern = cls.getBrowserSlotPattern();
            Slot browserSlot = pattern != null && pattern.isSimple() ? pattern.getFirstSlot() : null;
            for (Slot slot : cls.getVisibleTemplateSlots()) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.createSetDisplaySlotAction(slot));
                if (slot.equals(browserSlot)) {
                    item.setSelected(true);
                }
                menu.add(item);
                enabled = true;
            }
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.createSetDisplaySlotMultipleAction());
            if (browserSlot == null) {
                item.setSelected(true);
            }
            menu.add(item);
        }
        menu.setEnabled(enabled);
        return menu;
    }

    protected Action createSetDisplaySlotAction(final Slot slot) {
        return new AbstractAction(slot.getBrowserText(), slot.getIcon()){

            public void actionPerformed(ActionEvent event) {
                AssertedInstancesListPanel.this.getSoleAllowedCls().setDirectBrowserSlot(slot);
                AssertedInstancesListPanel.this.updateLabel();
                AssertedInstancesListPanel.this.repaint();
            }
        };
    }

    protected Action createSetDisplaySlotMultipleAction() {
        return new AbstractAction("Multple Slots..."){

            public void actionPerformed(ActionEvent event) {
                BrowserSlotPattern pattern;
                Cls cls = AssertedInstancesListPanel.this.getSoleAllowedCls();
                BrowserSlotPattern currentPattern = AssertedInstancesListPanel.this.getSoleAllowedCls().getBrowserSlotPattern();
                MultiSlotPanel panel = new MultiSlotPanel(currentPattern, cls);
                int rval = ModalDialog.showDialog((Component)((Object)AssertedInstancesListPanel.this), (Component)panel, (String)"Multislot Display Pattern", (int)11);
                if (rval == 1 && (pattern = panel.getBrowserTextPattern()) != null) {
                    cls.setDirectBrowserSlotPattern(pattern);
                }
                AssertedInstancesListPanel.this.updateLabel();
                AssertedInstancesListPanel.this.repaint();
            }
        };
    }

    protected Action createDeleteAction() {
        this.deleteAction = new DeleteInstancesAction((Selectable)this);
        return this.deleteAction;
    }

    protected Action createCopyAction() {
        this.copyAction = new MakeCopiesAction(ResourceKey.INSTANCE_COPY, (Selectable)this){

            protected Instance copy(Instance instance, boolean isDeep) {
                Instance copy = super.copy(instance, isDeep);
                AssertedInstancesListPanel.this.setSelectedInstance(copy);
                return copy;
            }
        };
        return this.copyAction;
    }

    protected Action createReferencersAction() {
        return new ReferencersAction(ResourceKey.INSTANCE_VIEW_REFERENCES, (Selectable)this);
    }

    protected Action createViewAction() {
        return new ViewAction(ResourceKey.INSTANCE_VIEW, (Selectable)this){

            public void onView(Object o) {
                AssertedInstancesListPanel.this.owlModel.getProject().show((Instance)o);
            }
        };
    }

    public void dispose() {
        this.removeClsListeners();
        this.removeInstanceListeners();
    }

    public JComponent getDragComponent() {
        return this.list;
    }

    private SimpleListModel getModel() {
        return (SimpleListModel)this.list.getModel();
    }

    private boolean isSelectionEditable() {
        boolean isEditable = true;
        for (Instance instance : this.getSelection()) {
            if (instance.isEditable()) continue;
            isEditable = false;
            break;
        }
        return isEditable;
    }

    public void onSelectionChange() {
        boolean editable = this.isSelectionEditable();
        ComponentUtilities.setDragAndDropEnabled((JComponent)((Object)this.list), (boolean)editable);
        this.updateButtons();
    }

    private void removeInstance(Instance instance) {
        ComponentUtilities.removeListValue((JList)((Object)this.list), (Object)instance);
        instance.removeFrameListener(this._instanceFrameListener);
    }

    private void removeClsListeners() {
        for (Cls cls : this.classes) {
            cls.removeClsListener(this._clsListener);
            cls.removeFrameListener(this._clsFrameListener);
        }
    }

    public void setClses(Collection newClses) {
        this.removeClsListeners();
        this.classes = new ArrayList(newClses);
        this.list.setClasses(newClses);
        this.reload();
        this.updateButtons();
        this.addClsListeners();
    }

    public void reload() {
        this.removeInstanceListeners();
        Object selectedValue = this.list.getSelectedValue();
        LinkedHashSet instanceSet = new LinkedHashSet();
        for (Cls cls : this.classes) {
            instanceSet.addAll(this.getInstances(cls));
        }
        ArrayList instances = new ArrayList(instanceSet);
        if (instances.size() <= SORT_LIMIT) {
            Collections.sort(instances, new FrameComparator());
        }
        this.getModel().setValues(instances);
        if (instances.contains(selectedValue)) {
            this.list.setSelectedValue(selectedValue, true);
        } else if (!instances.isEmpty()) {
            this.list.setSelectedIndex(0);
        }
        this.addInstanceListeners();
        this.reloadHeader(this.classes);
        this.updateLabel();
    }

    private void reloadHeader(Collection clses) {
        StringBuffer text = new StringBuffer();
        Icon icon = null;
        for (Cls cls : clses) {
            if (icon == null) {
                icon = cls.getIcon();
            }
            if (text.length() != 0) {
                text.append(", ");
            }
            text.append(cls.getName());
        }
        JLabel label = (JLabel)this.header.getComponent();
        label.setText(text.toString());
        label.setIcon(icon);
    }

    private Collection getInstances(Cls cls) {
        Collection instances = this.showSubclassInstances ? cls.getInstances() : cls.getDirectInstances();
        if (!this.owlModel.getProject().getDisplayHiddenFrames()) {
            instances = AssertedInstancesListPanel.removeHiddenInstances(instances);
        }
        return instances;
    }

    private static Collection removeHiddenInstances(Collection instances) {
        ArrayList visibleInstances = new ArrayList(instances);
        Iterator i = visibleInstances.iterator();
        while (i.hasNext()) {
            Instance instance = (Instance)i.next();
            if (instance.isVisible()) continue;
            i.remove();
        }
        return visibleInstances;
    }

    public void sort() {
        this.list.setListenerNotificationEnabled(false);
        Object selectedValue = this.list.getSelectedValue();
        ArrayList instances = new ArrayList(this.getModel().getValues());
        if (instances.size() <= SORT_LIMIT) {
            Collections.sort(instances, new FrameComparator());
        }
        this.getModel().setValues(instances);
        this.list.setSelectedValue(selectedValue);
        this.list.setListenerNotificationEnabled(true);
    }

    public void setSelectedInstance(Instance instance) {
        this.list.setSelectedValue(instance, true);
        this.updateButtons();
    }

    private void updateButtons() {
        Cls cls = (Cls)CollectionUtilities.getFirstItem((Collection)this.classes);
        this.createAction.setEnabled(cls == null ? false : cls.isConcrete());
        Instance instance = (Instance)this.getSoleSelection();
        boolean allowed = instance != null && instance instanceof SimpleInstance;
        this.copyAction.setAllowed(allowed);
    }

    public void setShowDisplaySlotPanel(boolean b) {
    }
}

