/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.xml;

import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterPreferences;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultXMLWriter
implements XMLWriter {
    private Stack elementStack;
    private Writer writer;
    private String encoding;
    private String xmlBase;
    private XMLWriterNamespaceManager xmlWriterNamespaceManager;
    private Map entities;
    private static final int TEXT_CONTENT_WRAP_LIMIT = 15;

    public DefaultXMLWriter(Writer writer, XMLWriterNamespaceManager xmlWriterNamespaceManager) {
        this(writer, xmlWriterNamespaceManager, "");
    }

    public DefaultXMLWriter(Writer writer, XMLWriterNamespaceManager xmlWriterNamespaceManager, String xmlBase) {
        this.writer = writer;
        this.xmlWriterNamespaceManager = xmlWriterNamespaceManager;
        this.xmlBase = xmlBase;
        this.encoding = "";
        this.elementStack = new Stack();
        this.setupEntities();
    }

    private void setupEntities() {
        ArrayList namespaces = new ArrayList(this.xmlWriterNamespaceManager.getNamespaces());
        Collections.sort(namespaces, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).length() - ((String)o2).length();
            }
        });
        this.entities = new LinkedHashMap();
        for (String curNamespace : namespaces) {
            String curPrefix = this.xmlWriterNamespaceManager.getPrefixForNamespace(curNamespace);
            this.entities.put(curNamespace, "&" + curPrefix + ";");
        }
    }

    private String swapForEntity(String value) {
        for (String curEntity : this.entities.keySet()) {
            String repVal;
            String entityVal = (String)this.entities.get(curEntity);
            if (value.length() <= curEntity.length() || (repVal = StringUtils.replaceOnce((String)value, (String)curEntity, (String)entityVal)).length() >= value.length()) continue;
            return repVal;
        }
        return value;
    }

    public String getDefaultNamespace() {
        return this.xmlWriterNamespaceManager.getDefaultNamespace();
    }

    public String getXMLBase() {
        return this.xmlBase;
    }

    public XMLWriterNamespaceManager getNamespacePrefixes() {
        return this.xmlWriterNamespaceManager;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setWrapAttributes(boolean b) {
        if (this.elementStack.size() > 0) {
            XMLElement element = (XMLElement)this.elementStack.peek();
            element.setWrapAttributes(b);
        }
    }

    public void writeStartElement(String name) throws IOException {
        XMLElement topElement;
        XMLElement element = new XMLElement(name, this.elementStack.size());
        if (this.elementStack.size() > 0 && (topElement = (XMLElement)this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        this.elementStack.push(element);
    }

    public void writeEndElement() throws IOException {
        if (this.elementStack.size() > 0) {
            XMLElement element = (XMLElement)this.elementStack.pop();
            element.writeElementEnd();
        }
    }

    public void writeAttribute(String attr, String val) {
        XMLElement element = (XMLElement)this.elementStack.peek();
        element.setAttribute(attr, val);
    }

    public void writeTextContent(String text) {
        XMLElement element = (XMLElement)this.elementStack.peek();
        element.setText(text);
    }

    private void writeEntities(String rootName) throws IOException {
        this.writer.write("\n\n<!DOCTYPE " + rootName + " [\n");
        for (String entityVal : this.entities.keySet()) {
            String entity = (String)this.entities.get(entityVal);
            entity = entity.substring(1, entity.length() - 1);
            this.writer.write("    <!ENTITY ");
            this.writer.write(entity);
            this.writer.write(" \"");
            this.writer.write(entityVal);
            this.writer.write("\" >\n");
        }
        this.writer.write("]>\n\n\n");
    }

    public void startDocument(String rootElementName) throws IOException {
        String encodingString = "";
        if (this.encoding.length() > 0) {
            encodingString = " encoding=\"" + this.encoding + "\"";
        }
        this.writer.write("<?xml version=\"1.0\"" + encodingString + "?>\n");
        if (XMLWriterPreferences.getInstance().isUseNamespaceEntities()) {
            this.writeEntities(rootElementName);
        }
        this.writeStartElement(rootElementName);
        this.setWrapAttributes(true);
        this.writeAttribute("xmlns", this.xmlWriterNamespaceManager.getDefaultNamespace());
        if (!this.xmlBase.equals("")) {
            this.writeAttribute("xml:base", this.xmlBase);
        }
        for (String curPrefix : this.xmlWriterNamespaceManager.getPrefixes()) {
            this.writeAttribute("xmlns:" + curPrefix, this.xmlWriterNamespaceManager.getNamespaceForPrefix(curPrefix));
        }
    }

    public void endDocument() throws IOException {
        while (this.elementStack.size() > 0) {
            this.writeEndElement();
        }
    }

    public class XMLElement {
        private String name;
        private Map attributes;
        String textContent;
        private boolean startWritten;
        private int indentation;
        private boolean wrapAttributes;

        public XMLElement(String name) {
            this(name, 0);
            this.wrapAttributes = false;
        }

        public XMLElement(String name, int indentation) {
            this.name = name;
            this.attributes = new LinkedHashMap();
            this.indentation = indentation;
            this.textContent = null;
            this.startWritten = false;
        }

        public void setWrapAttributes(boolean b) {
            this.wrapAttributes = true;
        }

        public void setAttribute(String attribute, String value) {
            this.attributes.put(attribute, value);
        }

        public void setText(String content) {
            this.textContent = content;
        }

        public void writeElementStart(boolean close) throws IOException {
            if (!this.startWritten) {
                this.startWritten = true;
                this.insertIndentation();
                DefaultXMLWriter.this.writer.write(60);
                DefaultXMLWriter.this.writer.write(this.name);
                this.writeAttributes();
                if (this.textContent != null) {
                    boolean wrap;
                    boolean bl = wrap = this.textContent.length() > 15;
                    if (wrap) {
                        this.writeNewLine();
                        ++this.indentation;
                        this.insertIndentation();
                    }
                    DefaultXMLWriter.this.writer.write(62);
                    this.writeTextContent();
                    if (wrap) {
                        --this.indentation;
                    }
                }
                if (close) {
                    if (this.textContent != null) {
                        this.writeElementEnd();
                    } else {
                        DefaultXMLWriter.this.writer.write("/>");
                        this.writeNewLine();
                    }
                } else if (this.textContent == null) {
                    DefaultXMLWriter.this.writer.write(62);
                    this.writeNewLine();
                }
            }
        }

        public void writeElementEnd() throws IOException {
            if (!this.startWritten) {
                this.writeElementStart(true);
            } else {
                if (this.textContent == null) {
                    this.insertIndentation();
                }
                DefaultXMLWriter.this.writer.write("</");
                DefaultXMLWriter.this.writer.write(this.name);
                DefaultXMLWriter.this.writer.write(">");
                this.writeNewLine();
            }
        }

        private void writeAttribute(String attr, String val) throws IOException {
            DefaultXMLWriter.this.writer.write(attr);
            DefaultXMLWriter.this.writer.write(61);
            DefaultXMLWriter.this.writer.write(34);
            if (XMLWriterPreferences.getInstance().isUseNamespaceEntities()) {
                DefaultXMLWriter.this.writer.write(DefaultXMLWriter.this.swapForEntity(StringEscapeUtils.escapeXml((String)val)));
            } else {
                DefaultXMLWriter.this.writer.write(StringEscapeUtils.escapeXml((String)val));
            }
            DefaultXMLWriter.this.writer.write(34);
        }

        private void writeAttributes() throws IOException {
            Iterator it = this.attributes.keySet().iterator();
            while (it.hasNext()) {
                String attr = (String)it.next();
                String val = (String)this.attributes.get(attr);
                DefaultXMLWriter.this.writer.write(32);
                this.writeAttribute(attr, val);
                if (!it.hasNext() || !this.wrapAttributes) continue;
                DefaultXMLWriter.this.writer.write("\n");
                ++this.indentation;
                this.insertIndentation();
                --this.indentation;
            }
        }

        private void writeTextContent() throws IOException {
            if (this.textContent != null) {
                DefaultXMLWriter.this.writer.write(StringEscapeUtils.escapeXml((String)this.textContent));
            }
        }

        private void insertIndentation() throws IOException {
            if (XMLWriterPreferences.getInstance().isIndenting()) {
                int i = 0;
                while (i < this.indentation * XMLWriterPreferences.getInstance().getIndentSize()) {
                    DefaultXMLWriter.this.writer.write(32);
                    ++i;
                }
            }
        }

        private void writeNewLine() throws IOException {
            DefaultXMLWriter.this.writer.write(10);
        }
    }
}

