/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.tests;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.ValueType;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import junit.framework.TestCase;

public abstract class AbstractOWLTestCase
extends TestCase {
    protected JenaOWLModel owlModel;
    protected Project project;
    protected OWLNamedClass owlThing;
    private static Properties junitProperties;

    public static void assertContains(Object value, Collection collection) {
        AbstractOWLTestCase.assertTrue((boolean)collection.contains(value));
    }

    public static void assertContains(Object value, Iterator it) {
        AbstractOWLTestCase.assertTrue((boolean)Jena.set(it).contains(value));
    }

    public static void assertContainsNot(Object value, Iterator it) {
        AbstractOWLTestCase.assertFalse((boolean)Jena.set(it).contains(value));
    }

    public static void assertHasValue(OntResource individual, OntProperty property, ValueType valueType, Object expectedValue) {
        XSDDatatype type = XMLSchemaDatatypes.getDefaultXSDDatatype(valueType);
        NodeIterator it = individual.listPropertyValues((Property)property);
        while (it.hasNext()) {
            Literal literal;
            RDFNode node = it.nextNode();
            if (!(node instanceof Literal) || !type.equals((literal = (Literal)node).getDatatype()) || !literal.getValue().equals(expectedValue)) continue;
            return;
        }
        AbstractOWLTestCase.assertFalse((String)("Value " + expectedValue + " not found for " + property + " at " + individual), (boolean)true);
    }

    public static void assertSize(int size, Collection c) {
        AbstractOWLTestCase.assertEquals((int)size, (int)c.size());
    }

    public static void assertSize(int size, Iterator it) {
        AbstractOWLTestCase.assertEquals((int)size, (int)AbstractOWLTestCase.list(it).size());
    }

    protected void dumpRDF() {
        Jena.dumpRDF(this.owlModel.getOntModel());
    }

    public static URI getRemoteOntologyURI(String localFileName) {
        try {
            return new URI("http://www.co-ode.org/ontologies/testset/" + localFileName);
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            return null;
        }
    }

    public static URI getTestOntologyURI(String localFileName) {
        try {
            String fileName = "/projects/protege-owl/src/edu/stanford/smi/protegex/owl/jena/tests/" + localFileName;
            return new File(fileName).toURI();
        }
        catch (Exception ex) {
            AbstractOWLTestCase.assertFalse((String)("Could not find file: " + localFileName), (boolean)true);
            return null;
        }
    }

    public boolean hasTypedLiteral(Resource resource, DatatypeProperty property, Object value) {
        OntResource type = property.getRange();
        StmtIterator it = resource.listProperties((Property)property);
        while (it.hasNext()) {
            Statement s = it.nextStatement();
            RDFNode node = s.getObject();
            if (!node.canAs(Literal.class)) continue;
            Literal literal = (Literal)node.as(Literal.class);
            if (!type.getURI().equals(literal.getDatatype().getURI()) || !value.equals(literal.getValue())) continue;
            return true;
        }
        return false;
    }

    protected static List list(Iterator it) {
        ArrayList result = new ArrayList();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        OntDocumentManager.getInstance().reset(true);
        ArrayList errors = new ArrayList();
        JenaKnowledgeBaseFactory factory = new JenaKnowledgeBaseFactory();
        this.project = Project.createNewProject((KnowledgeBaseFactory)factory, errors);
        this.project.setKnowledgeBaseFactory((KnowledgeBaseFactory)factory);
        this.owlModel = (JenaOWLModel)this.project.getKnowledgeBase();
        this.owlThing = this.owlModel.getOWLThingClass();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project.dispose();
        this.project = null;
        this.owlModel = null;
        this.owlThing = null;
    }

    public static Properties getJunitProperties() {
        if (junitProperties != null) {
            return junitProperties;
        }
        try {
            Properties dbp = new Properties();
            String dbPropertyFile = String.valueOf(ApplicationProperties.getApplicationDirectory().getPath()) + File.separator + "junit.properties";
            FileInputStream is = new FileInputStream(dbPropertyFile);
            dbp.load(is);
            junitProperties = dbp;
            return junitProperties;
        }
        catch (Exception e) {
            return null;
        }
    }
}

