/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.range.OWLRangeWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class OWLDataRangeComponent
extends JComponent {
    private Action createAction = new AbstractAction("Create value...", OWLIcons.getAddIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLDataRangeComponent.this.createValue();
        }
    };
    private RDFSDatatype datatype;
    private Action deleteAction = new AbstractAction("Delete selected value...", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLDataRangeComponent.this.deleteSelectedValue();
        }
    };
    private JList list;
    private DefaultListModel listModel;
    private OWLRangeWidget rangeWidget;

    public OWLDataRangeComponent(OWLRangeWidget rangeWidget) {
        this.rangeWidget = rangeWidget;
        this.listModel = new DefaultListModel();
        this.list = new JList(this.listModel);
        this.setLayout(new BorderLayout());
        LabeledComponent lc = new LabeledComponent("Allowed values", new JScrollPane(this.list));
        lc.addHeaderButton(this.createAction);
        lc.addHeaderButton(this.deleteAction);
        this.add("Center", (Component)lc);
        this.deleteAction.setEnabled(false);
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                OWLDataRangeComponent.this.updateActions(true);
            }
        });
    }

    private void createValue() {
        String newValue = ProtegeUI.getModalDialogFactory().showInputDialog(this, "Enter a new " + this.datatype.getBrowserText() + " literal", null);
        if (newValue != null) {
            RDFProperty property = this.rangeWidget.getEditedProperty();
            if ((newValue = newValue.trim()).length() > 0) {
                OWLModel owlModel = property.getOWLModel();
                OWLDataRange newDataRange = null;
                RDFSLiteral newLiteral = owlModel.createRDFSLiteral(newValue, this.datatype);
                if (property.getRange() instanceof OWLDataRange) {
                    OWLDataRange dataRange = (OWLDataRange)property.getRange();
                    List values = dataRange.getOneOfValueLiterals();
                    RDFSLiteral[] newLiterals = new RDFSLiteral[values.size() + 1];
                    Iterator it = values.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        RDFSLiteral oldValue = (RDFSLiteral)it.next();
                        if (newLiteral.equals(oldValue)) {
                            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "The value " + newValue + " is already among the values.");
                            return;
                        }
                        newLiterals[i] = oldValue;
                        ++i;
                    }
                    newLiterals[newLiterals.length - 1] = newLiteral;
                    newDataRange = owlModel.createOWLDataRange(newLiterals);
                } else {
                    newDataRange = owlModel.createOWLDataRange(new RDFSLiteral[]{newLiteral});
                }
                property.setRange(newDataRange);
            }
        }
    }

    private void deleteSelectedValue() {
        int index = this.list.getSelectedIndex();
        if (index >= 0) {
            RDFProperty property = this.rangeWidget.getEditedProperty();
            OWLModel owlModel = property.getOWLModel();
            OWLDataRange oldDataRange = (OWLDataRange)property.getRange();
            List oldLiterals = oldDataRange.getOneOfValueLiterals();
            if (oldLiterals.size() == 1) {
                property.setRange(null);
            } else {
                oldLiterals.remove(index);
                RDFSLiteral[] newLiterals = oldLiterals.toArray(new RDFSLiteral[0]);
                property.setRange(owlModel.createOWLDataRange(newLiterals));
            }
        }
    }

    public void refill() {
        RDFResource range;
        this.listModel.clear();
        RDFProperty property = this.rangeWidget.getEditedProperty();
        if (property != null && (range = property.getRange()) instanceof OWLDataRange) {
            OWLDataRange dataRange = (OWLDataRange)range;
            List values = dataRange.getOneOfValueLiterals();
            for (RDFSLiteral literal : values) {
                this.listModel.addElement(literal);
            }
        }
    }

    public void setDatatype(RDFSDatatype datatype) {
        this.datatype = datatype;
        this.listModel.clear();
    }

    public void setEditable(boolean editable) {
        this.list.setEnabled(editable);
        this.updateActions(editable);
    }

    private void updateActions(boolean editable) {
        this.createAction.setEnabled(editable);
        this.deleteAction.setEnabled(editable && this.list.getSelectedValue() != null);
    }
}

