/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.xml;

import com.hp.hpl.jena.util.xml.SimpleXMLPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;

public class SimpleXMLPathIterator
implements Iterator {
    protected List m_stack;
    protected SimpleXMLPath m_path;
    protected boolean m_prepared = false;
    protected Object m_result;
    protected int m_len;

    public SimpleXMLPathIterator(SimpleXMLPath simpleXMLPath, Node node) {
        this.m_path = simpleXMLPath;
        this.m_len = simpleXMLPath.getPathComponents().size();
        this.m_stack = new ArrayList(this.m_len);
        this.m_stack.add(simpleXMLPath.getPathComponent(0).getAll(node));
        this.prepare();
    }

    public void remove() {
        throw new UnsupportedOperationException("Cannot remove from SimpleXMLPathIterator");
    }

    public boolean hasNext() {
        this.prepare();
        return this.m_result != null;
    }

    public Object next() {
        this.prepare();
        if (this.m_result == null) {
            throw new NoSuchElementException("No more values on this SimpleXMLPath");
        }
        this.m_prepared = false;
        return this.m_result;
    }

    protected void prepare() {
        if (!this.m_prepared) {
            this.evaluate();
            this.m_prepared = true;
        }
    }

    protected void evaluate() {
        int n;
        this.m_result = null;
        for (n = 0; n < this.min(this.m_len, this.m_stack.size()) && this.m_stack.get(n) != null; ++n) {
        }
        --n;
        while (n >= 0 && n < this.min(this.m_len, this.m_stack.size())) {
            Iterator iterator = (Iterator)this.m_stack.get(n);
            if (iterator == null) {
                --n;
                continue;
            }
            if (!iterator.hasNext()) {
                this.m_stack.add(n, null);
                this.m_result = null;
                --n;
                continue;
            }
            this.m_result = iterator.next();
            if (++n >= this.m_len) continue;
            this.m_stack.add(n, this.m_path.getPathComponent(n).getAll((Node)this.m_result));
        }
    }

    private int min(int n, int n2) {
        return n < n2 ? n : n2;
    }
}

