/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.ComponentDragger;
import edu.stanford.smi.protegex.owl.ui.code.SymbolEditor;
import edu.stanford.smi.protegex.owl.ui.code.SymbolErrorDisplay;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public abstract class SymbolPanel
extends JPanel
implements SymbolErrorDisplay {
    private Action backspaceAction;
    protected ResourceSelectionAction classAction;
    private JLabel errorLabel;
    protected ResourceSelectionAction individiualAction;
    private JButton nerdButton;
    private OWLModel owlModel;
    protected ResourceSelectionAction propertyAction;
    private SymbolEditor symbolEditor;

    public SymbolPanel(OWLModel owlModel, boolean closable) {
        this(owlModel, closable, false);
    }

    public SymbolPanel(OWLModel owlModel, boolean closable, boolean draggable) {
        this(owlModel, closable, draggable, true);
    }

    public SymbolPanel(OWLModel owlModel, final boolean closable, boolean draggable, boolean withMiddleBar) {
        this.owlModel = owlModel;
        this.setBackground(new Color(230, 230, 230));
        this.classAction = new InsertClassAction();
        this.propertyAction = new InsertPropertyAction();
        this.individiualAction = new InsertIndividualAction();
        this.errorLabel = new JLabel(" ");
        this.errorLabel.setFont(this.getFont().deriveFont(0));
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setOpaque(false);
        southPanel.add("Center", this.errorLabel);
        JToolBar topBar = ComponentFactory.createToolBar();
        JToolBar middleBar = withMiddleBar ? ComponentFactory.createToolBar() : null;
        JToolBar buttonBar = withMiddleBar ? middleBar : topBar;
        this.initTopBar(topBar);
        if (withMiddleBar) {
            this.initMiddleBar(middleBar);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(topBar);
        this.add(Box.createVerticalStrut(4));
        if (withMiddleBar) {
            this.add(middleBar);
            this.add(Box.createVerticalStrut(4));
        }
        this.add(southPanel);
        this.backspaceAction = new AbstractAction("Backspace", OWLIcons.getBackspaceIcon()){

            public void actionPerformed(ActionEvent e) {
                SymbolPanel.this.symbolEditor.backspace();
            }
        };
        this.addButton(buttonBar, this.backspaceAction);
        buttonBar.addSeparator();
        topBar.addSeparator(new Dimension(20, 0));
        this.nerdButton = ComponentFactory.addToolBarButton((JToolBar)topBar, (Action)new AbstractAction("Ok", OWLIcons.getNerdSmilingIcon()){

            public void actionPerformed(ActionEvent e) {
                if (closable) {
                    SymbolPanel.this.symbolEditor.assignExpression();
                } else {
                    SymbolPanel.this.symbolEditor.displayError();
                }
            }
        });
        this.setErrorFlag(false);
        if (closable) {
            this.addButton(topBar, new AbstractAction("Cancel editing", OWLIcons.getCloseIcon()){

                public void actionPerformed(ActionEvent e) {
                    SymbolPanel.this.symbolEditor.cancelEditing();
                }
            });
        }
        if (middleBar != null) {
            middleBar.add(Box.createHorizontalGlue());
        }
        topBar.add(Box.createHorizontalGlue());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        this.setSize(this.getPreferredSize());
        if (draggable) {
            ComponentDragger l = new ComponentDragger(this);
            this.addMouseListener(l);
            this.addMouseMotionListener(l);
        }
    }

    protected Action addAction(String text, String iconName, String insert, JToolBar toolBar) {
        return this.addAction(text, insert, OWLIcons.getImageIcon(iconName), toolBar);
    }

    private Action addAction(String text, final String insert, Icon icon, JToolBar toolBar) {
        String label = "Insert " + text;
        if (!text.equals(insert)) {
            label = String.valueOf(label) + " (" + insert + ")";
        }
        AbstractAction action = new AbstractAction(label, icon){

            public void actionPerformed(ActionEvent e) {
                SymbolPanel.this.symbolEditor.insertText(insert);
            }
        };
        JButton button = toolBar.add(action);
        button.setToolTipText(label);
        return action;
    }

    protected JButton addButton(JToolBar toolBar, Action action) {
        JButton button = toolBar.add(action);
        String label = (String)action.getValue("Name");
        button.setToolTipText(label);
        return button;
    }

    public void displayError(Throwable ex) {
        if (ex == null) {
            this.setErrorFlag(false);
            this.errorLabel.setText(" ");
        } else {
            this.setErrorFlag(true);
            String message = this.getDisplayErrorMessage(ex);
            this.errorLabel.setText("Error: " + message);
        }
    }

    protected abstract String getDisplayErrorMessage(Throwable var1);

    public void displayError(String message) {
        this.setErrorFlag(true);
        this.errorLabel.setText("Error: " + message);
    }

    public void enableActions(boolean clses, boolean instances) {
        this.classAction.setEnabled(clses);
        this.propertyAction.setEnabled(clses);
        this.individiualAction.setEnabled(instances || clses);
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    protected SymbolEditor getSymbolEditor() {
        return this.symbolEditor;
    }

    protected void initMiddleBar(JToolBar middleBar) {
    }

    protected abstract void initTopBar(JToolBar var1);

    protected void insertCls(Cls cls) {
        String name = cls.getName();
        this.symbolEditor.insertText(String.valueOf(name) + " ");
    }

    protected void insertIndividual(RDFResource instance) {
        String name = instance.getName();
        if (name.startsWith("xsd:")) {
            name = instance.getLocalName();
        }
        this.symbolEditor.insertText(String.valueOf(name) + " ");
    }

    protected void insertSlot(Slot slot) {
        String name = slot.getName();
        this.symbolEditor.insertText(String.valueOf(name) + " ");
    }

    public void setSymbolEditor(SymbolEditor editor) {
        this.symbolEditor = editor;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableActions(enabled, enabled);
        this.nerdButton.setEnabled(enabled);
        this.backspaceAction.setEnabled(enabled);
    }

    public void setErrorFlag(boolean error) {
        this.nerdButton.setIcon(error ? OWLIcons.getNerdErrorIcon() : OWLIcons.getNerdSmilingIcon());
        this.nerdButton.setToolTipText(error ? "Show error message" : "Assign (Ok)");
    }

    private class InsertClassAction
    extends ResourceSelectionAction {
        InsertClassAction() {
            super("Insert class...", OWLIcons.getImageIcon("PrimitiveClass"));
        }

        public void resourceSelected(RDFResource resource) {
            SymbolPanel.this.insertCls((Cls)resource);
        }

        public Collection getSelectableResources() {
            return OWLUtil.getSelectableNamedClses(SymbolPanel.this.owlModel);
        }

        public RDFResource pickResource() {
            return ProtegeUI.getSelectionDialogFactory().selectClass(SymbolPanel.this, SymbolPanel.this.owlModel);
        }
    }

    private class InsertIndividualAction
    extends ResourceSelectionAction {
        InsertIndividualAction() {
            super("Insert individual...", OWLIcons.getImageIcon("RDFIndividual"));
        }

        public void actionPerformed(ActionEvent e) {
            Set sels = ProtegeUI.getSelectionDialogFactory().selectResourcesByType(SymbolPanel.this, SymbolPanel.this.owlModel, Collections.singleton(SymbolPanel.this.owlModel.getOWLThingClass()), "Select the resources to insert");
            for (Frame frame : sels) {
                if (!(frame instanceof RDFResource)) continue;
                this.resourceSelected((RDFResource)frame);
            }
        }

        public void resourceSelected(RDFResource resource) {
            SymbolPanel.this.insertIndividual(resource);
        }

        public Collection getSelectableResources() {
            Collection frames = SymbolPanel.this.owlModel.getOWLIndividuals();
            ArrayList copy = new ArrayList(frames);
            Collections.sort(copy, new FrameComparator());
            return copy;
        }

        public RDFResource pickResource() {
            Collection resources = this.getSelectableResources();
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(SymbolPanel.this, SymbolPanel.this.owlModel, resources, "Select the resource to insert");
        }
    }

    private class InsertPropertyAction
    extends ResourceSelectionAction {
        InsertPropertyAction() {
            super("Insert property...", OWLIcons.getImageIcon("RDFProperty"));
        }

        public void resourceSelected(RDFResource resource) {
            SymbolPanel.this.insertSlot((Slot)resource);
        }

        public Collection getSelectableResources() {
            ArrayList<RDFProperty> result = new ArrayList<RDFProperty>();
            for (RDFProperty property : SymbolPanel.this.owlModel.getVisibleUserDefinedRDFProperties()) {
                if (property.isAnnotationProperty()) continue;
                result.add(property);
            }
            return result;
        }

        public RDFResource pickResource() {
            Collection properties = this.getSelectableResources();
            return ProtegeUI.getSelectionDialogFactory().selectResourceFromCollection(SymbolPanel.this, SymbolPanel.this.owlModel, properties, "Select the property to insert");
        }
    }
}

