/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.query.parser.ParserARQ;
import com.hp.hpl.jena.query.parser.ParserN3QL;
import com.hp.hpl.jena.query.parser.ParserRDQL;
import com.hp.hpl.jena.query.parser.ParserSPARQL;
import com.hp.hpl.jena.query.parser.ParserSPARQLalt;
import com.hp.hpl.jena.query.parser.ParserXML;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Parser {
    static Log log = LogFactory.getLog((Class)Parser.class);

    public abstract Query parse(Query var1, String var2) throws QueryParseException;

    public static boolean canParse(String string) {
        Parser parser = Parser.createParser(string);
        return parser != null;
    }

    public static Parser createParser(String string) {
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL")) {
            return new ParserSPARQL();
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL-X")) {
            return new ParserXML();
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/ARQ")) {
            return new ParserARQ();
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL-alt")) {
            return new ParserSPARQLalt();
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/RDQL")) {
            return new ParserRDQL();
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/N3QL")) {
            return new ParserN3QL();
        }
        return null;
    }

    static void queryStep2(Query query2) {
        Iterator iterator;
        Set set;
        if (query2.isSelectType()) {
            if (query2.getQueryBlock() == null) {
                throw new QueryParseException("Missing WHERE clause in SELECT query");
            }
            if (query2.isQueryResultStar()) {
                set = query2.getQueryBlock().varsBound();
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    query2.addResultVar((String)iterator.next());
                }
            }
        }
        if (query2.isConstructType() && query2.getQueryBlock() == null) {
            throw new QueryParseException("Missing WHERE clause in CONSTRUCT query");
        }
        if (query2.isDescribeType() && query2.isQueryResultStar()) {
            set = query2.getQueryBlock().varsBound();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                query2.addResultVar((String)iterator.next());
            }
        }
        if (query2.isAskType() && query2.getQueryBlock() == null) {
            throw new QueryParseException("Missing WHERE clause in ASK query");
        }
        if (query2.getQueryBlock() != null) {
            query2.getQueryBlock().phase2(query2);
        }
    }
}

