/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki.datatypes;

import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.util.iterator.Map1;
import org.daml.kazuki.Datatypes;

public class XSDgDay {
    private int day = 0;
    private static final int MIN_DAY = 1;
    private static final int MAX_DAY = 31;
    public static Map1 objectMapper = new ObjectMapper();

    public XSDgDay(XSDDateTime xSDDateTime) {
        this.setDay(xSDDateTime.getDays());
    }

    public XSDgDay(int n) {
        this.setDay(n);
    }

    public void setDay(int n) {
        if (1 <= n && n <= 31) {
            this.day = n;
        }
    }

    public int getDay() {
        return this.day;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("---");
        if (this.day < 10) {
            stringBuffer.append("0");
            stringBuffer.append(this.day);
        } else {
            stringBuffer.append(this.day);
        }
        return stringBuffer.toString();
    }

    protected static class ObjectMapper
    implements Map1 {
        protected ObjectMapper() {
        }

        public Object map1(Object object) {
            if (object instanceof Statement) {
                Literal literal = ((Statement)object).getLiteral();
                return Datatypes.getgDay(literal);
            }
            throw new IllegalArgumentException("RDF Statement expected while converting an XSDgDay.");
        }
    }
}

