/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.BooleanResultReasonerTask;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.util.Iterator;
import org.w3c.dom.Document;

public class IsConceptIntersectionSatisfiableTask
extends AbstractReasonerTask
implements BooleanResultReasonerTask {
    private OWLClass[] clses;
    private ProtegeOWLReasoner protegeOWLReasoner;
    private boolean satisfiable;

    public IsConceptIntersectionSatisfiableTask(OWLClass[] clses, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.clses = clses;
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.satisfiable = true;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        this.setProgress(0);
        this.setDescription("Computing satisfiability of concept intersection");
        this.setMessage("Building reasoner query...");
        Document asksDocument = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().createSatisfiableQuery(asksDocument, "q0", this.clses);
        this.setMessage("Querying reasoner...");
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(asksDocument);
        Iterator responseIt = this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc);
        if (responseIt.hasNext()) {
            DIGQueryResponse response = (DIGQueryResponse)responseIt.next();
            this.satisfiable = response.getBoolean();
        }
        this.setMessage("Complete");
        this.setProgress(1);
        this.setTaskCompleted();
    }

    public boolean getResult() {
        return this.satisfiable;
    }
}

