/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query.protege;

import java.util.HashSet;
import java.util.Set;

import edu.stanford.smi.protegex.owl.model.OWLClass;

/**
 * Instances of this class represent search parameters for service instances.
 * 
 * @author tilmann
 */
public class ProfileIndividualParameter {

	private Set<OWLClass> logicalInputs;

	private Set<OWLClass> logicalOutputs;

	private Set<OWLClass> preconditions;

	private Set<OWLClass> effects;

	private Set<OWLClass> userRoles;

	private OWLClass category;

	/**
	 * @return Returns the effects.
	 */
	public Set<OWLClass> getEffects() {
		return effects;
	}

	/**
	 * @param effects
	 *            The effects to set.
	 */
	public void setEffects(Set<OWLClass> effects) {
		this.effects = effects;
	}

	/**
	 * @return Returns the logicalInputs.
	 */
	public Set<OWLClass> getLogicalInputs() {
		return logicalInputs;
	}

	/**
	 * @param logicalInputs
	 *            The logicalInput to set.
	 */
	public void setLogicalInputs(Set<OWLClass> logicalInputs) {
		this.logicalInputs = logicalInputs;
	}

	/**
	 * @return Returns the logicalOutputs.
	 */
	public Set<OWLClass> getLogicalOutputs() {
		return logicalOutputs;
	}

	/**
	 * @param logicalOutputs
	 *            The logicalOutputs to set.
	 */
	public void setLogicalOutputs(Set<OWLClass> logicalOutputs) {
		this.logicalOutputs = logicalOutputs;
	}

	/**
	 * @return Returns the preconditions.
	 */
	public Set<OWLClass> getPreconditions() {
		return preconditions;
	}

	/**
	 * @param preconditions
	 *            The preconditions to set.
	 */
	public void setPreconditions(Set<OWLClass> preconditions) {
		this.preconditions = preconditions;
	}

	/**
	 * @return Returns the category.
	 */
	public OWLClass getCategory() {
		return category;
	}

	/**
	 * @param category
	 *            The category to set.
	 */
	public void setCategory(OWLClass category) {
		this.category = category;
	}

	/**
	 * @return Returns the userRoles.
	 */
	public Set<OWLClass> getUserRoles() {
		return userRoles;
	}

	/**
	 * @param userRoles
	 *            The userRoles to set.
	 */
	public void setUserRoles(Set<OWLClass> userRoles) {
		this.userRoles = userRoles;
	}

	public ProfileIndividualParameter clone() {
		ProfileIndividualParameter clone = new ProfileIndividualParameter();
		clone.setEffects(new HashSet<OWLClass>(effects));
		clone.setPreconditions(new HashSet<OWLClass>(preconditions));
		clone.setLogicalOutputs(new HashSet<OWLClass>(logicalOutputs));
		clone.setLogicalInputs(new HashSet<OWLClass>(logicalInputs));
		clone.setUserRoles(new HashSet<OWLClass>(userRoles));
		clone.setCategory(category);
		return clone;
	}

}
