/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFrameStoreInvocationHandler
implements InvocationHandler {
    private static final Logger log = Log.getLogger(AbstractFrameStoreInvocationHandler.class);
    private FrameStore _delegate;
    private static final Set specialMethods = new HashSet();

    private static Method getMethod(String string) throws Exception {
        return AbstractFrameStoreInvocationHandler.getMethod(FrameStore.class, string);
    }

    private static Method getMethod(Class clazz, String string) throws Exception {
        return clazz.getMethod(string, null);
    }

    private static Method getMethod(String string, Class clazz) throws Exception {
        return AbstractFrameStoreInvocationHandler.getMethod(FrameStore.class, string, clazz);
    }

    private static Method getMethod(Class clazz, String string, Class clazz2) throws Exception {
        return clazz.getMethod(string, clazz2);
    }

    private static boolean isSpecial(Method method) {
        return specialMethods.contains(method);
    }

    protected FrameStore getDelegate() {
        return this._delegate;
    }

    protected void setDelegate(FrameStore frameStore) {
        this._delegate = frameStore;
    }

    public static FrameStore newInstance(Class clazz) {
        return AbstractFrameStoreInvocationHandler.newInstance(clazz, null);
    }

    public static Object getInstance(Class clazz, KnowledgeBase knowledgeBase) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object t;
        try {
            Constructor constructor = clazz.getConstructor(KnowledgeBase.class);
            t = constructor.newInstance(knowledgeBase);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            t = clazz.newInstance();
        }
        return t;
    }

    public static FrameStore newInstance(Class clazz, KnowledgeBase knowledgeBase) {
        FrameStore frameStore = null;
        try {
            AbstractFrameStoreInvocationHandler abstractFrameStoreInvocationHandler = (AbstractFrameStoreInvocationHandler)AbstractFrameStoreInvocationHandler.getInstance(clazz, knowledgeBase);
            frameStore = (FrameStore)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{FrameStore.class}, (InvocationHandler)abstractFrameStoreInvocationHandler);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return frameStore;
    }

    protected static boolean isQuery(Method method) {
        String string = method.getName();
        return string.startsWith("get");
    }

    protected static boolean isModification(Method method) {
        return !AbstractFrameStoreInvocationHandler.isQuery(method) && !method.getName().equals("reinitialize");
    }

    public Object invoke(Object object, Method method, Object[] objectArray) {
        Object object2 = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("invoking " + StringUtilities.getClassName(this));
        }
        if (AbstractFrameStoreInvocationHandler.isSpecial(method)) {
            object2 = this.invokeSpecial(object, method, objectArray);
        } else if (this._delegate != null) {
            object2 = this.handleInvoke(method, objectArray);
        }
        return object2;
    }

    private Object invokeSpecial(Object object, Method method, Object[] objectArray) {
        Object object2 = null;
        String string = method.getName();
        if (string.equals("toString")) {
            object2 = this.toString();
        } else if (string.equals("equals")) {
            object2 = object == objectArray[0];
        } else if (string.equals("getDelegate")) {
            object2 = this._delegate;
        } else if (string.equals("setDelegate")) {
            this._delegate = (FrameStore)objectArray[0];
        } else if (string.equals("close")) {
            this.handleClose();
            this._delegate = null;
        } else if (string.equals("reinitialize")) {
            this.handleReinitialize();
        }
        return object2;
    }

    protected void handleReinitialize() {
    }

    protected void handleClose() {
    }

    protected abstract Object handleInvoke(Method var1, Object[] var2);

    protected Object invoke(Method method, Object[] objectArray) {
        return AbstractFrameStoreInvocationHandler.invoke(method, objectArray, this._delegate);
    }

    protected static Object invoke(Method method, Object[] objectArray, FrameStore frameStore) {
        Object object = null;
        try {
            object = method.invoke((Object)frameStore, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.getLogger().warning(Log.toString(illegalAccessException));
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            Log.getLogger().warning(Log.toString(throwable));
        }
        return object;
    }

    public String toString() {
        return StringUtilities.getClassName(this);
    }

    static {
        try {
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod(Object.class, "toString"));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod(Object.class, "equals", Object.class));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod("getDelegate"));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod("setDelegate", FrameStore.class));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod("close"));
            specialMethods.add(AbstractFrameStoreInvocationHandler.getMethod("reinitialize"));
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
    }
}

