/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.framestore.IncludingKBAdapter;
import edu.stanford.smi.protege.model.framestore.IncludingKBSupport;
import edu.stanford.smi.protege.storage.database.DatabaseFrameDb;
import edu.stanford.smi.protege.storage.database.RobustConnection;
import edu.stanford.smi.protege.storage.database.SelectStatement;
import edu.stanford.smi.protege.storage.database.ValueCachingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IncludingDatabaseAdapter
extends IncludingKBAdapter
implements IncludingKBSupport {
    private static Logger log = Log.getLogger(IncludingDatabaseAdapter.class);
    private ValueCachingNarrowFrameStore delegate;
    private DatabaseFrameDb frameDb;
    private Map<Integer, String> includedIdCache = new HashMap<Integer, String>();
    private int dbCallCounter = 0;
    private String tableName;

    public IncludingDatabaseAdapter(ValueCachingNarrowFrameStore valueCachingNarrowFrameStore) {
        super(valueCachingNarrowFrameStore);
        this.delegate = valueCachingNarrowFrameStore;
        this.frameDb = valueCachingNarrowFrameStore.getDelegate();
    }

    public void initialize(FrameFactory frameFactory, String string, String string2, String string3, String string4, String string5, boolean bl) {
        block2: {
            this.frameDb.initialize(frameFactory, string, string2, string3, string4, string5, bl);
            super.initialize(frameFactory);
            try {
                this.initializeInheritanceTable();
            }
            catch (SQLException sQLException) {
                Log.getLogger().severe("Exception found " + sQLException + " (use fine logging for more info)");
                if (!Log.getLogger().isLoggable(Level.FINE)) break block2;
                log.log(Level.FINE, "Exception found ", sQLException);
            }
        }
    }

    protected void initializeInheritanceTable() throws SQLException {
        this.tableName = IncludingDatabaseAdapter.getTableName(this.frameDb.getTableName());
        IncludingDatabaseAdapter.initializeInheritanceTable(this.tableName, this.frameDb.getCurrentConnection());
    }

    protected static String getTableName(String string) {
        return string + "_INCLUDES";
    }

    protected static void initializeInheritanceTable(String string, RobustConnection robustConnection) {
        block2: {
            String string2 = "CREATE TABLE " + string + " (" + (Object)((Object)Column.local_frame_id) + " INT, " + (Object)((Object)Column.frame_name) + " " + robustConnection.getVarcharTypeName() + "(" + robustConnection.getMaxVarcharSize() + "))";
            String string3 = "CREATE UNIQUE INDEX " + string + "_I1 ON " + string + "(" + (Object)((Object)Column.local_frame_id) + ")";
            try {
                IncludingDatabaseAdapter.execute(string2, robustConnection);
                IncludingDatabaseAdapter.execute(string3, robustConnection);
            }
            catch (SQLException sQLException) {
                if (!Log.getLogger().isLoggable(Level.FINE)) break block2;
                Log.getLogger().fine("Exception caught creating database" + sQLException);
                Log.getLogger().fine(" ... but expecting an already created exception");
            }
        }
    }

    public boolean isLocalFrameIncluded(Frame frame) {
        if (this.noIncludedFrames()) {
            return false;
        }
        return this.getLocalIncludedName(frame) != null;
    }

    private String getLocalIncludedName(Frame frame) {
        if (this.noIncludedFrames()) {
            return null;
        }
        Integer n = new Integer(frame.getFrameID().getLocalPart());
        String string = this.includedIdCache.get(n);
        if (string != null) {
            return string;
        }
        try {
            Statement statement = this.frameDb.getCurrentConnection().getStatement();
            SelectStatement<Column> selectStatement = new SelectStatement<Column>(EnumSet.of(Column.frame_name));
            String string2 = selectStatement.toString() + " FROM " + this.tableName + " WHERE " + (Object)((Object)Column.local_frame_id) + " = " + n;
            ResultSet resultSet = this.executeQuery(string2);
            if (resultSet.next()) {
                string = resultSet.getString(selectStatement.rsIndex(Column.frame_name));
                this.includedIdCache.put(n, string);
                resultSet.close();
                return string;
            }
            resultSet.close();
            return null;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public Frame mapLocalFrame(Frame frame) {
        Frame frame2;
        if (log.isLoggable(Level.FINEST) && frame != null) {
            log.finest("(" + this.memoryProjectId + ") Mapping local frame with id " + frame.getFrameID());
        }
        if (this.noIncludedFrames() || frame == null || frame.getFrameID().isSystem()) {
            return frame;
        }
        String string = this.getLocalIncludedName(frame);
        if (string != null && (frame2 = this.getIncludedFrames().getInheritedFrame(string)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("returning global frame with id = " + frame2.getFrameID());
            }
            return frame2;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Global frame = local frame - no mapping found.");
        }
        return frame;
    }

    protected Frame createLocalFrame(Frame frame, String string) {
        try {
            Frame frame2 = super.createLocalFrame(frame, string);
            String string2 = this.getLocalIncludedName(frame2);
            int n = frame2.getFrameID().getLocalPart();
            if (string2 == null) {
                this.execute("INSERT INTO " + this.tableName + " (" + (Object)((Object)Column.local_frame_id) + ", " + (Object)((Object)Column.frame_name) + ") VALUES (" + n + ", '" + string + "')");
                this.includedIdCache.put(new Integer(n), string);
            } else if (!string2.equals(string)) {
                Log.getLogger().severe("Name mismatch on included frames");
            }
            return frame2;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
    }

    public boolean execute(String string) throws SQLException {
        return IncludingDatabaseAdapter.execute(string, this.frameDb.getCurrentConnection());
    }

    public static boolean execute(String string, RobustConnection robustConnection) throws SQLException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Executing database command = " + string);
        }
        Statement statement = robustConnection.getStatement();
        return statement.execute(string);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        long l = 0L;
        if (log.isLoggable(Level.FINER)) {
            log.finer("Executing database query = " + string);
            l = System.currentTimeMillis();
        }
        Statement statement = this.frameDb.getCurrentConnection().getStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Database query took " + (System.currentTimeMillis() - l) + " milliseconds");
        }
        return resultSet;
    }

    public int getFrameCount() {
        int n = this.frameDb.getFrameCount();
        if (log.isLoggable(Level.FINE)) {
            log.fine("found " + n + " total frames");
        }
        int n2 = 0;
        try {
            n2 = this.getIncludedFrameCount();
        }
        catch (SQLException sQLException) {
            Log.getLogger().log(Level.WARNING, "Exception caught", sQLException);
        }
        return n - n2;
    }

    public int getClsCount() {
        int n = this.frameDb.getClsCount();
        if (log.isLoggable(Level.FINE)) {
            log.fine("found " + n + " total frames");
        }
        int n2 = 0;
        try {
            n2 = this.getIncludedFrameCount();
        }
        catch (SQLException sQLException) {
            Log.getLogger().log(Level.WARNING, "Exception caught", sQLException);
        }
        return n - n2;
    }

    public int getSlotCount() {
        return this.frameDb.getSlotCount();
    }

    public int getFacetCount() {
        return this.frameDb.getFacetCount();
    }

    public int getIncludedFrameCount() throws SQLException {
        ResultSet resultSet = this.executeQuery("SELECT COUNT(" + (Object)((Object)Column.local_frame_id) + ") FROM " + this.tableName + " INNER JOIN " + this.frameDb.getTable() + " ON " + (Object)((Object)Column.local_frame_id) + " = " + (Object)((Object)DatabaseFrameDb.Column.frame));
        int n = 0;
        if (resultSet.next()) {
            n = resultSet.getInt(1);
        }
        resultSet.close();
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Column {
        local_frame_id,
        frame_name;

    }
}

