/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.Log;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class HashList
extends AbstractSequentialList
implements Cloneable,
Serializable {
    private transient Entry header = new Entry(null, null, null);
    private transient int size = 0;
    private Map _valueEntryMap = new HashMap();
    private List _unmodifiableList;

    public HashList() {
        this.header.next = this.header.previous = this.header;
    }

    public HashList(Collection collection) {
        this();
        this.addAll(collection);
    }

    public void add(int n, Object object) {
        this.addBefore(object, n == this.size ? this.header : this.entry(n));
    }

    public boolean add(Object object) {
        this.addBefore(object, this.header);
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        ++this.modCount;
        Entry entry = n == this.size ? this.header : this.entry(n);
        Entry entry2 = entry.previous;
        Iterator iterator = collection.iterator();
        for (int i = 0; i < n2; ++i) {
            Entry entry3;
            entry2.next = entry3 = this.newEntry(iterator.next(), entry, entry2);
            entry2 = entry3;
        }
        entry.previous = entry2;
        this.size += n2;
        return true;
    }

    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    private Entry addBefore(Object object, Entry entry) {
        Entry entry2;
        entry2.previous.next = entry2 = this.newEntry(object, entry, entry.previous);
        entry2.next.previous = entry2;
        ++this.size;
        ++this.modCount;
        return entry2;
    }

    public void addFirst(Object object) {
        this.addBefore(object, this.header.next);
    }

    private void addHashEntry(Entry entry) {
        Object object = entry.element;
        Object v = this._valueEntryMap.get(object);
        if (v == null) {
            this._valueEntryMap.put(object, entry);
        } else if (v instanceof List) {
            ((List)v).add(entry);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(v);
            arrayList.add(entry);
            this._valueEntryMap.put(object, arrayList);
        }
    }

    public void addLast(Object object) {
        this.addBefore(object, this.header);
    }

    public void clear() {
        ++this.modCount;
        this.header.next = this.header.previous = this.header;
        this._valueEntryMap.clear();
        this.size = 0;
    }

    public Object clone() {
        return new LinkedList(this);
    }

    public boolean contains(Object object) {
        return this.containsHashKey(object);
    }

    private boolean containsHashKey(Object object) {
        return this._valueEntryMap.containsKey(object);
    }

    private Entry entry(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        Entry entry = this.header;
        if (n < this.size / 2) {
            for (int i = 0; i <= n; ++i) {
                entry = entry.next;
            }
        } else {
            for (int i = this.size; i > n; --i) {
                entry = entry.previous;
            }
        }
        return entry;
    }

    public Object get(int n) {
        return this.entry((int)n).element;
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.next.element;
    }

    private Entry getFirstHashEntry(Object object) {
        Entry entry;
        Object v = this._valueEntryMap.get(object);
        if (v == null) {
            entry = null;
        } else if (v instanceof List) {
            List list = (List)v;
            entry = (Entry)list.get(0);
        } else {
            entry = (Entry)v;
        }
        return entry;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    private int getModCount() {
        return this.modCount;
    }

    public List getUnmodifiableList() {
        if (this._unmodifiableList == null) {
            this._unmodifiableList = Collections.unmodifiableList(this);
        }
        return this._unmodifiableList;
    }

    public int indexOf(Object object) {
        int n = 0;
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    return n;
                }
                ++n;
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    return n;
                }
                ++n;
                entry = entry.next;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size;
        if (object == null) {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n;
                if (entry.element == null) {
                    return n;
                }
                entry = entry.previous;
            }
        } else {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n;
                if (object.equals(entry.element)) {
                    return n;
                }
                entry = entry.previous;
            }
        }
        return -1;
    }

    public ListIterator listIterator(int n) {
        return new ListItr(n);
    }

    private Entry newEntry(Object object, Entry entry, Entry entry2) {
        Entry entry3 = new Entry(object, entry, entry2);
        this.addHashEntry(entry3);
        return entry3;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.header.next = this.header.previous = (this.header = this.newEntry(null, null, null));
        for (int i = 0; i < n; ++i) {
            this.add(objectInputStream.readObject());
        }
    }

    public Object remove(int n) {
        Entry entry = this.entry(n);
        this.remove(entry);
        return entry.element;
    }

    private void remove(Entry entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        --this.size;
        ++this.modCount;
        this.removeHashEntry(entry);
    }

    public boolean remove(Object object) {
        boolean bl;
        Entry entry = this.getFirstHashEntry(object);
        if (entry == null) {
            bl = false;
        } else {
            this.remove(entry);
            bl = true;
        }
        return bl;
    }

    public Object removeFirst() {
        Object object = this.header.next.element;
        this.remove(this.header.next);
        return object;
    }

    private void removeHashEntry(Entry entry) {
        Object object = entry.element;
        Object v = this._valueEntryMap.get(object);
        if (v == null) {
            Log.getLogger().warning("unable to remove: " + object);
        } else if (v instanceof List) {
            List list = (List)v;
            list.remove(entry);
            if (list.size() == 1) {
                this._valueEntryMap.put(object, list.get(0));
            }
        } else {
            Entry entry2 = (Entry)v;
            Assert.assertSame("entry", entry2.element, object);
            this._valueEntryMap.remove(object);
        }
    }

    private Entry removeHashEntry(Object object) {
        Entry entry = this.getFirstHashEntry(object);
        this.removeHashEntry(entry);
        return entry;
    }

    public Object removeLast() {
        Object object = this.header.previous.element;
        this.remove(this.header.previous);
        return object;
    }

    public void replace(int n, Object object) {
        Entry entry = this.entry(n);
        this.removeHashEntry(entry);
        entry.element = object;
        this.addHashEntry(entry);
    }

    public void replace(Object object, Object object2) {
        Entry entry = this.removeHashEntry(object);
        entry.element = object2;
        this.addHashEntry(entry);
    }

    public Object set(int n, Object object) {
        Entry entry = this.entry(n);
        Object object2 = entry.element;
        entry.element = object;
        this.addHashEntry(entry);
        return object2;
    }

    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n++] = entry.element;
            entry = entry.next;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n++] = entry.element;
            entry = entry.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    public String toString() {
        return "HashList";
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectOutputStream.writeObject(entry.element);
            entry = entry.next;
        }
    }

    private static class Entry
    implements Serializable {
        Object element;
        Entry next;
        Entry previous;

        Entry(Object object, Entry entry, Entry entry2) {
            this.element = object;
            this.next = entry;
            this.previous = entry2;
        }
    }

    private class ListItr
    implements ListIterator {
        private Entry lastReturned;
        private Entry next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int n) {
            this.lastReturned = HashList.this.header;
            this.expectedModCount = HashList.this.getModCount();
            if (n < 0 || n > HashList.this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + HashList.this.size);
            }
            if (n < HashList.this.size / 2) {
                this.next = ((HashList)HashList.this).header.next;
                this.nextIndex = 0;
                while (this.nextIndex < n) {
                    this.next = this.next.next;
                    ++this.nextIndex;
                }
            } else {
                this.next = HashList.this.header;
                this.nextIndex = HashList.this.size;
                while (this.nextIndex > n) {
                    this.next = this.next.previous;
                    --this.nextIndex;
                }
            }
        }

        public boolean hasNext() {
            return this.nextIndex != HashList.this.size;
        }

        public Object next() {
            this.checkForComodification();
            if (this.nextIndex == HashList.this.size) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.element;
        }

        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        public Object previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next = this.next.previous;
            --this.nextIndex;
            this.checkForComodification();
            return this.lastReturned.element;
        }

        public int nextIndex() {
            return this.nextIndex;
        }

        public int previousIndex() {
            return this.nextIndex - 1;
        }

        public void remove() {
            HashList.this.remove(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = this.lastReturned.next;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = HashList.this.header;
            ++this.expectedModCount;
        }

        public void set(Object object) {
            if (this.lastReturned == HashList.this.header) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            HashList.this.removeHashEntry(this.lastReturned);
            this.lastReturned.element = object;
            HashList.this.addHashEntry(this.lastReturned);
        }

        public void add(Object object) {
            this.checkForComodification();
            this.lastReturned = HashList.this.header;
            HashList.this.addBefore(object, this.next);
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        final void checkForComodification() {
            if (HashList.this.getModCount() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

