/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.core.Binding;
import com.hp.hpl.jena.query.core.Element;
import com.hp.hpl.jena.query.core.ElementVisitor;
import com.hp.hpl.jena.query.core.Mark;
import com.hp.hpl.jena.query.core.QueryIterRepeatApply;
import com.hp.hpl.jena.query.core.QueryIterator;
import com.hp.hpl.jena.query.util.iterator.QueryIterDefaulting;
import com.hp.hpl.jena.query.util.iterator.QueryIterFirstElement;
import com.hp.hpl.jena.query.util.iterator.QueryIterSingleton;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ElementOptional
extends Element {
    static Log log = LogFactory.getLog((Class)ElementOptional.class);
    Element element;

    public ElementOptional(Element element) {
        this.element = element;
    }

    public Element getElement() {
        return this.element;
    }

    public QueryIterator exec(Mark mark, QueryIterator queryIterator, DataSet dataSet) {
        if (queryIterator == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)mark.msg("Optional/no input"));
            }
            QueryIterator queryIterator2 = this.element.exec(mark, null, dataSet);
            if (ARQ.doNiceOptionals) {
                return new QueryIterDefaulting(queryIterator2, null);
            }
            return new QueryIterFirstElement(null, queryIterator2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)mark.msg("Optional"));
        }
        Mark mark2 = new Mark(mark);
        QueryIterRepeatApply queryIterRepeatApply = new QueryIterRepeatApply(mark2, dataSet, queryIterator, new Generator(this.element, mark));
        return queryIterRepeatApply;
    }

    protected void varsRequired(Set set) {
        this.element.varsRequired(set);
    }

    protected void varsBound(Set set) {
        this.element.varsBound(set);
    }

    public void visit(ElementVisitor elementVisitor) {
        elementVisitor.visit(this);
    }

    public void phase2(Query query2) {
        if (this.element != null) {
            this.element.phase2(query2);
        }
    }

    static class FirstBinding
    implements QueryIterFirstElement.DoFirst {
        Binding binding;

        FirstBinding(Binding binding) {
            this.binding = binding;
        }

        public boolean hasFirstElement(ClosableIterator closableIterator) {
            return this.binding != null;
        }

        public Object firstElement(ClosableIterator closableIterator) {
            return this.binding;
        }
    }

    static class Generator
    implements QueryIterRepeatApply.GeneratorBinding {
        Mark mark;
        Element element;

        Generator(Element element, Mark mark) {
            this.element = element;
            this.mark = mark;
        }

        public QueryIterator makeIterator(Mark mark, Binding binding, DataSet dataSet) {
            if (log.isDebugEnabled()) {
                log.debug((Object)this.mark.msg(mark + " makeIterator: " + binding));
            }
            QueryIterator queryIterator = this.element.exec(mark, new QueryIterSingleton(binding), dataSet);
            if (ARQ.doNiceOptionals) {
                return new QueryIterDefaulting(queryIterator, binding);
            }
            return new QueryIterFirstElement(new FirstBinding(binding), queryIterator);
        }
    }
}

