/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.tidy.impl.CNode;
import com.hp.hpl.jena.ontology.tidy.impl.CNodeI;
import com.hp.hpl.jena.ontology.tidy.impl.CategorySet;
import com.hp.hpl.jena.ontology.tidy.impl.Constants;
import com.hp.hpl.jena.ontology.tidy.impl.Lookup;
import com.hp.hpl.jena.ontology.tidy.impl.LookupTable;
import com.hp.hpl.jena.ontology.tidy.impl.SyntaxProblemImpl;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.EarlyBindingIterator;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

abstract class AbsChecker
implements Constants {
    boolean useRemove = true;
    int maxSz = 0;
    Lookup look = LookupTable.get();
    final boolean wantLite;
    int monotoneLevel = 1;
    Graph justForErrorMessages;
    Graph hasBeenChecked;
    Map nodeInfo = new HashMap();
    String eMessage;
    int eLevel;
    static int dCnt = 0;
    protected Set cyclicTouched;

    private void highTide() {
        int n = this.hasBeenChecked.size();
        if (n > this.maxSz) {
            this.maxSz = n;
        }
    }

    public int getHighTide() {
        this.highTide();
        return this.maxSz;
    }

    public void noremove() {
        this.useRemove = false;
    }

    AbsChecker(boolean bl) {
        this.hasBeenChecked = Factory.createDefaultGraph((ReificationStyle)ReificationStyle.Minimal);
        this.justForErrorMessages = Factory.createDefaultGraph((ReificationStyle)ReificationStyle.Minimal);
        this.wantLite = bl;
    }

    final boolean add(Triple triple, boolean bl) {
        return this.addX(triple, bl) != 0;
    }

    protected final void add(Triple triple) {
        this.add(triple, true);
    }

    CNodeI getCNode(Node node) {
        CNodeI cNodeI = (CNodeI)this.nodeInfo.get(node);
        if (cNodeI == null) {
            cNodeI = CNode.create(node, this);
            this.nodeInfo.put(node, cNodeI);
        }
        return cNodeI;
    }

    abstract boolean extraInfo();

    void dump() {
        System.err.println("AbsChecker dump.");
        Iterator iterator = this.nodeInfo.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Node node = (Node)entry.getKey();
            CNodeI cNodeI = (CNodeI)entry.getValue();
            System.err.println(CategorySet.catString(cNodeI.getCategories()) + " " + node.toString());
        }
        System.err.println("Has Been Checked:");
        ModelFactory.createModelForGraph((Graph)this.hasBeenChecked).write((OutputStream)System.err, "N-TRIPLE");
        if (this.justForErrorMessages != null) {
            System.err.println("Just for errors:");
            ModelFactory.createModelForGraph((Graph)this.justForErrorMessages).write((OutputStream)System.err, "N-TRIPLE");
        }
    }

    private void saveProblem(int n, String string) {
        this.eLevel = n;
        this.eMessage = string;
    }

    final synchronized int addX(Triple triple, boolean bl) {
        int n;
        CNodeI cNodeI;
        CNodeI cNodeI2 = this.getCNode(triple.getSubject());
        CNodeI cNodeI3 = this.getCNode(triple.getPredicate());
        int n2 = (cNodeI3 == (cNodeI = this.getCNode(triple.getObject())) ? 1 : 0) | (cNodeI2 == cNodeI ? 2 : 0) | (cNodeI2 == cNodeI3 ? 4 : 0);
        boolean bl2 = true;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = cNodeI2.getCategories();
        int n7 = cNodeI3.getCategories();
        int n8 = cNodeI.getCategories();
        int n9 = n6;
        int n10 = n7;
        int n11 = n8;
        int n12 = -1;
        if (!bl) {
            this.hasBeenChecked.delete(triple);
        }
        while (bl2 && (n6 != n3 || n7 != n4 || n8 != n5)) {
            n3 = n6;
            n4 = n7;
            n5 = n8;
            if (n12 != -1) {
                if (this.useRemove && this.look.removeTriple(n12)) {
                    this.highTide();
                    break;
                }
                this.look.done(n12);
            }
            if ((n12 = this.look.qrefine(n3, n4, n5)) == -1) {
                this.saveProblem(2, "Grammar Mismatch");
                bl2 = false;
            } else {
                if (this.look.dl(n12)) {
                    if (this.wantLite) {
                        bl2 = false;
                        this.saveProblem(1, "Only in DL");
                    } else {
                        this.setMonotoneLevel(2);
                    }
                }
                n3 = this.look.subject(n3, n12);
                n4 = this.look.prop(n4, n12);
                n5 = this.look.object(n5, n12);
                switch (n2) {
                    case 0: {
                        n = 0;
                        break;
                    }
                    case 1: {
                        n4 = n5 = this.look.meet(n4, n5);
                        n = n5;
                        break;
                    }
                    case 2: {
                        n3 = n5 = this.look.meet(n3, n5);
                        n = n5;
                        break;
                    }
                    case 4: {
                        n3 = n4 = this.look.meet(n3, n4);
                        n = n4;
                        break;
                    }
                    case 7: {
                        n4 = n5 = this.look.meet(this.look.meet(n3, n4), n5);
                        n3 = n5;
                        n = n5;
                        break;
                    }
                    default: {
                        throw new BrokenException("Impossible meetcase");
                    }
                }
                if (n == -1) {
                    this.saveProblem(2, "Grammar Mismatch (shared node in triple)");
                    bl2 = false;
                } else {
                    cNodeI.setCategories(n5, false);
                    cNodeI3.setCategories(n4, false);
                    cNodeI2.setCategories(n3, false);
                    bl2 = bl2 && cNodeI.update() && cNodeI3.update() && cNodeI2.update();
                }
            }
            n6 = cNodeI2.getCategories();
            n7 = cNodeI3.getCategories();
            n8 = cNodeI.getCategories();
        }
        if (bl2) {
            if (!this.useRemove || !this.look.removeTriple(n12)) {
                this.hasBeenChecked.add(triple);
            } else if (this.justForErrorMessages != null) {
                this.highTide();
                this.justForErrorMessages.add(triple);
            }
            this.actions(n12, cNodeI2, cNodeI, triple);
        } else {
            if (!bl) {
                this.hasBeenChecked.add(triple);
            } else {
                this.addProblem(this.eLevel, triple, this.eMessage);
            }
            cNodeI2.setCategories(n9, false);
            cNodeI3.setCategories(n10, false);
            cNodeI.setCategories(n11, false);
        }
        if (bl2 && n7 == 62) {
            if (cNodeI2.equals(cNodeI) && triple.getSubject().isBlank()) {
                this.addProblem(2, triple, "owl:disjointWith cannot form a loop");
                bl2 = false;
            } else {
                cNodeI2.addDisjoint(cNodeI);
            }
        }
        if (!bl2) {
            this.setMonotoneLevel(this.wantLite ? 2 : 3);
            n = 0;
        } else {
            n = n6 == n9 && n7 == n10 && n8 == n11 ? 1 : 2;
        }
        this.look.done(n12);
        return n;
    }

    void setMonotoneLevel(int n) {
        if (this.monotoneLevel < n) {
            this.monotoneLevel = n;
        }
    }

    abstract void actions(int var1, CNodeI var2, CNodeI var3, Triple var4);

    boolean recursivelyUpdate(Node node) {
        return this.rec(node, null, null) && this.rec(null, node, null) && this.rec(null, null, node);
    }

    private boolean rec(Node node, Node node2, Node node3) {
        boolean bl = true;
        EarlyBindingIterator earlyBindingIterator = new EarlyBindingIterator((Iterator)this.hasBeenChecked.find(node, node2, node3));
        while (bl && earlyBindingIterator.hasNext()) {
            bl = this.add((Triple)earlyBindingIterator.next(), false);
        }
        earlyBindingIterator.close();
        return bl;
    }

    void addProblem(int n, Triple triple, String string) {
        this.setMonotoneLevel(n + 1);
    }

    void addProblem(SyntaxProblemImpl syntaxProblemImpl) {
        this.setMonotoneLevel(syntaxProblemImpl.getLevel() + 1);
    }

    void addDisjoint(Node node, Node node2) {
    }

    public void setOptimizeMemory(boolean bl) {
        if (bl) {
            this.justForErrorMessages = null;
        } else if (this.justForErrorMessages == null) {
            this.justForErrorMessages = Factory.createDefaultGraph((ReificationStyle)ReificationStyle.Minimal);
        }
    }
}

