/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.NodeCache;
import com.hp.hpl.jena.graph.NodeVisitor;
import com.hp.hpl.jena.graph.Node_ANY;
import com.hp.hpl.jena.graph.Node_Blank;
import com.hp.hpl.jena.graph.Node_Literal;
import com.hp.hpl.jena.graph.Node_NULL;
import com.hp.hpl.jena.graph.Node_URI;
import com.hp.hpl.jena.graph.Node_Variable;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Node {
    protected final Object label;
    static final int THRESHOLD = 10000;
    static final NodeCache present = new NodeCache();
    static final Log log = LogFactory.getLog((Class)Node.class);
    public static final Node ANY = new Node_ANY();
    static final String RDFprefix = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static final NodeMaker makeAnon = new NodeMaker(){

        Node construct(Object object) {
            return new Node_Blank(object);
        }
    };
    static final NodeMaker makeLiteral = new NodeMaker(){

        Node construct(Object object) {
            return new Node_Literal(object);
        }
    };
    static final NodeMaker makeURI = new NodeMaker(){

        Node construct(Object object) {
            return new Node_URI(object);
        }
    };
    static final NodeMaker makeVariable = new NodeMaker(){

        Node construct(Object object) {
            return new Node_Variable(object);
        }
    };
    public static final Node NULL = new Node_NULL();
    private static boolean caching = true;

    public static Node create(String string) {
        return Node.create(PrefixMapping.Extended, string);
    }

    public static Node create(PrefixMapping prefixMapping, String string) {
        if (string.equals("")) {
            throw new JenaException("Node.create does not accept an empty string as argument");
        }
        char c = string.charAt(0);
        if (c == '\'' || c == '\"') {
            return Node.createLiteral(Node.newString(prefixMapping, c, string));
        }
        if (Character.isDigit(c)) {
            return Node.createLiteral(new LiteralLabel(string, "", (RDFDatatype)XSDDatatype.XSDinteger));
        }
        if (c == '_') {
            return Node.createAnon(new AnonId(string));
        }
        if (string.equals("??")) {
            return ANY;
        }
        if (c == '?') {
            return Node.createVariable(string.substring(1));
        }
        if (c == '&') {
            return Node.createURI("q:" + string.substring(1));
        }
        int n = string.indexOf(58);
        String string2 = prefixMapping.getNsPrefixURI("");
        return n < 0 ? Node.createURI((string2 == null ? "eh:/" : string2) + string) : Node.createURI(prefixMapping.expandPrefix(string));
    }

    private static RDFDatatype getType(String string) {
        return TypeMapper.getInstance().getSafeTypeByName(string);
    }

    private static LiteralLabel literal(PrefixMapping prefixMapping, String string, String string2) {
        String string3 = Node.unEscape(string);
        int n = string2.indexOf(58);
        return n < 0 ? new LiteralLabel(string3, string2, false) : new LiteralLabel(string3, "", Node.getType(prefixMapping.expandPrefix(string2)));
    }

    private static String unEscape(String string) {
        int n;
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while ((n = string.indexOf(92, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(Node.unEscape(string.charAt(n + 1)));
            n2 = n + 2;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private static char unEscape(char c) {
        switch (c) {
            case '\"': 
            case '\'': 
            case '\\': {
                return c;
            }
            case 'n': {
                return '\n';
            }
            case 's': {
                return ' ';
            }
            case 't': {
                return '\t';
            }
        }
        return 'Z';
    }

    private static LiteralLabel newString(PrefixMapping prefixMapping, char c, String string) {
        int n = string.lastIndexOf(c);
        return Node.literal(prefixMapping, string.substring(1, n), string.substring(n + 1));
    }

    public static Node createAnon(AnonId anonId) {
        return Node.create(makeAnon, anonId);
    }

    public static Node createLiteral(LiteralLabel literalLabel) {
        return Node.create(makeLiteral, literalLabel);
    }

    public static Node createURI(String string) {
        return Node.create(makeURI, (Object)string);
    }

    public static Node createAnon() {
        return Node.createAnon(new AnonId());
    }

    public static Node createVariable(String string) {
        return Node.create(makeVariable, Node_Variable.variable(string));
    }

    public static Node createLiteral(String string) {
        return Node.createLiteral(string, "", false);
    }

    public static Node createLiteral(String string, String string2, boolean bl) {
        if (string == null) {
            throw new NullPointerException("null for literals has been illegal since Jena 2.0");
        }
        return Node.createLiteral(new LiteralLabel(string, string2, bl));
    }

    public static Node createLiteral(String string, String string2, RDFDatatype rDFDatatype) throws DatatypeFormatException {
        return Node.createLiteral(new LiteralLabel(string, string2, rDFDatatype));
    }

    public static Node createUncachedLiteral(Object object, String string, RDFDatatype rDFDatatype) throws DatatypeFormatException {
        return new Node_Literal(new LiteralLabel(object, string, rDFDatatype));
    }

    public abstract Object visitWith(NodeVisitor var1);

    public abstract boolean isConcrete();

    public boolean isLiteral() {
        return false;
    }

    public boolean isBlank() {
        return false;
    }

    public boolean isURI() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public AnonId getBlankNodeId() {
        throw new UnsupportedOperationException(this + " is not a blank node");
    }

    public LiteralLabel getLiteral() {
        throw new UnsupportedOperationException(this + " is not a literal node");
    }

    public String getURI() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getNameSpace() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getLocalName() {
        throw new UnsupportedOperationException(this + " is not a URI node");
    }

    public String getName() {
        throw new UnsupportedOperationException("this (" + this.getClass() + ") is not a variable node");
    }

    public boolean hasURI(String string) {
        return false;
    }

    Node(Object object) {
        this.label = object;
    }

    public static void cache(boolean bl) {
        if (!bl) {
            present.clear();
        }
        caching = bl;
    }

    public static synchronized Node create(NodeMaker nodeMaker, Object object) {
        if (object == null) {
            throw new JenaException("Node.make: null label");
        }
        Node node = present.get(object);
        return node == null ? Node.cacheNewNode(object, nodeMaker.construct(object)) : node;
    }

    private static Node cacheNewNode(Object object, Node node) {
        if (present.size() > 10000) {
            present.clear();
        }
        if (caching) {
            present.put(object, node);
        }
        return node;
    }

    public abstract boolean equals(Object var1);

    public boolean sameValueAs(Object object) {
        return this.equals(object);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean matches(Node node) {
        return this.equals(node);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(boolean bl) {
        return this.toString(null, bl);
    }

    public String toString(PrefixMapping prefixMapping) {
        return this.toString(prefixMapping, true);
    }

    public String toString(PrefixMapping prefixMapping, boolean bl) {
        return this.label.toString();
    }

    static abstract class NodeMaker {
        NodeMaker() {
        }

        abstract Node construct(Object var1);
    }
}

