/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.enhanced.Implementation;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.ontology.ConversionException;
import com.hp.hpl.jena.ontology.daml.DAMLDatatype;
import com.hp.hpl.jena.ontology.daml.impl.DAMLCommonImpl;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;

public class DAMLDatatypeImpl
extends DAMLCommonImpl
implements DAMLDatatype {
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new DAMLDatatypeImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to DAMLDatatype");
        }

        public boolean canWrap(Node node, EnhGraph enhGraph) {
            return enhGraph.asGraph().contains(node, RDF.type.asNode(), DAML_OIL.Datatype.asNode());
        }
    };

    public DAMLDatatypeImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public RDFDatatype getTranslator() {
        return TypeMapper.getInstance().getTypeByName(this.getURI());
    }
}

