/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.shared.JenaException;

public abstract class StatementBase {
    protected final ModelCom model;

    protected StatementBase(ModelCom modelCom) {
        if (modelCom == null) {
            throw new JenaException("Statement models must no be null");
        }
        this.model = modelCom;
    }

    public Model getModel() {
        return this.model;
    }

    protected abstract StatementImpl replace(RDFNode var1);

    public abstract Literal getLiteral();

    public abstract Resource getResource();

    public abstract Resource getSubject();

    public abstract Property getPredicate();

    public abstract RDFNode getObject();

    protected StatementImpl stringReplace(String string, String string2, boolean bl) {
        return this.replace(new LiteralImpl(Node.createLiteral(string, string2, bl), this.model));
    }

    protected StatementImpl stringReplace(String string) {
        return this.stringReplace(string, "", false);
    }

    public Statement changeObject(boolean bl) {
        return this.stringReplace(String.valueOf(bl));
    }

    public Statement changeObject(long l) {
        return this.stringReplace(String.valueOf(l));
    }

    public Statement changeObject(char c) {
        return this.stringReplace(String.valueOf(c));
    }

    public Statement changeObject(float f) {
        return this.stringReplace(String.valueOf(f));
    }

    public Statement changeObject(double d) {
        return this.stringReplace(String.valueOf(d));
    }

    public Statement changeObject(String string) {
        return this.stringReplace(String.valueOf(string));
    }

    public Statement changeObject(String string, boolean bl) {
        return this.stringReplace(String.valueOf(string), "", bl);
    }

    public Statement changeObject(String string, String string2) {
        return this.stringReplace(String.valueOf(string), string2, false);
    }

    public Statement changeObject(String string, String string2, boolean bl) {
        return this.stringReplace(String.valueOf(string), string2, bl);
    }

    public Statement changeObject(RDFNode rDFNode) {
        return this.replace(rDFNode);
    }

    public Statement changeObject(Object object) {
        return object instanceof RDFNode ? this.replace((RDFNode)object) : this.stringReplace(object.toString());
    }

    public boolean getBoolean() {
        return this.getLiteral().getBoolean();
    }

    public byte getByte() {
        return this.getLiteral().getByte();
    }

    public short getShort() {
        return this.getLiteral().getShort();
    }

    public int getInt() {
        return this.getLiteral().getInt();
    }

    public long getLong() {
        return this.getLiteral().getLong();
    }

    public char getChar() {
        return this.getLiteral().getChar();
    }

    public float getFloat() {
        return this.getLiteral().getFloat();
    }

    public double getDouble() {
        return this.getLiteral().getDouble();
    }

    public String getString() {
        return this.getLiteral().getLexicalForm();
    }

    protected Resource mustBeResource(RDFNode rDFNode) {
        if (rDFNode instanceof Resource) {
            return (Resource)rDFNode;
        }
        throw new ResourceRequiredException(rDFNode);
    }

    public String getLanguage() {
        return this.getLiteral().getLanguage();
    }

    public boolean getWellFormed() {
        return this.getLiteral().getWellFormed();
    }

    public String toString() {
        return "[" + ((Object)this.getSubject()).toString() + ", " + this.getPredicate().toString() + ", " + this.objectString(this.getObject()) + "]";
    }

    protected String objectString(RDFNode rDFNode) {
        return rDFNode.asNode().toString(null, true);
    }
}

