/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TripleCache;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.StringTokenizer;

public class Triple
implements TripleMatch {
    private final Node subj;
    private final Node pred;
    private final Node obj;
    protected static TripleCache cache = new TripleCache();
    public static final Triple ANY = Triple.create(Node.ANY, Node.ANY, Node.ANY);

    public Triple(Node node, Node node2, Node node3) {
        if (node == null) {
            throw new UnsupportedOperationException("subject cannot be null");
        }
        if (node2 == null) {
            throw new UnsupportedOperationException("predicate cannot be null");
        }
        if (node3 == null) {
            throw new UnsupportedOperationException("object cannot be null");
        }
        this.subj = node;
        this.pred = node2;
        this.obj = node3;
    }

    public String toString() {
        return this.toString(PrefixMapping.Standard);
    }

    public String toString(PrefixMapping prefixMapping) {
        return this.subj.toString(prefixMapping, true) + " @" + this.pred.toString(prefixMapping, true) + " " + this.obj.toString(prefixMapping, true);
    }

    public Node getSubject() {
        return this.subj;
    }

    public Node getPredicate() {
        return this.pred;
    }

    public Node getObject() {
        return this.obj;
    }

    public Node getMatchSubject() {
        return Triple.anyToNull(this.subj);
    }

    public Node getMatchPredicate() {
        return Triple.anyToNull(this.pred);
    }

    public Node getMatchObject() {
        return Triple.anyToNull(this.obj);
    }

    private static Node anyToNull(Node node) {
        return Node.ANY.equals(node) ? null : node;
    }

    private static Node nullToAny(Node node) {
        return node == null ? Node.ANY : node;
    }

    public Triple asTriple() {
        return this;
    }

    public boolean isConcrete() {
        return this.subj.isConcrete() && this.pred.isConcrete() && this.obj.isConcrete();
    }

    public boolean equals(Object object) {
        return object instanceof Triple && ((Triple)object).sameAs(this.subj, this.pred, this.obj);
    }

    public boolean sameAs(Node node, Node node2, Node node3) {
        return this.subj.equals(node) && this.pred.equals(node2) && this.obj.equals(node3);
    }

    public boolean matches(Triple triple) {
        return triple.matchedBy(this.subj, this.pred, this.obj);
    }

    public boolean matches(Node node, Node node2, Node node3) {
        return this.subj.matches(node) && this.pred.matches(node2) && this.obj.matches(node3);
    }

    private boolean matchedBy(Node node, Node node2, Node node3) {
        return node.matches(this.subj) && node2.matches(this.pred) && node3.matches(this.obj);
    }

    public boolean subjectMatches(Node node) {
        return this.subj.matches(node);
    }

    public boolean predicateMatches(Node node) {
        return this.pred.matches(node);
    }

    public boolean objectMatches(Node node) {
        return this.obj.matches(node);
    }

    public int hashCode() {
        return Triple.hashCode(this.subj, this.pred, this.obj);
    }

    public static int hashCode(Node node, Node node2, Node node3) {
        return node.hashCode() >> 1 ^ node2.hashCode() ^ node3.hashCode() << 1;
    }

    public static Triple create(Node node, Node node2, Node node3) {
        Triple triple = cache.get(node, node2, node3);
        return triple == null ? cache.put(new Triple(node, node2, node3)) : triple;
    }

    public static Triple createMatch(Node node, Node node2, Node node3) {
        return Triple.create(Triple.nullToAny(node), Triple.nullToAny(node2), Triple.nullToAny(node3));
    }

    public static Triple create(String string) {
        return Triple.create(PrefixMapping.Standard, string);
    }

    public static Triple create(PrefixMapping prefixMapping, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Node node = Node.create(prefixMapping, stringTokenizer.nextToken());
        Node node2 = Node.create(prefixMapping, stringTokenizer.nextToken());
        Node node3 = Node.create(prefixMapping, stringTokenizer.nextToken());
        return Triple.create(node, node2, node3);
    }
}

