/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.DisjointUnion;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestDisjointUnion
extends GraphTestBase {
    public TestDisjointUnion(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDisjointUnion.class);
    }

    public void testEmptyUnion() {
        DisjointUnion disjointUnion = new DisjointUnion(Graph.emptyGraph, Graph.emptyGraph);
        TestDisjointUnion.assertEquals((boolean)true, (boolean)disjointUnion.isEmpty());
    }

    public void testLeftUnion() {
        Graph graph = TestDisjointUnion.graphWith("");
        this.testSingleComponent(graph, new DisjointUnion(graph, Graph.emptyGraph));
    }

    public void testRightUnion() {
        Graph graph = TestDisjointUnion.graphWith("");
        this.testSingleComponent(graph, new DisjointUnion(Graph.emptyGraph, graph));
    }

    protected void testSingleComponent(Graph graph, DisjointUnion disjointUnion) {
        TestDisjointUnion.graphAdd(graph, "x R y; a P b; x Q b");
        TestDisjointUnion.assertIsomorphic(graph, disjointUnion);
        TestDisjointUnion.graphAdd(graph, "roses growOn you");
        TestDisjointUnion.assertIsomorphic(graph, disjointUnion);
        graph.delete(TestDisjointUnion.triple("a P b"));
        TestDisjointUnion.assertIsomorphic(graph, disjointUnion);
    }

    public void testBothComponents() {
        Graph graph = TestDisjointUnion.graphWith("");
        Graph graph2 = TestDisjointUnion.graphWith("");
        DisjointUnion disjointUnion = new DisjointUnion(graph, graph2);
        TestDisjointUnion.assertIsomorphic(Graph.emptyGraph, disjointUnion);
        graph.add(TestDisjointUnion.triple("x P y"));
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("x P y"), disjointUnion);
        graph2.add(TestDisjointUnion.triple("A rdf:type Route"));
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("x P y; A rdf:type Route"), disjointUnion);
    }

    public void testRemoveBoth() {
        Graph graph = TestDisjointUnion.graphWith("x R y; a P b");
        Graph graph2 = TestDisjointUnion.graphWith("x R y; p Q r");
        DisjointUnion disjointUnion = new DisjointUnion(graph, graph2);
        disjointUnion.delete(TestDisjointUnion.triple("x R y"));
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("a P b"), graph);
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("p Q r"), graph2);
    }

    public void testAddLeftOnlyIfNecessary() {
        Graph graph = TestDisjointUnion.graphWith("");
        Graph graph2 = TestDisjointUnion.graphWith("x R y");
        DisjointUnion disjointUnion = new DisjointUnion(graph, graph2);
        TestDisjointUnion.graphAdd(disjointUnion, "x R y");
        TestDisjointUnion.assertEquals((boolean)true, (boolean)graph.isEmpty());
        TestDisjointUnion.graphAdd(disjointUnion, " a P b");
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("a P b"), graph);
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("x R y"), graph2);
    }
}

