/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import com.hp.hpl.jena.rdf.arp.ARPRunnable;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.TokenPipe;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import com.hp.hpl.jena.shared.JenaException;
import org.xml.sax.SAXParseException;

class PushMePullYouPipe
extends TokenPipe {
    private volatile Throwable brokenPipe = null;
    private boolean open = true;
    private boolean overflow = false;
    private BoundedBuffer buffer = new BoundedBuffer(100);
    private Object pending = null;
    private static final String finished = "<finished>";
    private static final RuntimeException naturalEnd = new RuntimeException();
    private final Thread puller;

    PushMePullYouPipe(final ARPRunnable aRPRunnable) {
        this.puller = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    aRPRunnable.run();
                    PushMePullYouPipe.this.naturalDeath();
                }
                catch (Throwable throwable) {
                    PushMePullYouPipe.this.setException(throwable);
                }
            }
        };
    }

    void start() {
        this.puller.start();
    }

    private Object fetch() {
        try {
            return this.buffer.take();
        }
        catch (Exception exception) {
            throw new BoundedBufferTakeException(exception);
        }
    }

    private void putAny(Object object) throws SAXParseException {
        try {
            do {
                if (object == finished) continue;
                this.isPipeBroken();
            } while (!this.buffer.offer(object, 100L));
        }
        catch (InterruptedException interruptedException) {
            throw new BoundedBufferPutException(interruptedException);
        }
    }

    private void isPipeBroken() throws SAXParseException {
        if (this.brokenPipe != null) {
            if (this.brokenPipe == naturalEnd) {
                SAXParseException sAXParseException = new SAXParseException("RDF parsing finished, additional XML events", this.getLocator());
                this.overflow = true;
                throw sAXParseException;
            }
            try {
                throw this.brokenPipe;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Error error) {
                throw error;
            }
            catch (SAXParseException sAXParseException) {
                throw sAXParseException;
            }
            catch (Exception exception) {
                throw new WrappedException(exception);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Exception from RDF thread.", throwable);
            }
        }
    }

    public void putNextToken(Token token) throws SAXParseException {
        this.putAny(token);
    }

    public void close() throws SAXParseException {
        this.putAny(finished);
        try {
            this.puller.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.brokenPipe != naturalEnd) {
            this.isPipeBroken();
        }
    }

    private boolean hasNext() {
        if (this.open) {
            if (this.pending == null) {
                this.pending = this.fetch();
                if (this.pending == finished) {
                    this.open = false;
                }
                return this.open;
            }
            return true;
        }
        return false;
    }

    boolean exactlyExhausted() {
        return !this.overflow && !this.hasNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getNextToken() {
        if (!this.hasNext()) {
            return new Token(0, null);
        }
        try {
            Token token = (Token)this.pending;
            return token;
        }
        finally {
            this.pending = null;
        }
    }

    void naturalDeath() {
        this.setException(naturalEnd);
    }

    void setException(Throwable throwable) {
        this.brokenPipe = throwable;
    }

    static class BoundedBufferPutException
    extends JenaException {
        BoundedBufferPutException(Exception exception) {
            super(exception);
        }
    }

    static class BoundedBufferTakeException
    extends JenaException {
        BoundedBufferTakeException(Exception exception) {
            super(exception);
        }
    }
}

