/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer;

import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.ImportPlugin;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.util.WaitCursor;
import edu.stanford.smi.protegex.owl.jena.JenaFilePanel;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.importer.OWLImporter;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.Component;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;

public class JenaImportPlugin
implements ImportPlugin {
    public void dispose() {
    }

    public String getName() {
        return "OWL File";
    }

    public Project handleImportRequest() {
        Project result = null;
        JenaFilePanel panel = new JenaFilePanel();
        int rval = ProtegeUI.getModalDialogFactory().showDialog(null, panel, "OWL File to Import", 11);
        if (rval == 1) {
            String filePath = panel.getOWLFilePath();
            WaitCursor cursor = new WaitCursor((Component)ProjectManager.getProjectManager().getMainPanel());
            try {
                result = this.importProject(new File(filePath).toURI());
            }
            finally {
                cursor.hide();
            }
        }
        return result;
    }

    private Project importProject(URI uri) {
        ArrayList errors = new ArrayList();
        JenaKnowledgeBaseFactory jenaFactory = new JenaKnowledgeBaseFactory();
        Project owlProject = Project.createNewProject((KnowledgeBaseFactory)jenaFactory, errors);
        JenaOWLModel owlModel = (JenaOWLModel)owlProject.getKnowledgeBase();
        owlModel.load(uri, "RDF/XML-ABBREV", errors);
        if (errors.isEmpty()) {
            Project project = Project.createNewProject(null, new ArrayList());
            KnowledgeBase kb = project.getKnowledgeBase();
            new OWLImporter(owlModel, kb);
            return project;
        }
        return null;
    }
}

