/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classparser.dl;

import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.classparser.DatatypeNameChecker;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParserConstants;
import edu.stanford.smi.protegex.owl.model.classparser.dl.DLSyntaxParserTokenManager;
import edu.stanford.smi.protegex.owl.model.classparser.dl.JavaCharStream;
import edu.stanford.smi.protegex.owl.model.classparser.dl.ParseException;
import edu.stanford.smi.protegex.owl.model.classparser.dl.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Vector;

public class DLSyntaxParser
implements DLSyntaxParserConstants {
    private static DatatypeNameChecker datatypeChecker;
    private boolean create;
    private OWLModel owlModel;
    public DLSyntaxParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[17];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        DLSyntaxParser.jj_la1_0();
        DLSyntaxParser.jj_la1_1();
    }

    public static DatatypeNameChecker getDatatypeNameChecker() {
        return datatypeChecker;
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    public void setCreate(boolean b) {
        this.create = b;
    }

    public static OWLClass parseExpression(OWLModel owlModel, String expression, boolean create) throws ParseException {
        DLSyntaxParserTokenManager tokMan = new DLSyntaxParserTokenManager(new JavaCharStream(new StringReader(expression)));
        tokMan.setOWLModel(owlModel);
        DLSyntaxParser parser = new DLSyntaxParser(tokMan);
        parser.setCreate(create);
        parser.owlModel = owlModel;
        datatypeChecker = new DatatypeNameChecker(owlModel);
        return parser.parse();
    }

    public final OWLClass parse() throws ParseException {
        OWLClass result = this.OWLUnionClass();
        this.jj_consume_token(0);
        return result;
    }

    public final OWLClass OWLUnionClass() throws ParseException {
        ArrayList<OWLClass> operands = new ArrayList<OWLClass>();
        OWLClass cls = this.OWLIntersectionClass();
        operands.add(cls);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 31: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(31);
            cls = this.OWLIntersectionClass();
            operands.add(cls);
        }
        if (this.create) {
            if (operands.size() > 1) {
                return this.owlModel.createOWLUnionClass(operands);
            }
            return cls;
        }
        return null;
    }

    public final OWLClass OWLIntersectionClass() throws ParseException {
        ArrayList<OWLClass> operands = new ArrayList<OWLClass>();
        OWLClass cls = this.IntersectionClassOperand();
        operands.add(cls);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(32);
            cls = this.IntersectionClassOperand();
            operands.add(cls);
        }
        if (this.create) {
            if (operands.size() > 1) {
                return this.owlModel.createOWLIntersectionClass(operands);
            }
            return cls;
        }
        return null;
    }

    public final OWLClass IntersectionClassOperand() throws ParseException {
        OWLClass cls;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                cls = this.OWLNamedClass();
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                cls = this.OWLRestriction();
                break;
            }
            case 38: {
                cls = this.OWLComplementClass();
                break;
            }
            case 39: {
                cls = this.OWLEnumeratedClass();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cls;
    }

    public final OWLClass OWLNamedClass() throws ParseException {
        Token t = this.jj_consume_token(25);
        return this.owlModel.getOWLNamedClass(t.image);
    }

    public final OWLClass OWLRestriction() throws ParseException {
        OWLClass cls;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                cls = this.OWLAllValuesFromRestriction();
                break;
            }
            case 34: {
                cls = this.OWLSomeValuesFromRestriction();
                break;
            }
            case 36: {
                cls = this.OWLMaxCardinalityRestriction();
                break;
            }
            case 35: {
                cls = this.OWLMinCardinalityRestriction();
                break;
            }
            case 37: {
                cls = this.OWLCardinalityRestriction();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cls;
    }

    public final OWLClass OWLAllValuesFromRestriction() throws ParseException {
        OWLClass cls;
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                cls = this.OWLAllValuesFromDatatypePart();
                break;
            }
            case 26: {
                cls = this.OWLAllValuesFromObjectPart();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cls;
    }

    public final OWLClass OWLAllValuesFromDatatypePart() throws ParseException {
        OWLDatatypeProperty prop = this.DatatypeProperty();
        RDFSDatatype datatype = this.Datatype();
        if (this.create) {
            return this.owlModel.createOWLAllValuesFrom((RDFProperty)prop, datatype);
        }
        return null;
    }

    public final OWLClass OWLAllValuesFromObjectPart() throws ParseException {
        OWLObjectProperty prop = this.ObjectProperty();
        OWLClass filler = this.NestedClass();
        if (this.create) {
            return this.owlModel.createOWLAllValuesFrom((RDFProperty)prop, filler);
        }
        return null;
    }

    public final OWLClass OWLSomeValuesFromRestriction() throws ParseException {
        OWLClass cls;
        this.jj_consume_token(34);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                cls = this.OWLSomeValuesFromDatatypePart();
                break;
            }
            case 26: {
                cls = this.OWLSomeValuesFromObjectPart();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cls;
    }

    public final OWLClass OWLSomeValuesFromDatatypePart() throws ParseException {
        OWLDatatypeProperty prop = this.DatatypeProperty();
        RDFSDatatype filler = this.Datatype();
        if (this.create) {
            return this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, filler);
        }
        return null;
    }

    public final OWLClass OWLSomeValuesFromObjectPart() throws ParseException {
        OWLObjectProperty prop = this.ObjectProperty();
        OWLClass filler = this.NestedClass();
        if (this.create) {
            return this.owlModel.createOWLSomeValuesFrom((RDFProperty)prop, filler);
        }
        return null;
    }

    public final OWLClass OWLMinCardinalityRestriction() throws ParseException {
        OWLMinCardinality cls = null;
        this.jj_consume_token(35);
        int card = this.Integer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                cls = this.OWLMinCardinalityDatatypePart();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        cls = this.OWLMinCardinalityObjectPart();
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
            }
        }
        if (this.create && cls != null) {
            cls.setCardinality(card);
            return cls;
        }
        return null;
    }

    public final OWLMinCardinality OWLMinCardinalityDatatypePart() throws ParseException {
        OWLDatatypeProperty prop = this.DatatypeProperty();
        if (this.create) {
            OWLMinCardinality minCardi = this.owlModel.createOWLMinCardinality();
            minCardi.setOnProperty(prop);
            return minCardi;
        }
        return null;
    }

    public final OWLMinCardinality OWLMinCardinalityObjectPart() throws ParseException {
        OWLClass filler = null;
        OWLObjectProperty prop = this.ObjectProperty();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 25: 
            case 38: 
            case 39: {
                filler = this.NestedClass();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        if (this.create) {
            OWLMinCardinality minCardi = this.owlModel.createOWLMinCardinality();
            minCardi.setOnProperty(prop);
            if (filler != null) {
                minCardi.setValuesFrom(filler);
            }
            return minCardi;
        }
        return null;
    }

    public final OWLClass OWLMaxCardinalityRestriction() throws ParseException {
        OWLMaxCardinality cls = null;
        this.jj_consume_token(36);
        int card = this.Integer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                cls = this.OWLMaxCardinalityDatatypePart();
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        cls = this.OWLMaxCardinalityObjectPart();
                        break block0;
                    }
                }
                this.jj_la1[9] = this.jj_gen;
            }
        }
        if (this.create && cls != null) {
            cls.setCardinality(card);
            return cls;
        }
        return null;
    }

    public final OWLMaxCardinality OWLMaxCardinalityDatatypePart() throws ParseException {
        OWLDatatypeProperty prop = this.DatatypeProperty();
        if (this.create) {
            OWLMaxCardinality maxCardi = this.owlModel.createOWLMaxCardinality();
            maxCardi.setOnProperty(prop);
            return maxCardi;
        }
        return null;
    }

    public final OWLMaxCardinality OWLMaxCardinalityObjectPart() throws ParseException {
        OWLClass filler = null;
        OWLObjectProperty prop = this.ObjectProperty();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 25: 
            case 38: 
            case 39: {
                filler = this.NestedClass();
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        if (this.create) {
            OWLMaxCardinality maxCardi = this.owlModel.createOWLMaxCardinality();
            maxCardi.setOnProperty(prop);
            if (filler != null) {
                maxCardi.setValuesFrom(filler);
            }
            return maxCardi;
        }
        return null;
    }

    public final OWLClass OWLCardinalityRestriction() throws ParseException {
        OWLCardinality cls = null;
        this.jj_consume_token(37);
        int card = this.Integer();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                cls = this.OWLCardinalityDatatypePart();
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        cls = this.OWLCardinalityObjectPart();
                        break block0;
                    }
                }
                this.jj_la1[12] = this.jj_gen;
            }
        }
        if (this.create && cls != null) {
            cls.setCardinality(card);
            return cls;
        }
        return null;
    }

    public final OWLCardinality OWLCardinalityDatatypePart() throws ParseException {
        OWLDatatypeProperty prop = this.DatatypeProperty();
        if (this.create) {
            OWLCardinality cardi = this.owlModel.createOWLCardinality();
            cardi.setOnProperty(prop);
            return cardi;
        }
        return null;
    }

    public final OWLCardinality OWLCardinalityObjectPart() throws ParseException {
        OWLClass filler = null;
        OWLObjectProperty prop = this.ObjectProperty();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 25: 
            case 38: 
            case 39: {
                filler = this.NestedClass();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        if (this.create) {
            OWLCardinality cardi = this.owlModel.createOWLCardinality();
            cardi.setOnProperty(prop);
            if (filler != null) {
                cardi.setValuesFrom(filler);
            }
            return cardi;
        }
        return null;
    }

    public final OWLClass OWLComplementClass() throws ParseException {
        this.jj_consume_token(38);
        OWLClass cls = this.NestedClass();
        if (this.create) {
            return this.owlModel.createOWLComplementClass(cls);
        }
        return null;
    }

    public final OWLClass OWLEnumeratedClass() throws ParseException {
        ArrayList<OWLIndividual> individuals = new ArrayList<OWLIndividual>();
        this.jj_consume_token(39);
        OWLIndividual ind = this.Individual();
        individuals.add(ind);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 28: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            ind = this.Individual();
        }
        individuals.add(ind);
        this.jj_consume_token(40);
        return this.owlModel.createOWLEnumeratedClass(individuals);
    }

    public final RDFSDatatype Datatype() throws ParseException {
        Token token = this.jj_consume_token(24);
        return this.owlModel.getRDFSDatatypeByName(datatypeChecker.getDatatypeQName(token.image));
    }

    public final OWLDatatypeProperty DatatypeProperty() throws ParseException {
        Token t = this.jj_consume_token(27);
        OWLDatatypeProperty prop = this.owlModel.getOWLDatatypeProperty(t.image);
        return prop;
    }

    public final OWLObjectProperty ObjectProperty() throws ParseException {
        Token t = this.jj_consume_token(26);
        OWLObjectProperty prop = this.owlModel.getOWLObjectProperty(t.image);
        return prop;
    }

    public final OWLIndividual Individual() throws ParseException {
        Token t = this.jj_consume_token(28);
        return this.owlModel.getOWLIndividual(t.image);
    }

    public final OWLClass NestedClass() throws ParseException {
        OWLClass cls;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                cls = this.OWLNamedClass();
                break;
            }
            case 39: {
                cls = this.OWLEnumeratedClass();
                break;
            }
            case 38: {
                cls = this.OWLComplementClass();
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                cls = this.OWLUnionClass();
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return cls;
    }

    public final int Integer() throws ParseException {
        Token t = this.jj_consume_token(18);
        return Integer.parseInt(t.image);
    }

    private static void jj_la1_0() {
        int[] nArray = new int[17];
        nArray[0] = Integer.MIN_VALUE;
        nArray[2] = 0x2000000;
        nArray[4] = 0xC000000;
        nArray[5] = 0xC000000;
        nArray[6] = 0x4000000;
        nArray[7] = 0x8000000;
        nArray[8] = 0x2000040;
        nArray[9] = 0x4000000;
        nArray[10] = 0x8000000;
        nArray[11] = 0x2000040;
        nArray[12] = 0x4000000;
        nArray[13] = 0x8000000;
        nArray[14] = 0x2000040;
        nArray[15] = 0x10000000;
        nArray[16] = 0x2000040;
        jj_la1_0 = nArray;
    }

    private static void jj_la1_1() {
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 254;
        nArray[3] = 62;
        nArray[8] = 192;
        nArray[11] = 192;
        nArray[14] = 192;
        nArray[16] = 192;
        jj_la1_1 = nArray;
    }

    public DLSyntaxParser(InputStream stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public DLSyntaxParser(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new DLSyntaxParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public DLSyntaxParser(DLSyntaxParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(DLSyntaxParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 17) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[41];
        int i = 0;
        while (i < 41) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 17) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 41) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

