/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DuplicateSuperclassesPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.OWLAnonymousClassPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.OWLDeprecatedClassPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.RDFListPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.RDFPropertyPostProcessor;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.RDFSNamedClassPostProcessor;

public class TripleChangePostProcessor {
    public static void postProcess(OWLModel owlModel) {
        TripleStore activeTripleStore = owlModel.getTripleStoreModel().getActiveTripleStore();
        long startTime = System.currentTimeMillis();
        new RDFListPostProcessor(owlModel);
        TripleChangePostProcessor.log("Completed lists after " + (System.currentTimeMillis() - startTime) + " ms");
        startTime = System.currentTimeMillis();
        new OWLAnonymousClassPostProcessor(owlModel);
        TripleChangePostProcessor.log("Completed anonymous classes after " + (System.currentTimeMillis() - startTime) + " ms");
        startTime = System.currentTimeMillis();
        new OWLDeprecatedClassPostProcessor(owlModel);
        TripleChangePostProcessor.log("Completed deprecated classes after " + (System.currentTimeMillis() - startTime) + " ms");
        startTime = System.currentTimeMillis();
        new RDFPropertyPostProcessor(owlModel);
        TripleChangePostProcessor.log("Completed properties after " + (System.currentTimeMillis() - startTime) + " ms");
        startTime = System.currentTimeMillis();
        new RDFSNamedClassPostProcessor(owlModel);
        new DuplicateSuperclassesPostProcessor(owlModel);
        TripleChangePostProcessor.log("Completed named classes after " + (System.currentTimeMillis() - startTime) + " ms");
        owlModel.getTripleStoreModel().setActiveTripleStore(activeTripleStore);
    }

    private static void log(String str) {
        System.out.println("[TripleChangePostProcessor] " + str);
    }
}

