/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import edu.stanford.smi.protegex.owl.ui.search.FindUsage;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableItem;
import java.util.Collection;
import java.util.Collections;

public class FindUsageAsRangeTestCase
extends AbstractJenaTestCase {
    public void testFindAllValuesFrom() {
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLNamedClass hostCls = this.owlModel.createOWLNamedClass("Host");
        OWLNamedClass otherCls = this.owlModel.createOWLNamedClass("Other");
        OWLUnionClass unionCls = this.owlModel.createOWLUnionClass();
        unionCls.addOperand(this.owlModel.createOWLAllValuesFrom((RDFProperty)property, otherCls));
        unionCls.addOperand(this.owlModel.createOWLComplementClass(otherCls));
        hostCls.addSuperclass(unionCls);
        Collection items = FindUsage.getItems(otherCls);
        FindUsageAsRangeTestCase.assertSize(1, items);
        FindUsageTableItem item = (FindUsageTableItem)items.iterator().next();
        FindUsageAsRangeTestCase.assertEquals((Object)hostCls, (Object)item.host);
        FindUsageAsRangeTestCase.assertEquals((Object)unionCls, (Object)item.usage);
        FindUsageAsRangeTestCase.assertEquals((int)0, (int)item.type);
    }

    public void testFindDirectRange() {
        OWLNamedClass findCls = this.owlModel.createOWLNamedClass("Find");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        property.setUnionRangeClasses(Collections.singleton(findCls));
        Collection items = FindUsage.getItems(findCls);
        FindUsageAsRangeTestCase.assertSize(1, items);
        FindUsageTableItem item = (FindUsageTableItem)items.iterator().next();
        FindUsageAsRangeTestCase.assertEquals((Object)property, (Object)item.host);
        FindUsageAsRangeTestCase.assertEquals((Object)findCls, (Object)item.usage);
        FindUsageAsRangeTestCase.assertEquals((int)3, (int)item.type);
    }

    public void testFindNestedRange() {
        OWLNamedClass findCls = this.owlModel.createOWLNamedClass("Find");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(findCls);
        property.setUnionRangeClasses(Collections.singleton(complementCls));
        Collection items = FindUsage.getItems(findCls);
        FindUsageAsRangeTestCase.assertSize(1, items);
        FindUsageTableItem item = (FindUsageTableItem)items.iterator().next();
        FindUsageAsRangeTestCase.assertEquals((Object)property, (Object)item.host);
        FindUsageAsRangeTestCase.assertEquals((Object)complementCls, (Object)item.usage);
        FindUsageAsRangeTestCase.assertEquals((int)3, (int)item.type);
    }
}

