/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.ontology.tidy.impl.CategorySet;
import com.hp.hpl.jena.ontology.tidy.impl.Constants;
import com.hp.hpl.jena.ontology.tidy.impl.Grammar;
import com.hp.hpl.jena.ontology.tidy.impl.LookupTable;
import com.hp.hpl.jena.ontology.tidy.impl.Q;
import java.util.Arrays;

class MonontonicErrorAnalyzer
implements Constants {
    static final int TYPE_FOR_BUILTIN = 184;
    static final int TYPE_OF_PROPERTY_ONLY_ID = 183;
    static final int TYPE_OF_CLASS_ONLY_ID = 182;
    static final int BAD_RANGE_LIST_DESC = 140;
    static final int BAD_RANGE_GENERAL_CLASS = 141;
    static final int BAD_RANGE_HAS_VALUE = 142;
    static final int BAD_RANGE_CARDINALITY = 143;
    static final int BAD_RANGE_INDIVIDUAL = 144;
    static final int BAD_RANGE_LIST = 145;
    static final int BAD_RANGE_FIRST = 146;
    static final int BAD_RANGE_PROP = 147;
    static final int BAD_RANGE_LIST_IND = 148;
    static final int BAD_RANGE_ONEOF = 149;
    static final int BAD_RANGE_CLASS_DATATYPE = 150;
    static final int BAD_RANGE_TYPE = 151;
    static final int BAD_RANGE_ONT_PROP = 152;
    static final int BAD_DOMAIN_REST = 160;
    static final int BAD_DOMAIN_ALL_DIFF = 161;
    static final int BAD_DOMAIN_INDIVIDUAL = 162;
    static final int BAD_DOMAIN_LIST = 163;
    static final int BAD_DOMAIN_PROP = 164;
    static final int BAD_DOMAIN_CLASS_DESC = 165;
    static final int BAD_DOMAIN_GENERAL_CLASS = 166;
    static final int BAD_DOMAIN_CLASS = 167;
    static final int BAD_DOMAIN_TYPE = 168;
    static final int BAD_DOMAIN_ONT_PROP = 169;
    static final int GENERIC = 100;
    static final int SINGLE_TRIPLE = 101;
    static final int DIFFICULT = 110;
    static final int OBJ_PROP_AND_LIT = 111;
    static final int DATA_PROP_AND_NONLIT = 112;
    static final int NOT_ANNO_ON_NON_INDIV = 113;
    static final int GENERIC_OBJPROP = 114;
    static final int OBJPROP_WITH_NON_INDIV_BLANK_OBJ = 115;
    static final int OBJPROP_WITH_NON_INDIV_ID_OBJ = 116;
    static final int NOT_ANNO_WITH_SUBJ_NON_INDIV = 117;
    static final int ONTPROP_BAD_SUBJ = 118;
    static final int ONTPROP_BLANK_OBJ = 119;
    static final int ONTPROP_BAD_OBJ = 120;
    static final int BLANK_PROP = 130;
    static final int LITERAL_PROP = 131;
    static final int LITERAL_SUBJ = 132;
    static final int BADID_USE = 133;
    static final int BUILTIN_NON_PRED = 134;
    static final int BUILTIN_NON_SUBJ = 135;
    static final int CLASS_AS_PROP = 136;
    static final int DATA_ANN_PROP_BAD_OBJ = 137;
    static final int TYPE_NEEDS_ID = 180;
    static final int TYPE_NEEDS_BLANK = 181;
    static LookupTable look = (LookupTable)LookupTable.get();
    static final int SZ = CategorySet.unsorted.size();
    static final boolean[] isClassOnly = new boolean[SZ];
    static final boolean[] isPropertyOnly = new boolean[SZ];
    static final boolean[] isUserID = new boolean[SZ];
    static final boolean[] isBlank = new boolean[SZ];
    static final boolean[] isBuiltin = new boolean[SZ];
    static final int[][] start = new int[SZ][];
    static int[] miss;
    static int ontp2;
    static int class2;
    static int dp1;
    static int dp2;
    static int op1;
    static int op2;
    static int op3;
    static int op4;
    static int op5;
    static int op6;
    static final int[] indv;
    static final int[] annOrOnt;
    static final int[] ontos;
    static final int[] owlProps;
    static int dbgCnt;
    static int ont2;
    static int bad;
    static int[] eCnt;

    MonontonicErrorAnalyzer() {
    }

    static int getErrorCode(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = look.qrefine(n4, n5, n6);
        if (n7 == -1) {
            return MonontonicErrorAnalyzer.singleTripleError(n4, n5, n6);
        }
        int n8 = 0;
        int n9 = look.subject(n4, n7);
        int n10 = look.prop(n5, n7);
        int n11 = look.object(n6, n7);
        int n12 = 0;
        if (look.meet(n9, n) == -1) {
            n8 |= 1;
            n12 = MonontonicErrorAnalyzer.catMiss(n9, n);
        }
        if (look.meet(n10, n2) == -1) {
            n8 |= 2;
            n12 = MonontonicErrorAnalyzer.catMiss(n10, n2);
        }
        if (look.meet(n11, n3) == -1) {
            n8 |= 4;
            n12 = MonontonicErrorAnalyzer.catMiss(n11, n3);
        }
        int n13 = n8;
        miss[n13] = miss[n13] + 1;
        if (n8 == 0) {
            return MonontonicErrorAnalyzer.difficultCase(n, n2, n3, n9, n10, n11);
        }
        return n12;
    }

    private static int difficultCase(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 110;
        if (MonontonicErrorAnalyzer.isNotAnnOrOntoProp(n2) && MonontonicErrorAnalyzer.isNotIndividual(n)) {
            return 113;
        }
        if (MonontonicErrorAnalyzer.isNotAnnOrOntoProp(n2) && isUserID[n3] && MonontonicErrorAnalyzer.isNotIndividual(n3)) {
            return 117;
        }
        if (MonontonicErrorAnalyzer.isOntologyProp(n2) && MonontonicErrorAnalyzer.isNotOntology(n)) {
            return 118;
        }
        if (MonontonicErrorAnalyzer.isOntologyProp(n2) && isBlank[n3]) {
            return 119;
        }
        if (MonontonicErrorAnalyzer.isOntologyProp(n2) && MonontonicErrorAnalyzer.isNotOntology(n3)) {
            return 120;
        }
        if (MonontonicErrorAnalyzer.isObjectProperty(n2) && MonontonicErrorAnalyzer.isNotIndividual(n3)) {
            if (isUserID[n3]) {
                return 116;
            }
            n7 = 110;
        }
        if (MonontonicErrorAnalyzer.debug()) {
            MonontonicErrorAnalyzer.dumpc("DC-subj", n, n4);
            MonontonicErrorAnalyzer.dumpc("DC-prop", n2, n5);
            MonontonicErrorAnalyzer.dumpc("DC-obj", n3, n6);
        }
        return n7;
    }

    private static boolean isNotOntology(int n) {
        int[] nArray = CategorySet.getSet(n);
        return !Q.intersect(ontos, nArray);
    }

    private static boolean isOntologyProp(int n) {
        return n == 19 || n == ontp2;
    }

    private static boolean isClassID(int n) {
        return n == 8 || n == class2;
    }

    private static boolean isDataProp(int n) {
        return n == dp1 || n == dp2;
    }

    private static boolean isObjectProperty(int n) {
        return n == op1 || n == op2 || n == op3 || n == op4 || n == op5 || n == op6;
    }

    private static boolean isLiteral(int n) {
        return n == 16 || n == 15 || n == 13 || n == 23;
    }

    private static boolean isNotLiteral(int n) {
        return !MonontonicErrorAnalyzer.isLiteral(n);
    }

    private static boolean isNotIndividual(int n) {
        int[] nArray = CategorySet.getSet(n);
        return !Q.intersect(indv, nArray);
    }

    private static boolean isNotAnnOrOntoProp(int n) {
        int[] nArray = CategorySet.getSet(n);
        return !Q.intersect(annOrOnt, nArray);
    }

    static boolean debug() {
        return dbgCnt++ % 5 == 0 && dbgCnt < 100;
    }

    static void dumpc(String string, int n, int n2) {
        System.out.println(string + "(a)" + CategorySet.catString(n));
        if (n2 != 0) {
            System.out.println(string + "(b)" + CategorySet.catString(n2));
        }
    }

    private static int badBuiltinRange(int n, int n2) {
        switch (n) {
            case 73: 
            case 84: {
                return MonontonicErrorAnalyzer.isNotClassID(n2) && MonontonicErrorAnalyzer.isNotDatatypeID(n2) && n2 != 11 ? 150 : 0;
            }
            case 60: 
            case 62: 
            case 64: 
            case 83: 
            case 85: {
                return MonontonicErrorAnalyzer.isNotDescription(n2) && MonontonicErrorAnalyzer.isNotClassID(n2) && MonontonicErrorAnalyzer.isNotRestriction(n2) ? 141 : 0;
            }
            case 67: 
            case 74: {
                return MonontonicErrorAnalyzer.isNotListOfDesc(n2) ? 140 : 0;
            }
            case 71: {
                return MonontonicErrorAnalyzer.isNotListOfLit(n2) && MonontonicErrorAnalyzer.isNotListOfIndividual(n2) ? 149 : 0;
            }
            case 63: {
                return MonontonicErrorAnalyzer.isNotListOfIndividual(n2) ? 148 : 0;
            }
            case 65: 
            case 68: 
            case 70: 
            case 86: {
                return MonontonicErrorAnalyzer.isNotOWLPropertyID(n2) ? 147 : 0;
            }
            case 77: {
                return MonontonicErrorAnalyzer.isNotIndividualID(n2) && MonontonicErrorAnalyzer.isNotDescription(n2) && MonontonicErrorAnalyzer.isNotClassID(n2) && MonontonicErrorAnalyzer.isNotRestriction(n2) ? 146 : 0;
            }
            case 79: {
                return MonontonicErrorAnalyzer.isNotListNode(n2) && n2 != 78 ? 145 : 0;
            }
            case 61: 
            case 72: {
                return MonontonicErrorAnalyzer.isNotIndividualID(n2) ? 144 : 0;
            }
            case 69: {
                return n2 != 15 && n2 != 13 ? 143 : 0;
            }
            case 66: {
                return MonontonicErrorAnalyzer.isNotIndividualID(n2) && MonontonicErrorAnalyzer.isNotLiteral(n2) ? 142 : 0;
            }
            case 80: {
                switch (n2) {
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 75: 
                    case 76: 
                    case 81: 
                    case 82: {
                        return 0;
                    }
                }
                return MonontonicErrorAnalyzer.isNotDescription(n2) && MonontonicErrorAnalyzer.isNotClassID(n2) && MonontonicErrorAnalyzer.isNotRestriction(n2) ? 151 : 0;
            }
        }
        if (MonontonicErrorAnalyzer.isOntologyProp(n)) {
            return MonontonicErrorAnalyzer.isOntologyID(n2) ? 0 : 152;
        }
        return 0;
    }

    private static boolean isNotListOfIndividual(int n) {
        return !Q.member(31, CategorySet.getSet(n));
    }

    private static boolean isNotListOfLit(int n) {
        return !Q.member(29, CategorySet.getSet(n));
    }

    private static boolean isNotListOfDesc(int n) {
        return !Q.member(30, CategorySet.getSet(n));
    }

    private static boolean isNotDatatypeID(int n) {
        return !Q.member(12, CategorySet.getSet(n));
    }

    private static int badBuiltinDomain(int n, int n2) {
        switch (n) {
            case 62: 
            case 64: 
            case 85: {
                return MonontonicErrorAnalyzer.isNotDescription(n2) && MonontonicErrorAnalyzer.isNotClassID(n2) && MonontonicErrorAnalyzer.isNotRestriction(n2) ? 166 : 0;
            }
            case 60: 
            case 67: 
            case 71: 
            case 74: {
                return MonontonicErrorAnalyzer.isNotDescription(n2) && MonontonicErrorAnalyzer.isNotClassID(n2) ? 165 : 0;
            }
            case 80: {
                return isUserID[n2] || isBlank[n2] ? 0 : 168;
            }
            case 65: 
            case 68: 
            case 83: 
            case 84: 
            case 86: {
                return MonontonicErrorAnalyzer.isNotOWLPropertyID(n2) ? 164 : 0;
            }
            case 77: 
            case 79: {
                return MonontonicErrorAnalyzer.isNotListNode(n2) ? 163 : 0;
            }
            case 61: 
            case 72: {
                return MonontonicErrorAnalyzer.isNotIndividualID(n2) ? 162 : 0;
            }
            case 63: {
                return MonontonicErrorAnalyzer.isNotAllDifferent(n2) ? 161 : 0;
            }
            case 66: 
            case 69: 
            case 70: 
            case 73: {
                return MonontonicErrorAnalyzer.isNotRestriction(n2) ? 160 : 0;
            }
        }
        if (MonontonicErrorAnalyzer.isOntologyProp(n)) {
            return isBlank[n2] || MonontonicErrorAnalyzer.isOntologyID(n2) ? 0 : 169;
        }
        return 0;
    }

    private static boolean isOntologyID(int n) {
        return n == 18 || n == ont2;
    }

    private static boolean isNotRestriction(int n) {
        return look.meet(n, Grammar.restrictions) == -1;
    }

    private static boolean isNotAllDifferent(int n) {
        return !Q.member(24, CategorySet.getSet(n));
    }

    private static boolean isNotIndividualID(int n) {
        return !Q.member(14, CategorySet.getSet(n));
    }

    private static boolean isNotListNode(int n) {
        return look.meet(n, Grammar.lists) == -1;
    }

    private static boolean isNotOWLPropertyID(int n) {
        return !Q.intersect(owlProps, CategorySet.getSet(n));
    }

    private static boolean isNotDescription(int n) {
        return look.meet(n, Grammar.descriptions) == -1;
    }

    private static boolean isNotClassID(int n) {
        return !Q.member(8, CategorySet.getSet(n));
    }

    private static int singleTripleError(int n, int n2, int n3) {
        if (isBlank[n2]) {
            return 130;
        }
        if (MonontonicErrorAnalyzer.isLiteral(n2)) {
            return 131;
        }
        if (MonontonicErrorAnalyzer.isLiteral(n)) {
            return 132;
        }
        if (n == 7 || n2 == 7) {
            return 133;
        }
        if (n3 == 7) {
            return 133;
        }
        if (isBuiltin[n] && !look.canBeSubj(n)) {
            return 135;
        }
        if (!look.canBeProp(n2)) {
            return 134;
        }
        if (MonontonicErrorAnalyzer.isClassID(n2)) {
            return 136;
        }
        if (n2 == 9 && MonontonicErrorAnalyzer.isNotLiteral(n3)) {
            return 137;
        }
        int n4 = MonontonicErrorAnalyzer.badBuiltinDomain(n2, n);
        if (n4 != 0) {
            return n4;
        }
        n4 = MonontonicErrorAnalyzer.badBuiltinRange(n2, n3);
        if (n4 != 0) {
            return n4;
        }
        if (n2 == 80) {
            if (MonontonicErrorAnalyzer.maybeBuiltinID(n)) {
                return 184;
            }
            switch (n3) {
                case 46: 
                case 49: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 58: 
                case 59: 
                case 76: 
                case 82: {
                    if (MonontonicErrorAnalyzer.isClassOnly(n)) {
                        return 182;
                    }
                }
                case 50: {
                    if (!isUserID[n] && n3 != 55) {
                        return 180;
                    }
                }
                case 45: 
                case 48: 
                case 57: 
                case 75: {
                    if (isBlank[n]) break;
                    return 181;
                }
            }
            if (isBlank[n3] || MonontonicErrorAnalyzer.isClassOnly(n3)) {
                if (MonontonicErrorAnalyzer.isClassOnly(n)) {
                    return 182;
                }
                if (MonontonicErrorAnalyzer.isPropertyOnly(n)) {
                    return 183;
                }
            }
            if (MonontonicErrorAnalyzer.isClassOnly(n) && isUserID[n3]) {
                return 182;
            }
            if (MonontonicErrorAnalyzer.isPropertyOnly(n)) {
                switch (n3) {
                    case 47: 
                    case 50: 
                    case 55: 
                    case 81: 
                    case 82: {
                        return 183;
                    }
                }
                if (isUserID[n3]) {
                    return 183;
                }
            }
        }
        if (MonontonicErrorAnalyzer.debug()) {
            MonontonicErrorAnalyzer.dumpc("DC-subj", n, 0);
            MonontonicErrorAnalyzer.dumpc("DC-prop", n2, 0);
            MonontonicErrorAnalyzer.dumpc("DC-obj", n3, 0);
        }
        if (MonontonicErrorAnalyzer.isObjectProperty(n2) && MonontonicErrorAnalyzer.isLiteral(n3)) {
            return 111;
        }
        if (MonontonicErrorAnalyzer.isDataProp(n2) && MonontonicErrorAnalyzer.isNotLiteral(n3)) {
            return 112;
        }
        return 101;
    }

    private static boolean maybeBuiltinID(int n) {
        boolean bl;
        switch (n) {
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static boolean isClassOnly(int n) {
        return look.meet(n, Grammar.classOnly) == n;
    }

    private static boolean isPropertyOnly(int n) {
        return look.meet(n, Grammar.propertyOnly) == n;
    }

    private static int catMiss(int n, int n2) {
        return 100;
    }

    static void allCases(int n, int n2, int n3) {
        for (int i = 0; i < start[n].length; ++i) {
            for (int j = 0; j < start[n2].length; ++j) {
                for (int k = 0; k < start[n3].length; ++k) {
                    int n4;
                    ++bad;
                    int n5 = n4 = MonontonicErrorAnalyzer.getErrorCode(n, n2, n3, start[n][i], start[n2][j], start[n3][k]);
                    eCnt[n5] = eCnt[n5] + 1;
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 1; i < SZ; ++i) {
            if (Grammar.isPseudoCategory(i) || isBlank[i] || MonontonicErrorAnalyzer.isLiteral(i)) continue;
            for (int j = 1; j < SZ; ++j) {
                if (Grammar.isPseudoCategory(j) || MonontonicErrorAnalyzer.isLiteral(j)) continue;
                for (int k = 1; k < SZ; ++k) {
                    if (Grammar.isPseudoCategory(k) || look.qrefine(j, i, k) != -1) continue;
                    MonontonicErrorAnalyzer.allCases(j, i, k);
                }
            }
        }
        System.out.println(bad + " cases considered.");
        MonontonicErrorAnalyzer.dump("Codes:", eCnt);
        MonontonicErrorAnalyzer.dump("Misses", miss);
    }

    static void dump(String string, int[] nArray) {
        System.out.println(string);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) continue;
            System.out.println(i + "\t" + nArray[i]);
        }
    }

    static {
        int n = 0;
        int[] nArray = new int[4];
        for (int i = 1; i < SZ; ++i) {
            if (Grammar.isPseudoCategory(i)) continue;
            n = 0;
            if (look.meet(i, Grammar.classOnly) == i) {
                MonontonicErrorAnalyzer.isClassOnly[i] = true;
                nArray[n++] = Grammar.classOnly;
            }
            if (look.meet(i, Grammar.propertyOnly) == i) {
                MonontonicErrorAnalyzer.isPropertyOnly[i] = true;
                nArray[n++] = Grammar.propertyOnly;
            }
            if (look.meet(i, Grammar.userID) == i) {
                MonontonicErrorAnalyzer.isUserID[i] = true;
                nArray[n++] = Grammar.userID;
            }
            if (look.meet(i, Grammar.blank) == i) {
                MonontonicErrorAnalyzer.isBlank[i] = true;
                nArray[n++] = Grammar.blank;
            }
            if (n == 0) {
                nArray[n++] = i;
                switch (i) {
                    case 7: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 23: {
                        break;
                    }
                    default: {
                        System.err.println("Builtin: " + Grammar.catNames[i]);
                        MonontonicErrorAnalyzer.isBuiltin[i] = true;
                    }
                }
            }
            if (MonontonicErrorAnalyzer.maybeBuiltinID(i)) {
                nArray[n++] = i;
            }
            MonontonicErrorAnalyzer.start[i] = new int[n];
            System.arraycopy(nArray, 0, start[i], 0, n);
        }
        miss = new int[8];
        ontp2 = CategorySet.find(new int[]{2, 19}, false);
        class2 = CategorySet.find(new int[]{2, 8}, false);
        dp1 = 10;
        dp2 = CategorySet.find(new int[]{2, 10}, false);
        op1 = 17;
        op2 = 20;
        op3 = CategorySet.find(new int[]{2, 17}, false);
        op4 = CategorySet.find(new int[]{2, 20}, false);
        op5 = CategorySet.find(new int[]{17, 20}, false);
        op6 = CategorySet.find(new int[]{17, 2, 20}, false);
        indv = new int[]{21, 14};
        annOrOnt = new int[]{6, 9, 19};
        ontos = new int[]{18, 22};
        owlProps = new int[]{20, 17, 10};
        Arrays.sort(annOrOnt);
        Arrays.sort(indv);
        Arrays.sort(ontos);
        Arrays.sort(owlProps);
        dbgCnt = 0;
        ont2 = CategorySet.find(new int[]{2, 18}, false);
        bad = 0;
        eCnt = new int[1000];
    }
}

