/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.test;

import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntologyException;
import com.hp.hpl.jena.ontology.tidy.SyntaxProblem;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.OWL;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;

public class TestOntModel
extends ModelTestBase {
    public static final String BASE = "http://www.hp.com/test";
    public static final String NS = "http://www.hp.com/test#";

    public TestOntModel(String string) {
        super(string);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void test_rng_01() {
        String string = "<?xml version='1.0'?><!DOCTYPE owl [      <!ENTITY rdf  'http://www.w3.org/1999/02/22-rdf-syntax-ns#' >      <!ENTITY rdfs 'http://www.w3.org/2000/01/rdf-schema#' >      <!ENTITY xsd  'http://www.w3.org/2001/XMLSchema#' >      <!ENTITY owl  'http://www.w3.org/2002/07/owl#' >      <!ENTITY dc   'http://purl.org/dc/elements/1.1/' >      <!ENTITY base  'http://jena.hpl.hp.com/test' >    ]><rdf:RDF xmlns:owl ='&owl;' xmlns:rdf='&rdf;' xmlns:rdfs='&rdfs;' xmlns:dc='&dc;' xmlns='&base;#' xml:base='&base;'>         <owl:Ontology rdf:about='urn:someURN:'>                  <owl:imports>                   <owl:Ontology rdf:about='urn:ALegalURN:' />                 </owl:imports>         </owl:Ontology></rdf:RDF>";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        ontModel.getDocumentManager().addAltEntry("urn:ALegalURN:", "file:testing/ontology/bugs/test_hk_07B.owl");
        ontModel.getDocumentManager().setProcessImports(false);
        ontModel.read((Reader)new StringReader(string), null);
        ArrayList arrayList = new ArrayList();
        Resource resource = ontModel.getOWLLanguageLevel(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            SyntaxProblem syntaxProblem = (SyntaxProblem)iterator.next();
        }
    }

    public void testChecker1() {
        String string = "http://example.org/test#";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM, null);
        ontModel.createClass(string + "A");
        ArrayList arrayList = new ArrayList();
        TestOntModel.assertEquals((String)"Should be owl lite", (Object)OWL.LITE_LANG, (Object)ontModel.getOWLLanguageLevel(null));
        TestOntModel.assertEquals((String)"Should be owl lite", (Object)OWL.LITE_LANG, (Object)ontModel.getOWLLanguageLevel(arrayList));
        TestOntModel.assertTrue((String)"should be no problems", (boolean)arrayList.isEmpty());
    }

    public void testChecker2() {
        String string = "http://example.org/test#";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, null);
        ontModel.createClass(string + "A");
        ArrayList arrayList = new ArrayList();
        TestOntModel.assertEquals((String)"Should be owl lite", (Object)OWL.LITE_LANG, (Object)ontModel.getOWLLanguageLevel(null));
        TestOntModel.assertEquals((String)"Should be owl lite", (Object)OWL.LITE_LANG, (Object)ontModel.getOWLLanguageLevel(arrayList));
        TestOntModel.assertTrue((String)"should be no problems", (boolean)arrayList.isEmpty());
    }

    public void testChecker3() {
        String string = "http://example.org/test#";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM, null);
        ontModel.read("file:testing/ontology/test-boolean.rdf");
        ArrayList arrayList = new ArrayList();
        TestOntModel.assertEquals((String)"Should be owl DL", (Object)OWL.DL_LANG, (Object)ontModel.getOWLLanguageLevel(arrayList));
        TestOntModel.assertTrue((String)"should be some problems", (!arrayList.isEmpty() ? 1 : 0) != 0);
    }

    public void testChecker4() {
        String string = "http://example.org/test#";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, null);
        ontModel.read("file:testing/ontology/test-boolean.rdf");
        ArrayList arrayList = new ArrayList();
        TestOntModel.assertEquals((String)"Should be owl DL", (Object)OWL.DL_LANG, (Object)ontModel.getOWLLanguageLevel(null));
        TestOntModel.assertEquals((String)"Should be owl DL", (Object)OWL.DL_LANG, (Object)ontModel.getOWLLanguageLevel(arrayList));
        TestOntModel.assertTrue((String)"should be no problems", (boolean)arrayList.isEmpty());
    }

    public void testChecker5() {
        String string = "http://example.org/test#";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_LITE_MEM, null);
        OntClass ontClass = ontModel.createClass(string + "A");
        ObjectProperty objectProperty = ontModel.createObjectProperty(string + "p");
        Resource resource = ontModel.createResource(string + "B");
        ontModel.createAllValuesFromRestriction(null, (Property)objectProperty, resource);
        ArrayList arrayList = new ArrayList();
        TestOntModel.assertEquals((String)"Should be owl Full", (Object)OWL.FULL_LANG, (Object)ontModel.getOWLLanguageLevel(null));
        TestOntModel.assertEquals((String)"Should be owl Full", (Object)OWL.FULL_LANG, (Object)ontModel.getOWLLanguageLevel(arrayList));
        TestOntModel.assertTrue((String)"should be problems", (!arrayList.isEmpty() ? 1 : 0) != 0);
    }

    public void testChecker6() {
        String string = "http://example.org/test#";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_DL_MEM, null);
        OntClass ontClass = ontModel.createClass(string + "A");
        ObjectProperty objectProperty = ontModel.createObjectProperty(string + "p");
        Resource resource = ontModel.createResource(string + "B");
        ontModel.createAllValuesFromRestriction(null, (Property)objectProperty, resource);
        ArrayList arrayList = new ArrayList();
        TestOntModel.assertEquals((String)"Should be owl Full", (Object)OWL.FULL_LANG, (Object)ontModel.getOWLLanguageLevel(null));
        TestOntModel.assertEquals((String)"Should be owl Full", (Object)OWL.FULL_LANG, (Object)ontModel.getOWLLanguageLevel(arrayList));
        TestOntModel.assertTrue((String)"should be problems", (!arrayList.isEmpty() ? 1 : 0) != 0);
    }

    public void testChecker7() {
        String string = "http://example.org/test#";
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM, null);
        OntClass ontClass = ontModel.createClass(string + "A");
        ObjectProperty objectProperty = ontModel.createObjectProperty(string + "p");
        Resource resource = ontModel.createResource(string + "B");
        ontModel.createAllValuesFromRestriction(null, (Property)objectProperty, resource);
        ArrayList arrayList = new ArrayList();
        TestOntModel.assertEquals((String)"Should be owl Full", (Object)OWL.FULL_LANG, (Object)ontModel.getOWLLanguageLevel(null));
        TestOntModel.assertEquals((String)"Should be owl Full", (Object)OWL.FULL_LANG, (Object)ontModel.getOWLLanguageLevel(arrayList));
        TestOntModel.assertTrue((String)"should be problems", (!arrayList.isEmpty() ? 1 : 0) != 0);
    }

    public void testChecker8() {
        boolean bl = false;
        OntModel ontModel = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.DAML_MEM, null);
        try {
            ontModel.getOWLLanguageLevel(null);
        }
        catch (OntologyException ontologyException) {
            bl = true;
        }
        TestOntModel.assertTrue((String)"Should have raised exception to get owl lang level on non-owl model", (boolean)bl);
    }
}

