/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.graph.tests;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protegex.owl.jena.graph.ProtegeGraph;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class ProtegeGraphTestCase
extends AbstractJenaTestCase {
    public void testContainsWithSubjectPredicateObjectLiteral() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        c.addPropertyValue(this.owlModel.getOWLVersionInfoProperty(), "Test");
        ProtegeGraph graph = new ProtegeGraph(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore());
        ProtegeGraphTestCase.assertTrue((boolean)graph.contains(Node.createURI((String)c.getURI()), OWL.versionInfo.getNode(), Node.createLiteral((String)"Test", null, (RDFDatatype)XMLSchemaDatatypes.getRDFDatatype(this.owlModel.getXSDstring()))));
    }

    public void testContainsWithSubjectPredicateObjectResource() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        ProtegeGraph graph = new ProtegeGraph(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore());
        ProtegeGraphTestCase.assertTrue((boolean)graph.contains(Node.createURI((String)c.getURI()), RDF.type.getNode(), OWL.Class.getNode()));
    }

    public void testFindAllOnEmptyModel() {
        ProtegeGraph graph = new ProtegeGraph(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore());
        ExtendedIterator it = graph.find(null, null, null);
        ProtegeGraphTestCase.assertTrue((boolean)it.hasNext());
        Triple triple = (Triple)it.next();
        ProtegeGraphTestCase.assertEquals((String)this.owlModel.getDefaultOWLOntology().getURI(), (String)triple.getSubject().getURI());
        ProtegeGraphTestCase.assertEquals((String)RDF.type.getURI(), (String)triple.getPredicate().getURI());
        ProtegeGraphTestCase.assertEquals((String)OWL.Ontology.getURI(), (String)triple.getObject().getURI());
        ProtegeGraphTestCase.assertFalse((boolean)it.hasNext());
    }

    public void testFindWithObjectOnly() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        ProtegeGraph graph = new ProtegeGraph(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore());
        ExtendedIterator it = graph.find(null, null, OWL.Class.getNode());
        ProtegeGraphTestCase.assertTrue((boolean)it.hasNext());
        Triple triple = (Triple)it.next();
        ProtegeGraphTestCase.assertEquals((String)c.getURI(), (String)triple.getSubject().getURI());
        ProtegeGraphTestCase.assertEquals((String)RDF.type.getURI(), (String)triple.getPredicate().getURI());
        ProtegeGraphTestCase.assertEquals((String)OWL.Class.getURI(), (String)triple.getObject().getURI());
    }

    public void testFindWithPredicateOnly() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        ProtegeGraph graph = new ProtegeGraph(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore());
        ExtendedIterator it = graph.find(null, RDF.type.getNode(), null);
        ProtegeGraphTestCase.assertTrue((boolean)it.hasNext());
        Triple triple = (Triple)it.next();
        ProtegeGraphTestCase.assertEquals((String)c.getURI(), (String)triple.getSubject().getURI());
        ProtegeGraphTestCase.assertEquals((String)RDF.type.getURI(), (String)triple.getPredicate().getURI());
        ProtegeGraphTestCase.assertEquals((String)OWL.Class.getURI(), (String)triple.getObject().getURI());
    }

    public void testFindWithSubjectOnly() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        ProtegeGraph graph = new ProtegeGraph(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore());
        ExtendedIterator it = graph.find(Node.createURI((String)c.getURI()), null, null);
        ProtegeGraphTestCase.assertTrue((boolean)it.hasNext());
        Triple typeTriple = (Triple)it.next();
        ProtegeGraphTestCase.assertTrue((boolean)it.hasNext());
        Triple subclassTriple = (Triple)it.next();
        ProtegeGraphTestCase.assertFalse((boolean)it.hasNext());
        if (RDF.type.getURI().equals(subclassTriple.getPredicate().getURI())) {
            Triple ring = typeTriple;
            typeTriple = subclassTriple;
            subclassTriple = ring;
        }
        ProtegeGraphTestCase.assertEquals((String)c.getURI(), (String)typeTriple.getSubject().getURI());
        ProtegeGraphTestCase.assertEquals((String)RDF.type.getURI(), (String)typeTriple.getPredicate().getURI());
        ProtegeGraphTestCase.assertEquals((String)OWL.Class.getURI(), (String)typeTriple.getObject().getURI());
        ProtegeGraphTestCase.assertEquals((String)c.getURI(), (String)subclassTriple.getSubject().getURI());
        ProtegeGraphTestCase.assertEquals((String)RDFS.subClassOf.getURI(), (String)subclassTriple.getPredicate().getURI());
        ProtegeGraphTestCase.assertEquals((String)OWL.Thing.getURI(), (String)subclassTriple.getObject().getURI());
        ProtegeGraphTestCase.assertEquals((int)3, (int)graph.size());
    }

    public void testFindWithSubjectPredicate() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        ProtegeGraph graph = new ProtegeGraph(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore());
        ExtendedIterator it = graph.find(Node.createURI((String)c.getURI()), RDF.type.getNode(), null);
        ProtegeGraphTestCase.assertTrue((boolean)it.hasNext());
        Triple triple = (Triple)it.next();
        ProtegeGraphTestCase.assertFalse((boolean)it.hasNext());
        ProtegeGraphTestCase.assertEquals((String)c.getURI(), (String)triple.getSubject().getURI());
        ProtegeGraphTestCase.assertEquals((String)RDF.type.getURI(), (String)triple.getPredicate().getURI());
        ProtegeGraphTestCase.assertEquals((String)OWL.Class.getURI(), (String)triple.getObject().getURI());
    }

    public void testFindAnonymousClass() {
        OWLNamedClass c = this.owlModel.createOWLNamedClass("Class");
        OWLObjectProperty property = this.owlModel.createOWLObjectProperty("property");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(property, 1);
        c.addSuperclass(restriction);
        ProtegeGraph graph = new ProtegeGraph(this.owlModel, this.owlModel.getTripleStoreModel().getActiveTripleStore());
        ExtendedIterator it = graph.find(null, OWL.minCardinality.getNode(), null);
        ProtegeGraphTestCase.assertTrue((boolean)it.hasNext());
        Triple triple = (Triple)it.next();
        ProtegeGraphTestCase.assertFalse((boolean)it.hasNext());
        ProtegeGraphTestCase.assertTrue((boolean)triple.getSubject().isBlank());
        ProtegeGraphTestCase.assertEquals((String)restriction.getName(), (String)triple.getSubject().getBlankNodeId().toString());
    }
}

