/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classdisplay;

import edu.stanford.smi.protege.plugin.PluginUtilities;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.classdisplay.OWLClassDisplay;
import edu.stanford.smi.protegex.owl.model.classdisplay.manchester.ManchesterOWLClassDisplay;
import java.util.logging.Level;

public class OWLClassDisplayFactory {
    public static final String APPLICATION_PROPERTY = "OWLClassDisplayFactory.default";
    private static OWLClassDisplay defaultDisplay;
    public static final String KEY = "OWLClassDisplay";

    public static Class[] getAvailableDisplayClasses() {
        return PluginUtilities.getClassesWithAttribute((String)KEY, (String)"true").toArray(new Class[0]);
    }

    public static OWLClassDisplay getDefaultDisplay() {
        if (defaultDisplay == null) {
            String className = ApplicationProperties.getString((String)APPLICATION_PROPERTY);
            if (className != null) {
                try {
                    Class<?> c = Class.forName(className);
                    defaultDisplay = OWLClassDisplayFactory.getDisplay(c);
                }
                catch (Exception ex) {
                    Log.getLogger().log(Level.WARNING, "Could not create OWLClassDisplay of type " + className);
                    defaultDisplay = new ManchesterOWLClassDisplay();
                }
            } else {
                defaultDisplay = new ManchesterOWLClassDisplay();
            }
        }
        return defaultDisplay;
    }

    public static OWLClassDisplay getDisplay(Class type) {
        try {
            return (OWLClassDisplay)type.newInstance();
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    public static void setDefaultDisplay(OWLClassDisplay renderer) {
        defaultDisplay = renderer;
        ApplicationProperties.setString((String)APPLICATION_PROPERTY, (String)renderer.getClass().getName());
    }
}

