/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classdisplay.dl;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNAryLogicalClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import edu.stanford.smi.protegex.owl.model.visitor.Visitable;
import java.util.Iterator;
import java.util.Stack;

public class DLSyntaxBrowserTextGenerator
implements OWLModelVisitor {
    private StringBuffer buffer = new StringBuffer();
    private Stack<Visitable> resourceStack = new Stack();

    public String getBrowserText() {
        return this.buffer.toString();
    }

    public void reset() {
        this.buffer = new StringBuffer();
    }

    protected StringBuffer getCurrentBuffer() {
        return this.buffer;
    }

    protected void write(String s) {
        this.getCurrentBuffer().append(s);
    }

    protected void write(char c) {
        this.getCurrentBuffer().append(c);
    }

    protected void writeSpace() {
        this.getCurrentBuffer().append(" ");
    }

    protected void writeOpenPar() {
        if (this.resourceStack.size() > 1) {
            this.getCurrentBuffer().append("(");
        }
    }

    protected void writeClosePar() {
        if (this.resourceStack.size() > 1) {
            this.getCurrentBuffer().append(")");
        }
    }

    public void visitOWLAllDifferent(OWLAllDifferent owlAllDifferent) {
    }

    private void push(RDFSClass v) {
        this.resourceStack.push(v);
    }

    private void pop() {
        this.resourceStack.pop();
    }

    protected void writeCardinality(OWLCardinalityBase cardinalityBase) {
        this.writeOpenPar();
        this.write(cardinalityBase.getOperator());
        this.writeSpace();
        this.write(String.valueOf(cardinalityBase.getCardinality()));
        this.writeSpace();
        if (cardinalityBase.getOnProperty() != null) {
            cardinalityBase.getOnProperty().accept(this);
        }
        if (cardinalityBase.getQualifier() != null) {
            this.writeSpace();
            cardinalityBase.getQualifier().accept(this);
        }
        this.writeClosePar();
    }

    protected void writeQuantifier(OWLQuantifierRestriction quantifierRestriction) {
        this.writeOpenPar();
        this.write(quantifierRestriction.getOperator());
        this.writeSpace();
        if (quantifierRestriction.getOnProperty() != null) {
            quantifierRestriction.getOnProperty().accept(this);
        }
        this.writeSpace();
        if (quantifierRestriction.getFiller() != null) {
            quantifierRestriction.getFiller().accept(this);
        }
        this.writeClosePar();
    }

    protected void writeNAryLocical(OWLNAryLogicalClass logicalClass) {
        this.writeOpenPar();
        Iterator it = logicalClass.getOperands().iterator();
        while (it.hasNext()) {
            RDFResource res = (RDFResource)it.next();
            res.accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(logicalClass.getOperatorSymbol());
            this.writeSpace();
        }
        this.writeClosePar();
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom owlAllValuesFrom) {
        this.push(owlAllValuesFrom);
        this.writeQuantifier(owlAllValuesFrom);
        this.pop();
    }

    public void visitOWLCardinality(OWLCardinality owlCardinality) {
        this.push(owlCardinality);
        this.writeCardinality(owlCardinality);
        this.pop();
    }

    public void visitOWLComplementClass(OWLComplementClass owlComplementClass) {
        this.push(owlComplementClass);
        this.writeOpenPar();
        this.write(owlComplementClass.getOperatorSymbol());
        this.writeSpace();
        if (owlComplementClass.getComplement() != null) {
            owlComplementClass.getComplement().accept(this);
        }
        this.writeClosePar();
        this.pop();
    }

    public void visitOWLDataRange(OWLDataRange owlDataRange) {
        this.write("{");
        Iterator it = owlDataRange.getOneOfValueLiterals().iterator();
        while (it.hasNext()) {
            RDFSLiteral literal = (RDFSLiteral)it.next();
            literal.accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
        }
        this.write("}");
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty owlDatatypeProperty) {
        this.write(owlDatatypeProperty.getName());
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass owlEnumeratedClass) {
        this.push(owlEnumeratedClass);
        this.write("{");
        Iterator it = owlEnumeratedClass.getOneOf().iterator();
        while (it.hasNext()) {
            RDFResource res = (RDFResource)it.next();
            res.accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
        }
        this.write("}");
        this.pop();
    }

    public void visitOWLHasValue(OWLHasValue owlHasValue) {
        this.push(owlHasValue);
        this.writeOpenPar();
        this.write('\u2203');
        this.writeSpace();
        if (owlHasValue.getOnProperty() != null) {
            owlHasValue.getOnProperty().accept(this);
        }
        this.writeSpace();
        this.write("{");
        if (owlHasValue.getHasValue() != null) {
            Object value = owlHasValue.getHasValue();
            if (value instanceof RDFResource) {
                ((RDFResource)value).accept(this);
            } else {
                owlHasValue.getOWLModel().asRDFSLiteral(value).accept(this);
            }
        }
        this.write("}");
        this.writeClosePar();
        this.pop();
    }

    public void visitOWLIndividual(OWLIndividual owlIndividual) {
        this.write(owlIndividual.getName());
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass owlIntersectionClass) {
        this.push(owlIntersectionClass);
        this.writeNAryLocical(owlIntersectionClass);
        this.pop();
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality owlMaxCardinality) {
        this.push(owlMaxCardinality);
        this.writeCardinality(owlMaxCardinality);
        this.pop();
    }

    public void visitOWLMinCardinality(OWLMinCardinality owlMinCardinality) {
        this.push(owlMinCardinality);
        this.writeCardinality(owlMinCardinality);
        this.pop();
    }

    public void visitOWLNamedClass(OWLNamedClass owlNamedClass) {
        this.push(owlNamedClass);
        this.write(owlNamedClass.getName());
        this.pop();
    }

    public void visitOWLObjectProperty(OWLObjectProperty owlObjectProperty) {
        this.write(owlObjectProperty.getName());
    }

    public void visitOWLOntology(OWLOntology owlOntology) {
        this.write("<OWLOntology>");
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom someValuesFrom) {
        this.push(someValuesFrom);
        this.writeQuantifier(someValuesFrom);
        this.pop();
    }

    public void visitOWLUnionClass(OWLUnionClass owlUnionClass) {
        this.push(owlUnionClass);
        this.writeNAryLocical(owlUnionClass);
        this.pop();
    }

    public void visitRDFDatatype(RDFSDatatype rdfsDatatype) {
        this.write(rdfsDatatype.getBrowserText());
    }

    public void visitRDFIndividual(RDFIndividual rdfIndividual) {
        this.write(rdfIndividual.getName());
    }

    public void visitRDFList(RDFList rdfList) {
        this.write("<RDFList>");
    }

    public void visitRDFProperty(RDFProperty rdfProperty) {
        this.write(rdfProperty.getName());
    }

    public void visitRDFSLiteral(RDFSLiteral rdfsLiteral) {
        this.write(rdfsLiteral.getBrowserText());
    }

    public void visitRDFSNamedClass(RDFSNamedClass rdfsNamedClass) {
        this.push(rdfsNamedClass);
        this.pop();
    }

    public void visitRDFUntypedResource(RDFUntypedResource rdfUntypedResource) {
        this.write(rdfUntypedResource.getURI());
    }
}

