/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.classdisplay.dl.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.classdisplay.dl.DLSyntaxBrowserTextGenerator;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class DLSyntaxBrowserTextTests
extends AbstractJenaTestCase {
    private static final String CLS_A = "ClsA";
    private static final String CLS_B = "ClsB";
    private static final String PROP_P = "propP";
    private static final String IND_A = "indA";
    private static final String IND_B = "indB";
    private OWLNamedClass clsA;
    private OWLNamedClass clsB;
    private OWLObjectProperty propP;
    private OWLIndividual indA;
    private OWLIndividual indB;
    private DLSyntaxBrowserTextGenerator gen;

    protected void setUp() throws Exception {
        super.setUp();
        this.gen = new DLSyntaxBrowserTextGenerator();
        this.createPrimitives();
    }

    private void createPrimitives() {
        this.clsA = this.owlModel.createOWLNamedClass(CLS_A);
        this.clsB = this.owlModel.createOWLNamedClass(CLS_B);
        this.propP = this.owlModel.createOWLObjectProperty(PROP_P);
        this.indA = this.owlModel.getOWLThingClass().createOWLIndividual(IND_A);
        this.indB = this.owlModel.getOWLThingClass().createOWLIndividual(IND_B);
    }

    public void testOWLAllValuesFrom() {
        OWLAllValuesFrom allValuesFrom = this.owlModel.createOWLAllValuesFrom((RDFProperty)this.propP, this.clsA);
        allValuesFrom.accept(this.gen);
        DLSyntaxBrowserTextTests.assertEquals((String)(String.valueOf(allValuesFrom.getOperator()) + " " + PROP_P + " " + CLS_A), (String)this.gen.getBrowserText());
    }

    public void testNestedOWLAllValuesFrom() {
        OWLUnionClass unionClass = this.owlModel.createOWLUnionClass();
        unionClass.addOperand(this.clsA);
        unionClass.addOperand(this.clsB);
        OWLAllValuesFrom allValuesFrom = this.owlModel.createOWLAllValuesFrom((RDFProperty)this.propP, unionClass);
        allValuesFrom.accept(this.gen);
        DLSyntaxBrowserTextTests.assertEquals((String)(String.valueOf(allValuesFrom.getOperator()) + " " + PROP_P + " (" + CLS_A + " " + '\u2294' + " " + CLS_B + ")"), (String)this.gen.getBrowserText());
    }

    public void testOWLIntersectionClass() {
        OWLIntersectionClass intersectionClass = this.owlModel.createOWLIntersectionClass();
        intersectionClass.addOperand(this.clsA);
        intersectionClass.addOperand(this.clsB);
        intersectionClass.accept(this.gen);
        DLSyntaxBrowserTextTests.assertEquals((String)"ClsA \u2293 ClsB", (String)this.gen.getBrowserText());
    }

    public void testEmptyObjects() {
        this.owlModel.createOWLAllValuesFrom().accept(this.gen);
        this.owlModel.createOWLSomeValuesFrom().accept(this.gen);
        this.owlModel.createOWLHasValue().accept(this.gen);
        this.owlModel.createOWLMinCardinality().accept(this.gen);
        this.owlModel.createOWLCardinality().accept(this.gen);
        this.owlModel.createOWLMinCardinality().accept(this.gen);
        this.owlModel.createOWLMaxCardinality().accept(this.gen);
        this.owlModel.createOWLIntersectionClass().accept(this.gen);
        this.owlModel.createOWLUnionClass().accept(this.gen);
        this.owlModel.createOWLComplementClass().accept(this.gen);
    }
}

