/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadata;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.HTMLEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AnnotationTextAreaWidget
extends AbstractPropertyWidget {
    private RDFProperty annotationProperty;
    private Action editHTMLAction = new AbstractAction("Edit as HTML...", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            AnnotationTextAreaWidget.this.editAsHTML();
        }
    };
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            if (property.equals(AnnotationTextAreaWidget.this.annotationProperty)) {
                AnnotationTextAreaWidget.this.resetEditedValue();
            }
        }
    };
    private OWLLabeledComponent labeledComponent;
    private Object oldValue;
    private JTextArea textArea;

    private void assignCurrentValue() {
        RDFResource resource = this.getEditedResource();
        if (resource != null && this.annotationProperty != null) {
            String text = this.textArea.getText();
            if (!text.equals(this.oldValue)) {
                this.assignValue(text, resource);
            }
        } else {
            this.oldValue = null;
        }
    }

    private void assignValue(String text, RDFResource instance) {
        Object newValue = null;
        newValue = this.oldValue instanceof RDFSLiteral ? this.getOWLModel().createRDFSLiteralOrString(text, ((RDFSLiteral)this.oldValue).getLanguage()) : text;
        if (!this.getEditedResource().getPropertyValues(this.annotationProperty).contains(newValue) && !AnnotationsTableModel.isInvalidXMLLiteral(this.getRDFProperty(), newValue)) {
            Collection oldValues = instance.getPropertyValues(this.annotationProperty);
            ArrayList<Object> newValues = new ArrayList<Object>(oldValues);
            int index = newValues.indexOf(this.oldValue);
            if (text.length() > 0) {
                if (index >= 0) {
                    newValues.set(index, newValue);
                } else {
                    newValues.add(newValue);
                }
                instance.setPropertyValues(this.annotationProperty, newValues);
                this.oldValue = newValue;
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.unregisterFrameListener();
    }

    private void editAsHTML() {
        if (XMLSchemaDatatypes.isXMLLiteralSlot(this.getRDFProperty())) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.getOWLModel(), "This HTML editor does not support XMLLiterals yet.");
        } else {
            String oldText = this.textArea.getText();
            String newText = HTMLEditorPanel.show((Component)((Object)this), oldText, "Edit " + this.getRDFProperty().getBrowserText() + " at " + this.getEditedResource().getBrowserText());
            if (newText != null && !oldText.equals(newText)) {
                this.assignValue(newText, this.getEditedResource());
            }
        }
    }

    public void initialize() {
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                AnnotationTextAreaWidget.this.assignCurrentValue();
            }
        });
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && e.getKeyCode() == 10) {
                    AnnotationTextAreaWidget.this.getParent().requestFocus();
                }
            }
        });
        this.labeledComponent = new OWLLabeledComponent("rdfs:comment", new JScrollPane(this.textArea));
        this.labeledComponent.addHeaderButton(this.editHTMLAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)this.labeledComponent));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return slot.getKnowledgeBase() instanceof OWLModel && slot.getName().equals("rdfs:comment");
    }

    public void resetEditedValue() {
        OWLDatatypeProperty commentProperty = this.getOWLModel().getRDFSCommentProperty();
        String value = null;
        String defaultLanguage = this.getOWLModel().getDefaultLanguage();
        String languageStr = defaultLanguage;
        Object v = null;
        for (Object comment : this.getEditedResource().getPropertyValues(commentProperty)) {
            String lang;
            String string = lang = comment instanceof RDFSLiteral ? ((RDFSLiteral)comment).getLanguage() : null;
            if (!languageStr.equals(lang)) continue;
            value = comment instanceof RDFSLiteral ? ((RDFSLiteral)comment).getString() : comment.toString();
            v = comment;
            break;
        }
        this.setEditedValueInternal(commentProperty, value, defaultLanguage, v);
    }

    public void setEditedValue(OWLDatatypeProperty property, String value, String language, Object v) {
        this.assignCurrentValue();
        this.setEditedValueInternal(property, value, language, v);
    }

    private void setEditedValueInternal(OWLDatatypeProperty property, String value, String language, Object v) {
        if (value == null) {
            value = "";
        }
        this.annotationProperty = property;
        String label = property.getBrowserText();
        if (language != null && language.length() > 0) {
            label = String.valueOf(label) + " (" + language + ")";
        }
        this.labeledComponent.setHeaderLabel(label);
        this.oldValue = property.getOWLModel().createRDFSLiteralOrString(value, language);
        this.textArea.setText(value);
        boolean b = false;
        if (!property.isReadOnly()) {
            if (v == null) {
                b = true;
            } else {
                TripleStoreModel tsm = this.getOWLModel().getTripleStoreModel();
                b = tsm.isActiveTriple(this.getEditedResource(), property, v);
            }
        }
        this.textArea.setEditable(b);
        this.editHTMLAction.setEnabled(b);
    }

    public void setInstance(Instance newInstance) {
        this.unregisterFrameListener();
        this.assignCurrentValue();
        super.setInstance(newInstance);
        if (newInstance instanceof RDFResource) {
            ((RDFResource)newInstance).addPropertyValueListener(this.valueListener);
        }
        this.resetEditedValue();
    }

    private void unregisterFrameListener() {
        if (this.getEditedResource() != null) {
            this.getEditedResource().removePropertyValueListener(this.valueListener);
        }
    }
}

