/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.ProtegeSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.FacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.NumericFacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.OWLDataRangeComponent;
import edu.stanford.smi.protegex.owl.ui.properties.range.StringFacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.UnionRangeClassesComponent;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class OWLRangeWidget
extends AbstractPropertyWidget {
    private static final String ANY = "Any";
    private UnionRangeClassesComponent classesComponent;
    private JComboBox comboBox;
    private OWLDataRangeComponent dataRangeComponent;
    private FacetsPanel facetsPanel;
    private LabeledComponent lc;
    private JPanel mainPanel;
    private JPanel northPanel;
    private static final String OBJECTS = "Objects";
    private boolean ignore = false;

    public static void addDatatypes(OWLModel owlModel, Vector values) {
        values.add(owlModel.getXSDboolean());
        values.add(owlModel.getXSDfloat());
        values.add(owlModel.getXSDint());
        values.add(owlModel.getXSDstring());
        List ds = new ArrayList(owlModel.getRDFSDatatypes());
        ds.removeAll(values);
        ds = OWLUtil.removeInvisibleResources(ds.iterator());
        Collections.sort(ds, new FrameComparator());
        values.add(" ");
        values.addAll(ds);
    }

    private FacetsPanel createFacetsPanel(RDFSDatatype datatype) {
        if (datatype != null) {
            RDFSDatatype baseDatatype = datatype.getBaseDatatype();
            if (baseDatatype != null) {
                return this.createFacetsPanel(baseDatatype);
            }
            if (datatype.equals(this.getOWLModel().getXSDstring())) {
                return new StringFacetsPanel(this);
            }
            if (datatype.isNumericDatatype()) {
                return new NumericFacetsPanel(this);
            }
        }
        return null;
    }

    public void initialize() {
        this.classesComponent = new UnionRangeClassesComponent(this.getOWLModel(), this);
        this.comboBox = new JComboBox();
        this.comboBox.setRenderer(new FrameRenderer());
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                OWLRangeWidget.this.handleComboBoxChanged();
            }
        });
        this.northPanel = new JPanel(new BorderLayout());
        this.northPanel.add("North", this.comboBox);
        this.dataRangeComponent = new OWLDataRangeComponent(this);
        this.mainPanel = new JPanel(new BorderLayout(0, 4));
        this.mainPanel.add("North", this.northPanel);
        this.mainPanel.add("Center", this.dataRangeComponent);
        this.lc = new LabeledComponent("Range", (Component)this.mainPanel);
        this.lc.setVerticallyStretchable(true);
        this.add("Center", (Component)this.lc);
    }

    RDFProperty getEditedProperty() {
        return (RDFProperty)this.getEditedResource();
    }

    private void handleComboBoxChanged() {
        Object newValue = this.comboBox.getSelectedItem();
        if (" ".equals(newValue)) {
            this.comboBox.setSelectedItem(ANY);
            newValue = ANY;
        }
        if (ANY.equals(newValue)) {
            this.setRange(null);
        } else if (OBJECTS.equals(newValue)) {
            if (this.getEditedProperty().getRange() != null) {
                this.setRange(null);
            }
            this.mainPanel.remove(this.dataRangeComponent);
            this.mainPanel.add("Center", this.classesComponent);
            this.mainPanel.revalidate();
        } else if (newValue instanceof RDFSDatatype) {
            RDFSDatatype datatype = (RDFSDatatype)newValue;
            if (!datatype.equals(this.getEditedProperty().getRange())) {
                this.setRange(datatype);
            }
            this.dataRangeComponent.setDatatype(datatype);
            if (this.dataRangeComponent.getParent() != this.mainPanel) {
                this.mainPanel.remove(this.classesComponent);
                this.mainPanel.add("Center", this.dataRangeComponent);
                this.mainPanel.revalidate();
            }
        }
        this.updateFacetsPanel();
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals("rdfs:range");
    }

    private void refillAll() {
        this.refillComboBox();
        this.dataRangeComponent.refill();
        this.classesComponent.refill();
        this.updateFacetsPanel();
    }

    private void refillComboBox() {
        if (this.getEditedResource() instanceof OWLObjectProperty) {
            this.removeAll();
            this.add("Center", this.classesComponent);
        } else if (this.getEditedResource() instanceof RDFProperty) {
            this.add("Center", (Component)this.lc);
            Vector<String> values = new Vector<String>();
            OWLModel owlModel = this.getOWLModel();
            values.add(ANY);
            if (!(this.getEditedResource() instanceof OWLDatatypeProperty)) {
                values.add(OBJECTS);
            }
            OWLRangeWidget.addDatatypes(owlModel, values);
            this.comboBox.setModel(new DefaultComboBoxModel(values));
            this.selectComboBoxValue();
            this.dataRangeComponent.setEditable(!ANY.equals(this.comboBox.getSelectedItem()) && this.getEditedProperty().isEditable());
        }
    }

    private void selectComboBoxValue() {
        RDFProperty property = (RDFProperty)this.getEditedResource();
        if (property != null) {
            this.ignore = true;
            this.selectComboBoxValue(property);
            this.ignore = false;
        }
    }

    private void selectComboBoxValue(RDFProperty property) {
        RDFResource range = property.getRange();
        if (range instanceof RDFSDatatype) {
            RDFSDatatype datatype = (RDFSDatatype)range;
            if (datatype.getBaseDatatype() != null) {
                datatype = datatype.getBaseDatatype();
            }
            this.comboBox.setSelectedItem(datatype);
        } else if (range instanceof OWLDataRange) {
            RDFSDatatype datatype = ((OWLDataRange)range).getRDFDatatype();
            if (datatype != null && !datatype.equals(this.comboBox.getSelectedItem())) {
                this.comboBox.setSelectedItem(datatype);
            }
        } else if (range instanceof RDFSClass) {
            this.comboBox.setSelectedItem(OBJECTS);
        } else if (range == null && property.getSuperpropertyCount() > 0) {
            RDFProperty firstSuperproperty = property.getFirstSuperproperty();
            this.selectComboBoxValue(firstSuperproperty);
        }
    }

    public void setEditable(boolean b) {
        this.dataRangeComponent.setEditable(b);
        this.classesComponent.setEditable(b);
        this.comboBox.setEnabled(b);
        if (this.facetsPanel != null) {
            this.facetsPanel.setEditable(b);
        }
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        this.refillAll();
    }

    void setRange(RDFSDatatype datatype) {
        RDFResource range;
        if (!(this.ignore || (range = this.getEditedProperty().getRange()) != null && range.equals(datatype))) {
            if (range instanceof RDFSDatatype && range.isAnonymous()) {
                range.delete();
            }
            this.getEditedProperty().setRange(datatype);
        }
    }

    public void setValues(Collection collection) {
        this.refillAll();
    }

    private void updateFacetsPanel() {
        if (ProtegeSettingsPanel.isUserDefinedDatatypesSupported(this.getOWLModel())) {
            RDFResource range = this.getEditedProperty().getRange();
            if (this.facetsPanel != null) {
                this.northPanel.remove(this.facetsPanel);
                this.mainPanel.revalidate();
            }
            if (range instanceof RDFSDatatype) {
                RDFSDatatype datatype = (RDFSDatatype)range;
                this.facetsPanel = this.createFacetsPanel(datatype);
                if (this.facetsPanel != null) {
                    this.northPanel.add("South", this.facetsPanel);
                    this.mainPanel.revalidate();
                    this.facetsPanel.update(datatype);
                }
            }
        }
    }
}

