/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.tooltips;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLToolTipGenerator;
import java.net.URI;

public class HomeOntologyToolTipGenerator
implements OWLToolTipGenerator {
    public String getToolTipText(RDFSClass aClass) {
        return this.getToolTipText((RDFResource)aClass);
    }

    public String getToolTipText(RDFProperty prop) {
        return this.getToolTipText((RDFResource)prop);
    }

    public String getToolTipText(RDFResource res) {
        String text = null;
        if (res != null) {
            OWLModel owlModel;
            TripleStore homeTS;
            text = "";
            if (!(res instanceof OWLAnonymousClass)) {
                text = String.valueOf(text) + "<b>" + res.getURI() + "</b>";
            }
            if ((homeTS = (owlModel = res.getOWLModel()).getTripleStoreModel().getHomeTripleStore(res)) != null) {
                OWLOntology homeOnt = (OWLOntology)TripleStoreUtil.getFirstOntology(owlModel, homeTS);
                try {
                    URI homeOntURI = new URI(homeOnt.getURI());
                    text = String.valueOf(text) + "<br><b>ontology:</b> " + homeOntURI;
                    RepositoryManager repManager = owlModel.getRepositoryManager();
                    Repository homeRep = repManager.getRepository(homeOntURI);
                    String homeLocation = "";
                    if (homeRep != null) {
                        homeLocation = homeRep.getOntologyLocationDescription(homeOntURI);
                    } else {
                        String projname = owlModel.getProject().getName();
                        if (projname == null) {
                            projname = "not yet saved";
                        }
                        homeLocation = "main ontology [" + projname + "]";
                    }
                    text = String.valueOf(text) + "<br><b>location:</b> " + homeLocation;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            text = !text.equals("") ? "<html><body>" + text + "</body></html>" : null;
        }
        return text;
    }
}

