/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SwingListExample {
    public static void main(String[] args) throws Exception {
        String uri = "http://www.owl-ontologies.com/travel.owl";
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModelFromURI(uri);
        OWLNamedClass destinationClass = owlModel.getOWLNamedClass("Destination");
        ListPanel listPanel = new ListPanel(destinationClass);
        JFrame frame = new JFrame("Simple List Example");
        Container cont = frame.getContentPane();
        cont.setLayout(new BorderLayout());
        cont.add("Center", listPanel);
        frame.setBounds(100, 100, 300, 300);
        frame.setVisible(true);
    }

    private static class ListPanel
    extends JPanel
    implements Disposable {
        private OWLNamedClass destinationClass;
        private JList list;
        private DefaultListModel listModel;
        private ModelListener modelListener = new ModelAdapter(){

            public void individualCreated(RDFResource resource) {
                if (resource.hasProtegeType(ListPanel.this.destinationClass, true)) {
                    ListPanel.this.handleDestinationAdded(resource);
                }
            }
        };
        private OWLModel owlModel;

        ListPanel(OWLNamedClass activityClass) {
            this.destinationClass = activityClass;
            this.owlModel = activityClass.getOWLModel();
            this.owlModel.addModelListener(this.modelListener);
            this.listModel = new DefaultListModel();
            for (OWLIndividual individual : activityClass.getInstances(true)) {
                this.listModel.addElement(individual);
            }
            this.list = new JList(this.listModel);
            this.list.setCellRenderer(new ResourceRenderer());
            OWLLabeledComponent lc = new OWLLabeledComponent("Destinations", new JScrollPane(this.list));
            lc.addHeaderButton(new AbstractAction("Add Destination...", OWLIcons.getAddIcon("RDFIndividual")){

                public void actionPerformed(ActionEvent e) {
                    ListPanel.this.addDestination();
                }
            });
            this.setLayout(new BorderLayout());
            this.add("Center", (Component)((Object)lc));
        }

        private void addDestination() {
            String name;
            RDFSNamedClass newType = ProtegeUI.getSelectionDialogFactory().selectClass((Component)this, this.owlModel, Collections.singleton(this.destinationClass), "Select type of new Destination");
            if (newType != null && (name = JOptionPane.showInputDialog("Enter name of new " + newType.getBrowserText())) != null) {
                newType.createRDFIndividual(name);
            }
        }

        public void dispose() {
            this.owlModel.removeModelListener(this.modelListener);
        }

        private void handleDestinationAdded(RDFResource destination) {
            this.listModel.addElement(destination);
            this.list.setSelectedValue(destination, true);
        }
    }
}

