/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.server.framestore;

import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.SystemFrames;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.Sft;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.server.RemoteServer;
import edu.stanford.smi.protege.server.RemoteServerProject;
import edu.stanford.smi.protege.server.RemoteSession;
import edu.stanford.smi.protege.server.Server;
import edu.stanford.smi.protege.server.framestore.RemoteServerFrameStore;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.LocalizeUtils;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteClientFrameStore
implements FrameStore {
    private static Logger log = Log.getLogger(RemoteClientFrameStore.class);
    private KnowledgeBase kb;
    private RemoteSession session;
    private RemoteServer server;
    private RemoteServerFrameStore remoteDelegate;
    private Map<String, Frame> frameNameToFrameMap = new HashMap<String, Frame>();
    private Map<Frame, Map<Sft, List>> cache = new HashMap<Frame, Map<Sft, List>>();
    private Sft lookupSft = new Sft();
    private static boolean preloadRemoteClient;

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    public RemoteServerFrameStore getRemoteDelegate() {
        this.fixLoader();
        return this.remoteDelegate;
    }

    private void fixLoader() {
        ClassLoader classLoader;
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        if (classLoader2 != (classLoader = this.kb.getClass().getClassLoader())) {
            if (log.isLoggable(Level.FINE)) {
                Log.getLogger().fine("Changing loader from " + classLoader2 + " to " + classLoader);
            }
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public RemoteClientFrameStore(String string, String string2, String string3, String string4, KnowledgeBase knowledgeBase, boolean bl) {
        try {
            this.server = (RemoteServer)Naming.lookup("//" + string + "/" + Server.getBoundName());
            String string5 = SystemUtilities.getMachineIpAddress();
            this.session = this.server.openSession(string2, string5, string3);
            RemoteServerProject remoteServerProject = this.server.openProject(string4, this.session);
            this.remoteDelegate = remoteServerProject.getDomainKbFrameStore(this.session);
            this.kb = knowledgeBase;
            this.preload(bl);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
    }

    public RemoteClientFrameStore(RemoteServerFrameStore remoteServerFrameStore, RemoteSession remoteSession, KnowledgeBase knowledgeBase, boolean bl) {
        try {
            this.session = remoteSession;
            this.kb = knowledgeBase;
            this.remoteDelegate = remoteServerFrameStore;
            this.preload(bl);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
    }

    @Override
    public void setDelegate(FrameStore frameStore) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FrameStore getDelegate() {
        return null;
    }

    @Override
    public void reinitialize() {
    }

    private static RuntimeException convertException(Exception exception) {
        return new RuntimeException(exception);
    }

    @Override
    public int getClsCount() {
        try {
            return this.getRemoteDelegate().getClsCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getSlotCount() {
        try {
            return this.getRemoteDelegate().getSlotCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getFacetCount() {
        try {
            return this.getRemoteDelegate().getFacetCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getSimpleInstanceCount() {
        try {
            return this.getRemoteDelegate().getSimpleInstanceCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getFrameCount() {
        try {
            return this.getRemoteDelegate().getFrameCount(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    private void localize(Object object) {
        LocalizeUtils.localize(object, this.kb);
    }

    @Override
    public Set getClses() {
        try {
            Set set = this.getRemoteDelegate().getClses(this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getSlots() {
        try {
            Set set = this.getRemoteDelegate().getSlots(this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getFacets() {
        try {
            Set set = this.getRemoteDelegate().getFacets(this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getFrames() {
        try {
            Set set = this.getRemoteDelegate().getFrames(this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Frame getFrame(FrameID frameID) {
        try {
            Frame frame = this.getRemoteDelegate().getFrame(frameID, this.session);
            this.localize(frame);
            return frame;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Frame getFrame(String string) {
        try {
            return this.getCacheFrame(string);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public String getFrameName(Frame frame) {
        try {
            List list = this.getCacheDirectOwnSlotValues(frame, this.getSystemFrames().getNameSlot());
            return (String)CollectionUtilities.getFirstItem(list);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void setFrameName(Frame frame, String string) {
        try {
            this.setCachedFrameName(frame, string);
            this.getRemoteDelegate().setFrameName(frame, string, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Cls createCls(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        try {
            Cls cls = this.getRemoteDelegate().createCls(frameID, string, collection, collection2, bl, this.session);
            this.localize(cls);
            this.addCacheOwnSlotValue(collection, this.getSystemFrames().getDirectInstancesSlot(), (Object)cls);
            this.addCacheOwnSlotValue(collection2, this.getSystemFrames().getDirectSubclassesSlot(), (Object)cls);
            return cls;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Slot createSlot(FrameID frameID, String string, Collection collection, Collection collection2, boolean bl) {
        try {
            Slot slot = this.getRemoteDelegate().createSlot(frameID, string, collection, collection2, bl, this.session);
            this.localize(slot);
            this.addCacheOwnSlotValue(collection, this.getSystemFrames().getDirectInstancesSlot(), (Object)slot);
            this.addCacheOwnSlotValue(collection2, this.getSystemFrames().getDirectSubslotsSlot(), (Object)slot);
            return slot;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Facet createFacet(FrameID frameID, String string, Collection collection, boolean bl) {
        try {
            Facet facet = this.getRemoteDelegate().createFacet(frameID, string, collection, bl, this.session);
            this.localize(facet);
            this.addCacheOwnSlotValue(collection, this.getSystemFrames().getDirectInstancesSlot(), (Object)facet);
            return facet;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public SimpleInstance createSimpleInstance(FrameID frameID, String string, Collection collection, boolean bl) {
        try {
            SimpleInstance simpleInstance = this.getRemoteDelegate().createSimpleInstance(frameID, string, collection, bl, this.session);
            this.localize(simpleInstance);
            this.addCacheOwnSlotValue(collection, this.getSystemFrames().getDirectInstancesSlot(), (Object)simpleInstance);
            return simpleInstance;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void deleteCls(Cls cls) {
        try {
            this.removeCacheFrame(cls);
            this.getRemoteDelegate().deleteCls(cls, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void deleteSlot(Slot slot) {
        try {
            this.removeCacheFrame(slot);
            this.getRemoteDelegate().deleteSlot(slot, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void deleteFacet(Facet facet) {
        try {
            this.removeCacheFrame(facet);
            this.getRemoteDelegate().deleteFacet(facet, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void deleteSimpleInstance(SimpleInstance simpleInstance) {
        try {
            this.removeCacheFrame(simpleInstance);
            this.getRemoteDelegate().deleteSimpleInstance(simpleInstance, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getOwnSlots(Frame frame) {
        return this.getCacheOwnSlots(frame);
    }

    @Override
    public Collection getOwnSlotValues(Frame frame, Slot slot) {
        return this.getCacheOwnSlotValues(frame, slot);
    }

    @Override
    public List getDirectOwnSlotValues(Frame frame, Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(frame, slot);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public int getDirectOwnSlotValuesCount(Frame frame, Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(frame, slot).size();
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void moveDirectOwnSlotValue(Frame frame, Slot slot, int n, int n2) {
        try {
            this.moveCacheValue(frame, slot, (Facet)null, false, n, n2);
            this.getRemoteDelegate().moveDirectOwnSlotValue(frame, slot, n, n2, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void setDirectOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        try {
            this.updateCacheInverseSlotValues(frame, slot, collection);
            this.setCacheOwnSlotValues(frame, slot, collection);
            this.getRemoteDelegate().setDirectOwnSlotValues(frame, slot, collection, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    private void updateCacheInverseSlotValues(Frame frame, Slot slot, Collection collection) throws RemoteException {
        Slot slot2 = slot.getInverseSlot();
        if (slot2 != null) {
            for (Object e : new ArrayList(this.getDirectOwnSlotValues(frame, slot))) {
                if (!(e instanceof Frame)) continue;
                Frame frame2 = (Frame)e;
                this.removeCacheOwnSlotValue(frame2, slot2, frame);
            }
            boolean bl = !slot2.getAllowsMultipleValues();
            for (Object e : collection) {
                Object object;
                if (!(e instanceof Frame)) continue;
                Frame frame3 = (Frame)e;
                if (bl && (object = this.getCacheDirectOwnSlotValue(frame3, slot2)) instanceof Frame) {
                    Frame frame4 = (Frame)e;
                    this.removeCacheOwnSlotValue(frame4, slot, frame3);
                }
                this.addCacheOwnSlotValue(frame3, slot2, (Object)frame);
            }
        }
    }

    @Override
    public Set getOwnFacets(Frame frame, Slot slot) {
        return this.getCacheOwnFacets(frame, slot);
    }

    @Override
    public Collection getOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        return this.getCacheOwnFacetValues(frame, slot, facet);
    }

    @Override
    public Set getTemplateSlots(Cls cls) {
        return this.getCacheTemplateSlots(cls);
    }

    @Override
    public List getDirectTemplateSlots(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectTemplateSlotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public List getDirectDomain(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectDomainSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getDomain(Slot slot) {
        try {
            return this.getCacheDomain(slot);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getOverriddenTemplateSlots(Cls cls) {
        try {
            Set set = this.getRemoteDelegate().getOverriddenTemplateSlots(cls, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getDirectlyOverriddenTemplateSlots(Cls cls) {
        try {
            Set set = this.getRemoteDelegate().getDirectlyOverriddenTemplateSlots(cls, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void addDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            this.addCacheOwnSlotValue(cls, this.getSystemFrames().getDirectTemplateSlotsSlot(), (Object)slot);
            this.addCacheOwnSlotValue(slot, this.getSystemFrames().getDirectDomainSlot(), (Object)cls);
            this.getRemoteDelegate().addDirectTemplateSlot(cls, slot, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void removeDirectTemplateSlot(Cls cls, Slot slot) {
        try {
            this.removeCacheOwnSlotValue(cls, this.getSystemFrames().getDirectTemplateSlotsSlot(), slot);
            this.removeCacheOwnSlotValue(slot, this.getSystemFrames().getDirectDomainSlot(), cls);
            this.getRemoteDelegate().removeDirectTemplateSlot(cls, slot, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void moveDirectTemplateSlot(Cls cls, Slot slot, int n) {
        try {
            this.moveCacheOwnSlotValue(cls, this.getSystemFrames().getDirectTemplateSlotsSlot(), slot, n);
            this.getRemoteDelegate().moveDirectTemplateSlot(cls, slot, n, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Collection getTemplateSlotValues(Cls cls, Slot slot) {
        return this.getCacheTemplateSlotValues(cls, slot);
    }

    @Override
    public List getDirectTemplateSlotValues(Cls cls, Slot slot) {
        try {
            return this.getCacheValues(cls, slot, this.getSystemFrames().getValuesFacet(), true);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void setDirectTemplateSlotValues(Cls cls, Slot slot, Collection collection) {
        try {
            this.setCacheValues(cls, slot, this.getSystemFrames().getValuesFacet(), true, collection);
            this.getRemoteDelegate().setDirectTemplateSlotValues(cls, slot, collection, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getTemplateFacets(Cls cls, Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getTemplateFacets(cls, slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getOverriddenTemplateFacets(Cls cls, Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getOverriddenTemplateFacets(cls, slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getDirectlyOverriddenTemplateFacets(Cls cls, Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getDirectlyOverriddenTemplateFacets(cls, slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void removeDirectTemplateFacetOverrides(Cls cls, Slot slot) {
        try {
            this.getRemoteDelegate().removeDirectTemplateFacetOverrides(cls, slot, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Collection getTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        return this.getCacheTemplateFacetValues(cls, slot, facet);
    }

    @Override
    public List getDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        try {
            return this.getCacheValues(cls, slot, facet, true);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void setDirectTemplateFacetValues(Cls cls, Slot slot, Facet facet, Collection collection) {
        try {
            this.setCacheValues(cls, slot, facet, true, collection);
            this.getRemoteDelegate().setDirectTemplateFacetValues(cls, slot, facet, collection, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public List getDirectSuperclasses(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getSuperclasses(Cls cls) {
        try {
            return this.getCacheOwnSlotValueClosure(cls, this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    private SystemFrames getSystemFrames() {
        return this.kb.getSystemFrames();
    }

    @Override
    public List getDirectSubclasses(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectSubclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getSubclasses(Cls cls) {
        try {
            return this.getCacheOwnSlotValueClosure(cls, this.getSystemFrames().getDirectSubclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void addDirectSuperclass(Cls cls, Cls cls2) {
        try {
            this.addCacheOwnSlotValue(cls2, this.getSystemFrames().getDirectSubclassesSlot(), (Object)cls);
            this.addCacheOwnSlotValue(cls, this.getSystemFrames().getDirectSuperclassesSlot(), (Object)cls2);
            this.getRemoteDelegate().addDirectSuperclass(cls, cls2, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void removeDirectSuperclass(Cls cls, Cls cls2) {
        try {
            this.removeCacheOwnSlotValue(cls2, this.getSystemFrames().getDirectSubclassesSlot(), cls);
            this.removeCacheOwnSlotValue(cls, this.getSystemFrames().getDirectSuperclassesSlot(), cls2);
            this.getRemoteDelegate().removeDirectSuperclass(cls, cls2, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void moveDirectSubclass(Cls cls, Cls cls2, int n) {
        try {
            this.moveCacheOwnSlotValue(cls, this.getSystemFrames().getDirectSubclassesSlot(), cls2, n);
            this.getRemoteDelegate().moveDirectSubclass(cls, cls2, n, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public List getDirectSuperslots(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectSuperslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getSuperslots(Slot slot) {
        try {
            return this.getCacheOwnSlotValueClosure(slot, this.getSystemFrames().getDirectSuperslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public List getDirectSubslots(Slot slot) {
        try {
            return this.getCacheDirectOwnSlotValues(slot, this.getSystemFrames().getDirectSubslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getSubslots(Slot slot) {
        try {
            return this.getCacheOwnSlotValueClosure(slot, this.getSystemFrames().getDirectSubslotsSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void addDirectSuperslot(Slot slot, Slot slot2) {
        try {
            this.addCacheOwnSlotValue(slot2, this.getSystemFrames().getDirectSubslotsSlot(), (Object)slot);
            this.addCacheOwnSlotValue(slot, this.getSystemFrames().getDirectSuperslotsSlot(), (Object)slot2);
            this.getRemoteDelegate().addDirectSuperslot(slot, slot2, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void removeDirectSuperslot(Slot slot, Slot slot2) {
        try {
            this.removeCacheOwnSlotValue(slot2, this.getSystemFrames().getDirectSubslotsSlot(), slot);
            this.removeCacheOwnSlotValue(slot, this.getSystemFrames().getDirectSuperslotsSlot(), slot2);
            this.getRemoteDelegate().removeDirectSuperslot(slot, slot2, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void moveDirectSubslot(Slot slot, Slot slot2, int n) {
        try {
            this.moveCacheOwnSlotValue(slot, this.getSystemFrames().getDirectSubslotsSlot(), slot2, n);
            this.getRemoteDelegate().moveDirectSubslot(slot, slot2, n, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public List getDirectTypes(Instance instance) {
        try {
            return this.getCacheDirectOwnSlotValues(instance, this.getSystemFrames().getDirectTypesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getTypes(Instance instance) {
        try {
            return this.getCacheOwnSlotValueClosure(this.getDirectTypes(instance), this.getSystemFrames().getDirectSuperclassesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public List getDirectInstances(Cls cls) {
        try {
            return this.getCacheDirectOwnSlotValues(cls, this.getSystemFrames().getDirectInstancesSlot());
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getInstances(Cls cls) {
        try {
            Set set = this.getRemoteDelegate().getInstances(cls, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void addDirectType(Instance instance, Cls cls) {
        try {
            this.addCacheOwnSlotValue(instance, this.getSystemFrames().getDirectTypesSlot(), (Object)cls);
            this.addCacheOwnSlotValue(cls, this.getSystemFrames().getDirectInstancesSlot(), (Object)instance);
            this.getRemoteDelegate().addDirectType(instance, cls, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void removeDirectType(Instance instance, Cls cls) {
        try {
            this.removeCacheOwnSlotValue(instance, this.getSystemFrames().getDirectTypesSlot(), cls);
            this.removeCacheOwnSlotValue(cls, this.getSystemFrames().getDirectInstancesSlot(), instance);
            this.getRemoteDelegate().removeDirectType(instance, cls, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void moveDirectType(Instance instance, Cls cls, int n) {
        try {
            this.moveCacheOwnSlotValue(instance, this.getSystemFrames().getDirectTypesSlot(), cls, n);
            this.getRemoteDelegate().moveDirectType(instance, cls, n, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public List<EventObject> getEvents() {
        try {
            List<EventObject> list = this.getRemoteDelegate().getEvents(this.session);
            this.localize(list);
            this.processEvents(list);
            return list;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set executeQuery(Query query) {
        try {
            Set set = this.getRemoteDelegate().executeQuery(query, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getReferences(Object object) {
        try {
            Set set = this.getRemoteDelegate().getReferences(object, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithMatchingBrowserText(String string, Collection collection, int n) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithMatchingBrowserText(string, collection, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getMatchingReferences(String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getMatchingReferences(string, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getFramesWithDirectOwnSlotValue(Slot slot, Object object) {
        try {
            Set set = this.getRemoteDelegate().getFramesWithDirectOwnSlotValue(slot, object, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getFramesWithAnyDirectOwnSlotValue(Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getFramesWithAnyDirectOwnSlotValue(slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getFramesWithMatchingDirectOwnSlotValue(Slot slot, String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getFramesWithMatchingDirectOwnSlotValue(slot, string, n, this.session);
            this.localize(set);
            this.loadReturnedValues(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithDirectTemplateSlotValue(Slot slot, Object object) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithDirectTemplateSlotValue(slot, object, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithAnyDirectTemplateSlotValue(Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithAnyDirectTemplateSlotValue(slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateSlotValue(Slot slot, String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithMatchingDirectTemplateSlotValue(slot, string, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithDirectTemplateFacetValue(Slot slot, Facet facet, Object object) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithDirectTemplateFacetValue(slot, facet, object, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getClsesWithMatchingDirectTemplateFacetValue(Slot slot, Facet facet, String string, int n) {
        try {
            Set set = this.getRemoteDelegate().getClsesWithMatchingDirectTemplateFacetValue(slot, facet, string, n, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public Set getDirectOwnSlotValuesClosure(Frame frame, Slot slot) {
        try {
            Set set = this.getRemoteDelegate().getDirectOwnSlotValuesClosure(frame, slot, this.session);
            this.localize(set);
            return set;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public boolean beginTransaction(String string) {
        try {
            return this.getRemoteDelegate().beginTransaction(string, this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public boolean commitTransaction() {
        try {
            return this.getRemoteDelegate().commitTransaction(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public boolean rollbackTransaction() {
        try {
            return this.getRemoteDelegate().rollbackTransaction(this.session);
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    @Override
    public void close() {
        try {
            if (this.server != null) {
                this.server.closeSession(this.session);
                this.server = null;
            }
            this.remoteDelegate = null;
        }
        catch (RemoteException remoteException) {
            throw RemoteClientFrameStore.convertException(remoteException);
        }
    }

    public void preload(boolean bl) throws RemoteException {
        if (!preloadRemoteClient) {
            return;
        }
        Map map = this.getRemoteDelegate().preload(bl, this.session);
        Log.getLogger().info("Preloaded with " + map.size() + " frames");
        this.insertValues(map);
    }

    private Set getCacheOwnSlotValueClosure(Frame frame, Slot slot) throws RemoteException {
        return this.getCacheClosure(frame, slot, null, false);
    }

    private Set getCacheOwnSlotValueClosure(Collection collection, Slot slot) throws RemoteException {
        return this.getCacheClosure(collection, slot, null, false);
    }

    private Set getCacheClosure(Frame frame, Slot slot, Facet facet, boolean bl) throws RemoteException {
        Set set = new HashSet();
        boolean bl2 = this.calculateClosureFromCacheOnly(frame, slot, facet, bl, set);
        if (!bl2) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("not in cache: " + frame);
            }
            set = this.getRemoteDelegate().getDirectOwnSlotValuesClosure(frame, slot, this.session);
            this.localize(set);
            this.loadReturnedValues(set);
        }
        return set;
    }

    private Set getCacheClosure(Collection collection, Slot slot, Facet facet, boolean bl) throws RemoteException {
        HashSet hashSet = new HashSet(collection);
        for (Frame frame : collection) {
            hashSet.addAll(this.getCacheClosure(frame, slot, facet, bl));
        }
        return hashSet;
    }

    private boolean isCached(Frame frame) {
        return this.cache.containsKey(frame);
    }

    private boolean calculateClosureFromCacheOnly(Frame frame, Slot slot, Facet facet, boolean bl, Set set) throws RemoteException {
        boolean bl2 = this.isCached(frame);
        if (bl2) {
            List list = this.getCacheValues(frame, slot, facet, bl);
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && bl2) {
                Object e = iterator.next();
                boolean bl3 = set.add(e);
                if (!bl3 || !(e instanceof Frame)) continue;
                bl2 = this.calculateClosureFromCacheOnly((Frame)e, slot, facet, bl, set);
            }
        }
        return bl2;
    }

    private List getCacheDirectOwnSlotValues(Frame frame, Slot slot) throws RemoteException {
        return this.getCacheValues(frame, slot, null, false);
    }

    private Object getCacheDirectOwnSlotValue(Frame frame, Slot slot) throws RemoteException {
        return CollectionUtilities.getFirstItem(this.getCacheValues(frame, slot, null, false));
    }

    private List getCacheValues(Frame frame, Slot slot, Facet facet, boolean bl) throws RemoteException {
        Map<Sft, List> map = this.cache.get(frame);
        if (map == null) {
            map = this.loadValues(frame);
        }
        this.lookupSft.set(slot, facet, bl);
        List list = map.get(this.lookupSft);
        if (list == null && map.containsKey(this.lookupSft)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("getting missing values for:  " + frame);
            }
            if (facet != null) {
                if (bl) {
                    list = this.getRemoteDelegate().getDirectTemplateFacetValues((Cls)frame, slot, facet, this.session);
                } else {
                    Collection collection = this.getRemoteDelegate().getOwnFacetValues(frame, slot, facet, this.session);
                    list = new ArrayList();
                    list.addAll(collection);
                }
            } else {
                list = bl ? this.getRemoteDelegate().getDirectTemplateSlotValues((Cls)frame, slot, this.session) : this.getRemoteDelegate().getDirectOwnSlotValues(frame, slot, this.session);
            }
            this.localize(list);
            map.put(new Sft(slot, facet, bl), new ArrayList(list));
        }
        if (list == null) {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    private Map<Sft, List> loadValues(Frame frame) throws RemoteException {
        this.loadValues(Collections.singleton(frame));
        return this.cache.get(frame);
    }

    private void loadValues(Collection<Frame> collection) throws RemoteException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("loading values for " + collection.size() + " frames");
            for (Frame frame : collection) {
                log.finer("\tFrame id =  " + frame.getFrameID());
            }
        }
        Map map = this.getRemoteDelegate().getFrameValues(collection, this.session);
        this.insertValues(map);
    }

    private void insertValues(Map<Frame, Map<Sft, List>> map) {
        this.localize(map);
        for (Map.Entry<Frame, Map<Sft, List>> entry : map.entrySet()) {
            Frame frame = entry.getKey();
            Map<Sft, List> map2 = entry.getValue();
            this.cache.put(frame, map2);
            String string = this.getFrameName(frame);
            this.frameNameToFrameMap.put(string, frame);
            if (!log.isLoggable(Level.FINE)) continue;
            log.fine("Inserted values (count = " + map2.size() + ") for frame (" + frame.getFrameID() + ") named " + string);
        }
    }

    private void addCacheOwnSlotValue(Frame frame, Slot slot, Object object) {
        this.addCacheValue(frame, slot, null, false, object);
    }

    private void addCacheOwnSlotValue(Collection collection, Slot slot, Object object) {
        for (Frame frame : collection) {
            this.addCacheOwnSlotValue(frame, slot, object);
        }
    }

    private void removeCacheOwnSlotValue(Frame frame, Slot slot, Object object) {
        this.removeCacheValue(frame, slot, null, false, object);
    }

    private void setCacheOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        this.setCacheValues(frame, slot, null, false, collection);
    }

    private void addCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        Map<Sft, List> map = this.cache.get(frame);
        if (map != null) {
            this.lookupSft.set(slot, facet, bl);
            boolean bl2 = map.containsKey(this.lookupSft);
            ArrayList<Object> arrayList = map.get(this.lookupSft);
            if (!bl2 || arrayList != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    map.put(new Sft(slot, facet, bl), arrayList);
                }
                arrayList.add(object);
            }
        }
    }

    private void moveCacheOwnSlotValue(Frame frame, Slot slot, Object object, int n) {
        this.moveCacheValue(frame, slot, null, false, object, n);
    }

    private void moveCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object, int n) {
        Map<Sft, List> map = this.cache.get(frame);
        if (map != null) {
            this.lookupSft.set(slot, facet, bl);
            List list = map.get(this.lookupSft);
            if (list != null) {
                list.remove(object);
                list.add(n, object);
            }
        }
    }

    private void moveCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        Map<Sft, List> map = this.cache.get(frame);
        if (map != null) {
            this.lookupSft.set(slot, facet, bl);
            List list = map.get(this.lookupSft);
            if (list != null) {
                Object e = list.remove(n);
                list.add(n2, e);
            }
        }
    }

    private void setCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        this.setCacheValues(frame, slot, facet, bl, Collections.singleton(object));
    }

    private void setCacheValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        Map<Sft, List> map = this.cache.get(frame);
        if (map != null) {
            map.put(new Sft(slot, facet, bl), new ArrayList(collection));
        }
    }

    private void removeCacheValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        Map<Sft, List> map = this.cache.get(frame);
        if (map != null) {
            this.lookupSft.set(slot, facet, bl);
            List list = map.get(this.lookupSft);
            if (list != null) {
                list.remove(object);
            }
        }
    }

    private Frame getCacheFrame(String string) throws RemoteException {
        Frame frame = this.frameNameToFrameMap.get(string);
        if (frame == null) {
            if (!this.frameNameToFrameMap.containsKey(string) && (frame = this.getRemoteDelegate().getFrame(string, this.session)) != null) {
                this.localize(frame);
            }
            this.frameNameToFrameMap.put(string, frame);
        }
        return frame;
    }

    private void removeCacheFrame(Frame frame) {
        String string = this.getFrameName(frame);
        this.cache.remove(frame);
        this.frameNameToFrameMap.remove(string);
    }

    private void setCachedFrameName(Frame frame, String string) {
        String string2 = this.getFrameName(frame);
        this.frameNameToFrameMap.remove(string2);
        this.frameNameToFrameMap.put(string, frame);
        this.setCacheValue(frame, this.getSystemFrames().getNameSlot(), null, false, string);
    }

    private Collection getCacheOwnFacetValues(Frame frame, Slot slot, Facet facet) {
        ArrayList arrayList = new ArrayList();
        for (Cls cls : this.getDirectTypes((Instance)frame)) {
            arrayList.addAll(this.getTemplateFacetValues(cls, slot, facet));
        }
        return arrayList;
    }

    private Collection getCacheTemplateFacetValues(Cls cls, Slot slot, Facet facet) {
        List list;
        Instance instance2;
        Collection collection = new ArrayList(this.getDirectTemplateFacetValues(cls, slot, facet));
        for (Instance instance2 : this.getSuperclasses(cls)) {
            list = this.getDirectTemplateFacetValues((Cls)instance2, slot, facet);
            collection = RemoteClientFrameStore.resolveValues(collection, list, facet);
        }
        instance2 = (Slot)this.getDirectOwnSlotValue(facet, this.getSystemFrames().getAssociatedSlotSlot());
        if (instance2 != null) {
            list = this.getDirectOwnSlotValues(slot, (Slot)instance2);
            collection = RemoteClientFrameStore.resolveValues(collection, list, facet);
        }
        return collection;
    }

    private Object getDirectOwnSlotValue(Frame frame, Slot slot) {
        List list = this.getDirectOwnSlotValues(frame, slot);
        return CollectionUtilities.getFirstItem(list);
    }

    private static Collection resolveValues(Collection arrayList, Collection collection, Facet facet) {
        if (!collection.isEmpty()) {
            if (arrayList.isEmpty()) {
                arrayList.addAll(collection);
            } else if ((arrayList = facet.resolveValues(arrayList, collection)) == collection) {
                arrayList = new ArrayList(arrayList);
            }
        }
        return arrayList;
    }

    public Collection getCacheOwnSlotValues(Frame frame, Slot slot) {
        ArrayList arrayList = new ArrayList();
        this.addOwnSlotValues(frame, slot, arrayList);
        return arrayList;
    }

    private void addOwnSlotValues(Frame frame, Slot slot, Collection collection) {
        collection.addAll(this.getDirectOwnSlotValues(frame, slot));
        this.addInheritedTemplateSlotValues(frame, slot, collection);
        this.addSubslotValues(frame, slot, collection);
        if (frame instanceof Slot && collection.isEmpty() && this.isInheritedSuperslotSlot(slot)) {
            this.addInheritedSuperslotValues((Slot)frame, slot, collection);
        }
    }

    private boolean isInheritedSuperslotSlot(Slot slot) {
        return slot.equals(this.getSystemFrames().getDirectDomainSlot()) || slot.equals(this.getSystemFrames().getValueTypeSlot()) || slot.equals(this.getSystemFrames().getMaximumCardinalitySlot()) || slot.equals(this.getSystemFrames().getMinimumValueSlot()) || slot.equals(this.getSystemFrames().getMaximumValueSlot());
    }

    private void addInheritedSuperslotValues(Slot slot, Slot slot2, Collection collection) {
        Facet facet = (Facet)this.getDirectOwnSlotValue(slot2, this.getSystemFrames().getAssociatedFacetSlot());
        for (Slot slot3 : this.getSuperslots(slot)) {
            List list = this.getDirectOwnSlotValues(slot3, slot2);
            if (facet == null) {
                collection.addAll(list);
                continue;
            }
            Collection collection2 = facet.resolveValues(collection, list);
            if (((Object)collection2).equals(collection)) continue;
            collection.clear();
            collection.addAll(collection2);
        }
    }

    private void addInheritedTemplateSlotValues(Frame frame, Slot slot, Collection collection) {
        if (frame instanceof Instance) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Instance instance = (Instance)frame;
            for (Cls cls : this.getTypes(instance)) {
                linkedHashSet.addAll(this.getDirectTemplateSlotValues(cls, slot));
            }
            collection.addAll(linkedHashSet);
        }
    }

    private void addSubslotValues(Frame frame, Slot slot, Collection collection) {
        for (Slot slot2 : this.getSubslots(slot)) {
            collection.addAll(this.getDirectOwnSlotValues(frame, slot2));
        }
    }

    private Set getCacheOwnFacets(Frame frame, Slot slot) {
        HashSet<Facet> hashSet = new HashSet<Facet>();
        for (Slot slot2 : this.getOwnSlots(slot)) {
            Facet facet = (Facet)this.getDirectOwnSlotValue(slot2, this.getSystemFrames().getAssociatedFacetSlot());
            if (facet == null) continue;
            hashSet.add(facet);
        }
        return hashSet;
    }

    private Collection getCacheTemplateSlotValues(Cls cls, Slot slot) {
        return this.getTemplateFacetValues(cls, slot, this.getSystemFrames().getValuesFacet());
    }

    private Set getCacheOwnSlots(Frame frame) {
        Set set = this.getTypes((Instance)frame);
        Set set2 = this.collectOwnSlotValues(set, this.getSystemFrames().getDirectTemplateSlotsSlot());
        set2.add(this.getSystemFrames().getNameSlot());
        set2.add(this.getSystemFrames().getDirectTypesSlot());
        return set2;
    }

    private Set collectOwnSlotValues(Collection collection, Slot slot) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Object[] objectArray = collection.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            Frame frame = (Frame)objectArray[i];
            linkedHashSet.addAll(this.getDirectOwnSlotValues(frame, slot));
        }
        return linkedHashSet;
    }

    private Set getCacheTemplateSlots(Cls cls) {
        LinkedHashSet<Cls> linkedHashSet = new LinkedHashSet<Cls>(this.getSuperclasses(cls));
        linkedHashSet.add(cls);
        Set set = this.collectOwnSlotValues(linkedHashSet, this.getSystemFrames().getDirectTemplateSlotsSlot());
        return set;
    }

    private Set getCacheDomain(Slot slot) throws RemoteException {
        return this.getCacheOwnSlotValueClosure(this.getDirectDomain(slot), this.getSystemFrames().getDirectSubclassesSlot());
    }

    private void processEvents(Collection collection) throws RemoteException {
        for (Object e : collection) {
            Slot slot;
            Frame frame;
            FrameEvent frameEvent;
            if (!(e instanceof FrameEvent) || (frameEvent = (FrameEvent)e).getEventType() != 110 || !this.isOwnSlotValueCached(frame = frameEvent.getFrame(), slot = frameEvent.getSlot())) continue;
            List list = this.getRemoteDelegate().getDirectOwnSlotValues(frame, slot, this.session);
            this.localize(list);
            this.setCacheOwnSlotValues(frame, slot, list);
        }
    }

    private boolean isOwnSlotValueCached(Frame frame, Slot slot) {
        boolean bl = false;
        Map<Sft, List> map = this.cache.get(frame);
        if (map != null) {
            this.lookupSft.set(slot, null, false);
            bl = map.containsKey(this.lookupSft) ? map.get(this.lookupSft) != null : true;
        }
        return bl;
    }

    private void loadReturnedValues(Collection collection) throws RemoteException {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Object e : collection) {
            Frame frame;
            if (!(e instanceof Frame) || this.cache.get(frame = (Frame)e) != null) continue;
            arrayList.add(frame);
        }
        if (!arrayList.isEmpty()) {
            // empty if block
        }
    }

    private void checkFrames(Collection collection) {
        for (Frame frame : collection) {
            if (this.cache.get(frame) != null) continue;
            Log.getLogger().warning("Missing frame: " + frame.getFrameID());
            this.cache.put(frame, new HashMap());
        }
    }

    static {
        boolean bl = true;
        String string = System.getProperty("remote.client.preload");
        if (string != null) {
            try {
                preloadRemoteClient = Boolean.getBoolean(string);
            }
            catch (Exception exception) {
                preloadRemoteClient = bl;
            }
        }
    }
}

