/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLVariable;
import edu.stanford.smi.protegex.owl.swrl.model.impl.tests.AbstractSWRLTestCase;
import java.util.Collections;

public class DeleteImpTestCase
extends AbstractSWRLTestCase {
    public void testDeleteVariable() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        int oldFrameCount = this.owlModel.getFrameCount();
        SWRLVariable x = this.factory.createVariable("x");
        SWRLClassAtom headAtom = this.factory.createClassAtom(cls, x);
        SWRLClassAtom bodyAtom = this.factory.createClassAtom(cls, x);
        SWRLImp imp = this.factory.createImp(headAtom, Collections.singleton(bodyAtom));
        imp.deleteImp();
        DeleteImpTestCase.assertEquals((int)oldFrameCount, (int)this.owlModel.getFrameCount());
        DeleteImpTestCase.assertTrue((boolean)x.isDeleted());
    }

    public void testDontDeleteVariable() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Cls");
        SWRLVariable x = this.factory.createVariable("x");
        SWRLImp otherImp = this.factory.createImp(this.factory.createClassAtom(cls, x), Collections.EMPTY_LIST);
        String otherImpText = otherImp.getBrowserText();
        SWRLClassAtom headAtom = this.factory.createClassAtom(cls, x);
        SWRLClassAtom bodyAtom = this.factory.createClassAtom(cls, x);
        SWRLImp imp = this.factory.createImp(headAtom, Collections.singleton(bodyAtom));
        imp.deleteImp();
        DeleteImpTestCase.assertFalse((boolean)x.isDeleted());
        DeleteImpTestCase.assertEquals((String)otherImpText, (String)otherImp.getBrowserText());
    }
}

