/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.code;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.code.OWLSymbolPanel;
import edu.stanford.smi.protegex.owl.ui.code.OWLTextArea;
import edu.stanford.smi.protegex.owl.ui.dialogs.ModalDialogFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class OWLTextAreaPanel
extends JPanel
implements ModalDialogFactory.CloseCallback {
    private OWLModel owlModel;
    private OWLSymbolPanel symbolPanel;
    private OWLTextArea textArea;

    OWLTextAreaPanel(OWLModel anOWLModel, RDFSClass inputClass) {
        this.owlModel = anOWLModel;
        this.symbolPanel = new OWLSymbolPanel(anOWLModel, false);
        this.textArea = new OWLTextArea(anOWLModel, this.symbolPanel){

            protected void checkExpression(String text) throws Throwable {
                OWLTextAreaPanel.this.owlModel.getOWLClassDisplay().getParser().checkClass(OWLTextAreaPanel.this.owlModel, text);
            }
        };
        this.textArea.setPreferredSize(new Dimension(600, 300));
        if (inputClass != null) {
            this.textArea.setText(inputClass);
        }
        this.symbolPanel.setSymbolEditor(this.textArea);
        this.setLayout(new BorderLayout());
        this.add("Center", new JScrollPane(this.textArea));
        this.add("South", this.symbolPanel);
    }

    public boolean canClose(int result) {
        if (result == 1) {
            String text = this.textArea.getText();
            if (text.length() == 0) {
                return false;
            }
            try {
                this.owlModel.getOWLClassDisplay().getParser().checkClass(this.owlModel, text);
                return true;
            }
            catch (Throwable ex) {
                this.symbolPanel.displayError(ex);
                return false;
            }
        }
        return true;
    }

    String getResultAsString() {
        return this.textArea.getText();
    }

    public static String showEditDialog(Component parent, OWLModel owlModel, RDFSClass input) {
        OWLTextAreaPanel panel = new OWLTextAreaPanel(owlModel, input);
        String title = "Edit OWL Expression";
        if (ProtegeUI.getModalDialogFactory().showDialog(parent, panel, title, 11, panel) == 1) {
            return panel.getResultAsString();
        }
        return null;
    }
}

