/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.junit;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.junit.TestItem;
import junit.framework.TestCase;

public class SyntaxTest
extends TestCase {
    static int count = 0;
    String queryString;
    boolean expectLegalSyntax;
    TestItem testItem;

    public SyntaxTest(String string, TestItem testItem) {
        this(string, testItem, true);
    }

    public SyntaxTest(String string, TestItem testItem, boolean bl) {
        super(string);
        this.testItem = testItem;
        this.expectLegalSyntax = bl;
    }

    public SyntaxTest(String string, boolean bl) {
        this(bl ? string : "X: " + string, string, bl);
    }

    public SyntaxTest(String string) {
        this(string, true);
    }

    public SyntaxTest(String string, String string2) {
        this(string, string2, true);
    }

    public SyntaxTest(String string, String string2, boolean bl) {
        this.setTest(string, string2, bl);
    }

    private void setTest(String string, String string2, boolean bl) {
        super.setName(string);
        this.queryString = string2;
        this.expectLegalSyntax = bl;
    }

    protected void runTest() throws Throwable {
        try {
            Query query2 = null;
            query2 = this.queryString == null ? this.queryFromTestItem(this.testItem) : this.queryFromString(this.queryString);
            if (!this.expectLegalSyntax) {
                SyntaxTest.fail((String)"Expected parse failure");
            }
        }
        catch (QueryException queryException) {
            if (this.expectLegalSyntax) {
                throw queryException;
            }
        }
        catch (Exception exception) {
            SyntaxTest.fail((String)("Exception: " + exception.getClass().getName() + ": " + exception.getMessage()));
        }
    }

    private Query queryFromString(String string) {
        Query query2 = QueryFactory.create(string);
        return query2;
    }

    private Query queryFromTestItem(TestItem testItem) {
        if (testItem.getQueryFile() == null) {
            SyntaxTest.fail((String)"Query test file is null");
            return null;
        }
        Query query2 = QueryFactory.read(testItem.getQueryFile(), null, testItem.getQueryFileSyntax());
        return query2;
    }
}

