/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.PopupMenuMouseListener;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.actions.CopyPropertyValueAction;
import edu.stanford.smi.protegex.owl.ui.actions.DeleteAllPropertyValuesAction;
import edu.stanford.smi.protegex.owl.ui.actions.DeleteMatchingPropertyValuesAction;
import edu.stanford.smi.protegex.owl.ui.actions.triple.TripleAction;
import edu.stanford.smi.protegex.owl.ui.actions.triple.TripleActionManager;
import edu.stanford.smi.protegex.owl.ui.actions.triple.TripleActionSwingAction;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.results.TripleDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TriplesTable
extends JTable
implements TripleDisplay {
    private TriplesTableModel tableModel;
    private JTextField textField;
    private JComboBox typeComboBox;

    public TriplesTable(Project project, TriplesTableModel model, final String partialActionName) {
        super(model);
        this.tableModel = model;
        model.setTable(this);
        this.textField = new JTextField();
        OWLUI.addCopyPastePopup(this.textField);
        this.setDefaultEditor(Object.class, new DefaultCellEditor(this.textField));
        TableColumn propertyColumn = this.getColumnModel().getColumn(0);
        TableColumn valueColumn = this.getColumnModel().getColumn(1);
        TableColumn languageColumn = this.getColumnModel().getColumn(this.tableModel.getColumnCount() - 1);
        propertyColumn.setCellRenderer((TableCellRenderer)new FrameRenderer());
        valueColumn.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        OWLModel owlModel = (OWLModel)project.getKnowledgeBase();
        JComboBox comboBox = ComponentUtil.createLangCellEditor(owlModel, this);
        languageColumn.setCellEditor(new DefaultCellEditor(comboBox));
        if (this.tableModel.hasTypeColumn()) {
            TableColumn typeColumn = this.getColumnModel().getColumn(this.tableModel.getColumnCount() - 2);
            typeColumn.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
            Vector datatypes = new Vector();
            this.typeComboBox = new JComboBox(datatypes);
            this.typeComboBox.setRenderer(new ResourceRenderer());
            typeColumn.setCellEditor(new DefaultCellEditor(this.typeComboBox));
        }
        this.setAutoResizeMode(4);
        this.getTableHeader().setReorderingAllowed(false);
        this.setShowGrid(false);
        this.setRowMargin(0);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setSelectionMode(0);
        propertyColumn.setPreferredWidth(100);
        valueColumn.setPreferredWidth(200);
        languageColumn.setPreferredWidth(60);
        languageColumn.setMaxWidth(100);
        this.addMouseListener((MouseListener)new PopupMenuMouseListener(this){

            protected JPopupMenu getPopupMenu() {
                return TriplesTable.this.createPopupMenu(partialActionName);
            }

            protected void setSelection(JComponent c, int x, int y) {
                int row = y / TriplesTable.this.getRowHeight();
                if (row >= 0 && row < TriplesTable.this.getRowCount()) {
                    TriplesTable.this.getSelectionModel().setSelectionInterval(row, row);
                }
            }
        });
    }

    protected JPopupMenu createPopupMenu(String partialActionName) {
        TriplesTableModel tableModel = (TriplesTableModel)this.getModel();
        RDFResource resource = tableModel.getSubject();
        final JPopupMenu menu = new JPopupMenu();
        int row = this.getSelectedRow();
        RDFProperty property = tableModel.getPredicate(row);
        Object value = tableModel.getValue(row);
        if (property.isAnnotationProperty()) {
            if (resource instanceof RDFSNamedClass) {
                RDFSNamedClass rootClass = (RDFSNamedClass)resource;
                ArrayList<RDFSClass> targetResources = new ArrayList<RDFSClass>();
                for (RDFSClass subClass : rootClass.getSubclasses(true)) {
                    if (!(subClass instanceof RDFSNamedClass)) continue;
                    targetResources.add(subClass);
                }
                menu.add(new CopyPropertyValueAction("subclasses", property, value, targetResources, partialActionName));
                menu.add(new DeleteMatchingPropertyValuesAction("subclasses", property, value, targetResources, partialActionName));
                menu.add(new DeleteAllPropertyValuesAction("subclasses", property, targetResources, partialActionName));
            } else if (resource instanceof RDFProperty) {
                ArrayList targetResources = new ArrayList(((RDFProperty)resource).getSubproperties(true));
                menu.add(new CopyPropertyValueAction("subproperties", property, value, targetResources, partialActionName));
                menu.add(new DeleteMatchingPropertyValuesAction("subproperties", property, value, targetResources, partialActionName));
                menu.add(new DeleteAllPropertyValuesAction("subproperties", property, targetResources, partialActionName));
            }
        }
        final DefaultTriple triple = new DefaultTriple(tableModel.getSubject(), property, value);
        TripleActionManager.addTripleActionsToMenu(triple, new TripleActionManager.Adder(){

            public void addTripleAction(TripleAction action) {
                menu.add(new TripleActionSwingAction(action, triple));
            }
        });
        if (menu.getComponentCount() > 0) {
            return menu;
        }
        return null;
    }

    public boolean displayTriple(Triple triple) {
        int row;
        if (triple.getSubject().equals(this.tableModel.getSubject()) && (row = this.tableModel.getPropertyValueRow(triple.getPredicate(), triple.getObject())) >= 0) {
            this.getSelectionModel().setSelectionInterval(row, row);
            this.scrollRectToVisible(this.getCellRect(row, 0, false));
        }
        return false;
    }

    public void editCell(final int row) {
        this.getSelectionModel().setSelectionInterval(row, row);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TriplesTable.this.scrollRectToVisible(TriplesTable.this.getCellRect(row, 1, true));
                TriplesTable.this.textField.requestFocus();
            }
        });
        this.editCellAt(row, 1);
    }

    public TableCellEditor getCellEditor(int row, int column) {
        TriplesTableModel tableModel = (TriplesTableModel)this.getModel();
        RDFProperty property = tableModel.getPredicate(row);
        RDFResource range = property.getRange();
        if (property.getOWLModel().getXSDboolean().equals(range)) {
            JComboBox<Boolean> comboBox = new JComboBox<Boolean>(new Boolean[]{Boolean.FALSE, Boolean.TRUE});
            return new DefaultCellEditor(comboBox);
        }
        if (range instanceof OWLDataRange) {
            List allowedValues = ((OWLDataRange)range).getOneOfValues();
            JComboBox<Object> comboBox = new JComboBox<Object>(allowedValues.toArray());
            return new DefaultCellEditor(comboBox);
        }
        return super.getCellEditor(row, column);
    }

    public TriplesTableModel getTableModel() {
        return this.tableModel;
    }

    public void setValueAt(Object aValue, int row, int column) {
        RDFProperty property = this.tableModel.getPredicate(row);
        Object newValue = this.tableModel.setValueAndGetIt(aValue, row, column);
        this.setSelectedRow(property, newValue);
    }

    private void setSelectedRow(RDFProperty property, Object value) {
        int sel = this.getSelectedRow();
        int row = this.tableModel.getPropertyValueRow(property, value);
        if (row >= 0) {
            sel = row;
        }
        if (sel >= 0 && sel < this.tableModel.getRowCount()) {
            this.getSelectionModel().setSelectionInterval(sel, sel);
        }
    }
}

