/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.util.ResourceCopier;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class AbstractRDFSClass
extends DefaultCls
implements RDFSClass {
    public AbstractRDFSClass(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    AbstractRDFSClass() {
    }

    protected void addAnonymousClses(Collection target, Collection clses) {
        for (Cls cls : clses) {
            if (!(cls instanceof OWLAnonymousClass)) continue;
            target.add(cls);
        }
    }

    public void addClassListener(ClassListener listener) {
        if (!(listener instanceof ClassAdapter)) {
            throw new IllegalArgumentException("Listener must be a ClassAdapter");
        }
        this.addClsListener(listener);
    }

    public void addSuperclass(RDFSClass superclass) {
        this.getKnowledgeBase().addDirectSuperclass((Cls)this, (Cls)superclass);
    }

    public void addToUnionDomainOf(RDFProperty property) {
        this.getKnowledgeBase().addDirectTemplateSlot((Cls)this, (Slot)property);
    }

    public RDFSClass createClone() {
        ResourceCopier copier = new ResourceCopier();
        this.accept(copier);
        return (RDFSClass)copier.getCopy();
    }

    public RDFResource createInstance(String name) {
        return (RDFResource)this.getKnowledgeBase().createInstance(name, (Cls)this);
    }

    protected AbstractOWLModel getAbstractOWLModel() {
        return (AbstractOWLModel)this.getKnowledgeBase();
    }

    public RDFSClass getDefinition() {
        for (Cls cls : this.getDirectSuperclasses()) {
            if (!(cls instanceof RDFSClass) || !cls.hasDirectSuperclass((Cls)this)) continue;
            return (RDFSClass)cls;
        }
        return null;
    }

    public Collection getUnionDomainProperties() {
        return this.getUnionDomainProperties(false);
    }

    public Collection getPureSuperclasses() {
        Collection directSuperclasses = this.getDirectSuperclasses();
        ArrayList result = new ArrayList(directSuperclasses);
        for (Cls cls : directSuperclasses) {
            if (!(cls instanceof RDFSClass) || !cls.hasDirectSuperclass((Cls)this)) continue;
            result.remove(cls);
            if (!(cls instanceof OWLIntersectionClass)) continue;
            for (RDFSClass operand : ((OWLIntersectionClass)cls).getOperands()) {
                if (!(operand instanceof OWLNamedClass)) continue;
                result.remove(operand);
            }
        }
        return result;
    }

    public Object getDirectTemplateFacetValue(Slot slot, Facet facet) {
        List values = this.getDirectTemplateFacetValues(slot, facet);
        if (values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    public Collection getUnionDomainProperties(boolean transitive) {
        if (transitive) {
            return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getTemplateSlots((Cls)this));
        }
        return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getDirectTemplateSlots((Cls)this));
    }

    private Collection getVisibleFrames(Collection frames) {
        ArrayList<Frame> visibleFrames = new ArrayList<Frame>();
        for (Frame frame : frames) {
            if (!frame.isVisible()) continue;
            visibleFrames.add(frame);
        }
        return visibleFrames;
    }

    public Collection getDisjointClasses() {
        RDFProperty disjointClassesSlot = this.getOWLModel().getOWLDisjointWithProperty();
        return this.getOwnSlotValues(disjointClassesSlot);
    }

    public Collection getEquivalentClasses() {
        ArrayList<Cls> result = new ArrayList<Cls>();
        for (Cls cls : this.getDirectSuperclasses()) {
            if (!(cls instanceof RDFSClass) || !cls.hasDirectSuperclass((Cls)this)) continue;
            result.add(cls);
        }
        return result;
    }

    public int getInferredInstanceCount() {
        return this.getInferredInstances(false).size();
    }

    public Collection getInferredInstances(boolean includingSubclasses) {
        RDFProperty inferredTypesProperty = this.getOWLModel().getRDFProperty("protege:inferredType");
        if (includingSubclasses) {
            HashSet results = new HashSet();
            results.addAll(this.getKnowledgeBase().getFramesWithValue((Slot)inferredTypesProperty, null, false, (Object)this));
            for (RDFSClass subclass : this.getSubclasses(true)) {
                results.addAll(this.getKnowledgeBase().getFramesWithValue((Slot)inferredTypesProperty, null, false, (Object)subclass));
            }
            return results;
        }
        return this.getKnowledgeBase().getFramesWithValue((Slot)inferredTypesProperty, null, false, (Object)this);
    }

    public int getInstanceCount(boolean includingSubclasses) {
        if (includingSubclasses) {
            return this.getKnowledgeBase().getInstanceCount((Cls)this);
        }
        return this.getKnowledgeBase().getDirectInstanceCount((Cls)this);
    }

    public Collection getInstances(boolean includingSubclasses) {
        if (includingSubclasses) {
            return this.getKnowledgeBase().getInstances((Cls)this);
        }
        return this.getKnowledgeBase().getDirectInstances((Cls)this);
    }

    public Collection getNamedSubclasses() {
        return this.getNamedSubclasses(false);
    }

    public Collection getNamedSuperclasses() {
        return this.getNamedSuperclasses(false);
    }

    public Collection getNamedSubclasses(boolean transitive) {
        ArrayList<Cls> result = new ArrayList<Cls>();
        for (Cls cls : this.getSubclasses(transitive)) {
            if (!(cls instanceof RDFSNamedClass)) continue;
            result.add(cls);
        }
        return result;
    }

    public Collection getNamedSuperclasses(boolean transitive) {
        ArrayList<Cls> result = new ArrayList<Cls>();
        for (Cls cls : this.getSuperclasses(transitive)) {
            if (!(cls instanceof RDFSNamedClass)) continue;
            result.add(cls);
        }
        return result;
    }

    public String getParsableExpression() {
        return this.getBrowserText();
    }

    public int getSubclassCount() {
        if (Model.ClsID.THING.equals((Object)this.getFrameID())) {
            return this.getSubclasses(false).size();
        }
        return this.getKnowledgeBase().getDirectSubclassCount((Cls)this);
    }

    public Collection getSubclasses(boolean transitive) {
        if (Model.ClsID.THING.equals((Object)this.getFrameID())) {
            if (transitive) {
                return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getSubclasses((Cls)this));
            }
            return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getDirectSubclasses((Cls)this));
        }
        if (transitive) {
            return this.getKnowledgeBase().getSubclasses((Cls)this);
        }
        return this.getKnowledgeBase().getDirectSubclasses((Cls)this);
    }

    public int getSuperclassCount() {
        return this.getSuperclasses(false).size();
    }

    public Collection getSuperclasses(boolean transitive) {
        if (transitive) {
            return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getSuperclasses((Cls)this));
        }
        return AbstractOWLModel.getRDFResources(this.getKnowledgeBase(), this.getKnowledgeBase().getDirectSuperclasses((Cls)this));
    }

    public boolean hasPropertyValueWithBrowserText(RDFProperty property, String browserText) {
        return this.hasPropertyValueWithBrowserText((Slot)property, browserText);
    }

    public boolean hasPropertyValueWithBrowserText(Slot property, String browserText) {
        for (Frame value : this.getDirectOwnSlotValues(property)) {
            if (!browserText.equals(value.getBrowserText())) continue;
            return true;
        }
        return false;
    }

    public boolean hasEquivalentClass(RDFSClass other) {
        return this.hasDirectSuperclass(other) && other.isSubclassOf(this);
    }

    public boolean isMetaclass() {
        return this.getKnowledgeBase().isMetaCls((Cls)this);
    }

    public boolean isSubclassOf(RDFSClass superclass) {
        return this.getKnowledgeBase().hasDirectSuperclass((Cls)this, (Cls)superclass);
    }

    public void removeClassListener(ClassListener listener) {
        if (!(listener instanceof ClassAdapter)) {
            throw new IllegalArgumentException("Listener must be a ClassAdapter");
        }
        this.removeClsListener(listener);
    }

    public void removeSuperclass(RDFSClass superclass) {
        this.getKnowledgeBase().removeDirectSuperclass((Cls)this, (Cls)superclass);
    }

    public void addComment(String comment) {
        OWLUtil.addComment(this, comment);
    }

    public void addDifferentFrom(RDFResource resource) {
        OWLUtil.addDifferentFrom(this, resource);
    }

    public void addIsDefinedBy(RDFResource instance) {
        OWLUtil.addIsDefinedBy(this, instance);
    }

    public void addLabel(String label, String language) {
        OWLUtil.addLabel(this, label, language);
    }

    public void addPropertyValue(RDFProperty property, Object value) {
        OWLUtil.addPropertyValue(this, property, value);
    }

    public void addPropertyValueListener(PropertyValueListener listener) {
        OWLUtil.addPropertyValueListener(this, listener);
    }

    public void addProtegeType(RDFSClass type) {
        OWLUtil.addProtegeType(this, type);
    }

    public void addRDFType(RDFSClass type) {
        OWLUtil.addRDFType(this, type);
    }

    public void addResourceListener(ResourceListener listener) {
        OWLUtil.addResourceListener(this, listener);
    }

    public void addSameAs(RDFResource resource) {
        OWLUtil.addSameAs(this, resource);
    }

    public void addVersionInfo(String versionInfo) {
        OWLUtil.addVersionInfo(this, versionInfo);
    }

    public RDFResource as(Class javaInterface) {
        return OWLUtil.as(this, javaInterface);
    }

    public boolean canAs(Class javaInterface) {
        return OWLUtil.canAs(this, javaInterface);
    }

    public RDFResource getAllValuesFromOnTypes(RDFProperty property) {
        return OWLUtil.getAllValuesFromOnTypes(this, property);
    }

    public Collection getComments() {
        return OWLUtil.getComments(this);
    }

    public Collection getDifferentFrom() {
        return OWLUtil.getDifferentFrom(this);
    }

    public Collection getHasValuesOnTypes(RDFProperty property) {
        return OWLUtil.getHasValuesOnTypes(this, property);
    }

    public Class getIconLocation() {
        return OWLIcons.class;
    }

    public RDFSClass getProtegeType() {
        return OWLUtil.getDirectRDFType(this);
    }

    public Collection getProtegeTypes() {
        return OWLUtil.getDirectRDFTypes(this);
    }

    public Collection getDocumentation() {
        return OWLUtil.getComments(this);
    }

    public Collection getInferredTypes() {
        return OWLUtil.getInferredDirectTypes(this);
    }

    public Collection getIsDefinedBy() {
        return OWLUtil.getIsDefinedBy(this);
    }

    public Collection getLabels() {
        return OWLUtil.getLabels(this);
    }

    public String getLocalName() {
        String name = this.getName();
        OWLModel nskb = (OWLModel)this.getKnowledgeBase();
        return nskb.getLocalNameForResourceName(name);
    }

    public String getNamespace() {
        OWLModel nskb = (OWLModel)this.getKnowledgeBase();
        String name = this.getName();
        return nskb.getNamespaceForResourceName(name);
    }

    public String getNamespacePrefix() {
        OWLModel nskb = (OWLModel)this.getKnowledgeBase();
        String name = this.getName();
        return nskb.getPrefixForResourceName(name);
    }

    public OWLModel getOWLModel() {
        return (OWLModel)this.getKnowledgeBase();
    }

    public Collection getPossibleRDFProperties() {
        return OWLUtil.getPossibleRDFProperties(this);
    }

    public Object getPropertyValue(RDFProperty property) {
        return OWLUtil.getPropertyValue(this, property, false);
    }

    public RDFResource getPropertyValueAs(RDFProperty property, Class javaInterface) {
        return OWLUtil.getPropertyValueAs(this, property, javaInterface);
    }

    public Object getPropertyValue(RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.getPropertyValue(this, property, includingSubproperties);
    }

    public int getPropertyValueCount(RDFProperty property) {
        return OWLUtil.getPropertyValueCount(this, property);
    }

    public RDFSLiteral getPropertyValueLiteral(RDFProperty property) {
        return OWLUtil.getPropertyValueLiteral(this, property);
    }

    public Collection getPropertyValueLiterals(RDFProperty property) {
        return OWLUtil.getPropertyValueLiterals(this, property);
    }

    public Collection getPropertyValues(RDFProperty property) {
        return OWLUtil.getPropertyValues(this, property, false);
    }

    public Collection getPropertyValuesAs(RDFProperty property, Class javaInterface) {
        return OWLUtil.getPropertyValuesAs(this, property, javaInterface);
    }

    public Collection getPropertyValues(RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.getPropertyValues(this, property, includingSubproperties);
    }

    public Set getReferringAnonymousClasses() {
        return OWLUtil.getReferringAnonymousClses(this);
    }

    public Collection getRDFProperties() {
        return OWLUtil.getRDFProperties(this);
    }

    public RDFSClass getRDFType() {
        return OWLUtil.getRDFType(this);
    }

    public Collection getRDFTypes() {
        return OWLUtil.getRDFTypes(this);
    }

    public Collection getSameAs() {
        return OWLUtil.getSameAs(this);
    }

    public String getURI() {
        return this.getOWLModel().getURIForResourceName(this.getName());
    }

    public Collection getVersionInfo() {
        return OWLUtil.getVersionInfo(this);
    }

    public boolean hasPropertyValue(RDFProperty property) {
        return OWLUtil.hasPropertyValue(this, property);
    }

    public boolean hasPropertyValue(RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.hasPropertyValue(this, property, includingSubproperties);
    }

    public boolean hasPropertyValue(RDFProperty property, Object value) {
        return this.hasPropertyValue(property, value, false);
    }

    public boolean hasPropertyValue(RDFProperty property, Object value, boolean includingSuperproperties) {
        return OWLUtil.hasPropertyValue(this, property, value, includingSuperproperties);
    }

    public boolean hasProtegeType(RDFSClass type) {
        return OWLUtil.hasProtegeType(this, type);
    }

    public boolean hasProtegeType(RDFSClass type, boolean includingSuperclasses) {
        return OWLUtil.hasProtegeType(this, type, includingSuperclasses);
    }

    public boolean hasRDFType(RDFSClass type) {
        return OWLUtil.hasRDFType(this, type);
    }

    public boolean hasRDFType(RDFSClass type, boolean includingSuperclasses) {
        return OWLUtil.hasRDFType(this, type, includingSuperclasses);
    }

    public boolean isValidPropertyValue(RDFProperty property, Object object) {
        return OWLUtil.isValidPropertyValue(this, property, object);
    }

    public Iterator listPropertyValues(RDFProperty property) {
        return OWLUtil.listPropertyValues(this, property, false);
    }

    public Iterator listPropertyValuesAs(RDFProperty property, Class javaInterface) {
        return OWLUtil.listPropertyValuesAs(this, property, javaInterface);
    }

    public Iterator listPropertyValues(RDFProperty property, boolean includingSubproperties) {
        return OWLUtil.listPropertyValues(this, property, includingSubproperties);
    }

    public Iterator listRDFTypes() {
        return this.getRDFTypes().iterator();
    }

    public void removeComment(String value) {
        OWLUtil.removeComment(this, value);
    }

    public void removeDifferentFrom(RDFResource resource) {
        OWLUtil.removeDifferentFrom(this, resource);
    }

    public void removeIsDefinedBy(RDFResource resource) {
        OWLUtil.removeIsDefinedBy(this, resource);
    }

    public void removeLabel(String label, String language) {
        OWLUtil.removeLabel(this, label, language);
    }

    public void removePropertyValue(RDFProperty property, Object value) {
        OWLUtil.removePropertyValue(this, property, value);
    }

    public void removePropertyValueListener(PropertyValueListener listener) {
        OWLUtil.removePropertyValueListener(this, listener);
    }

    public void removeProtegeType(RDFSClass type) {
        OWLUtil.removeProtegeType(this, type);
    }

    public void removeRDFType(RDFSClass type) {
        OWLUtil.removeRDFType(this, type);
    }

    public void removeResourceListener(ResourceListener listener) {
        OWLUtil.removeResourceListener(this, listener);
    }

    public void removeSameAs(RDFResource resource) {
        OWLUtil.removeSameAs(this, resource);
    }

    public void removeVersionInfo(String versionInfo) {
        OWLUtil.removeVersionInfo(this, versionInfo);
    }

    public void setComment(String comment) {
        OWLUtil.setComment(this, comment);
    }

    public void setComments(Collection comments) {
        OWLUtil.setComments(this, comments);
    }

    public void setDocumentation(String value) {
        OWLUtil.setComment(this, value);
    }

    public void setInferredTypes(Collection types) {
        OWLUtil.setInferredTypes(this, types);
    }

    public void setPropertyValue(RDFProperty property, Object value) {
        OWLUtil.setPropertyValue(this, property, value);
    }

    public void setPropertyValues(RDFProperty property, Collection values) {
        OWLUtil.setPropertyValues(this, property, values);
    }

    public void setProtegeType(RDFSClass type) {
        OWLUtil.setProtegeType(this, type);
    }

    public void setRDFType(RDFSClass type) {
        OWLUtil.setRDFType(this, type);
    }

    public void setRDFTypes(Collection types) {
        OWLUtil.setRDFTypes(this, types);
    }

    public void setProtegeTypes(Collection types) {
        OWLUtil.setProtegeTypes(this, types);
    }
}

